/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor.groupby.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.executor.groupby.AlignedGroupByExecutor;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.query.reader.series.AlignedSeriesAggregateReader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.IBatchDataIterator;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;

public class LocalAlignedGroupByExecutor
implements AlignedGroupByExecutor {
    private final AlignedSeriesAggregateReader reader;
    private BatchData preCachedData;
    private final List<List<AggregateResult>> results = new ArrayList<List<AggregateResult>>();
    private final TimeRange timeRange;
    private int lastReadCurArrayIndex;
    private int lastReadCurListIndex;
    private final boolean ascending;
    private final QueryDataSource queryDataSource;

    public LocalAlignedGroupByExecutor(PartialPath path, QueryContext context, Filter timeFilter, TsFileFilter fileFilter, boolean ascending) throws StorageEngineException, QueryProcessException {
        this.queryDataSource = QueryResourceManager.getInstance().getQueryDataSource(path, context, timeFilter, ascending);
        timeFilter = this.queryDataSource.updateFilterUsingTTL(timeFilter);
        HashSet<String> allSensors = new HashSet<String>(((AlignedPath)path).getMeasurementList());
        this.reader = new AlignedSeriesAggregateReader((AlignedPath)path, allSensors, TSDataType.VECTOR, context, this.queryDataSource, timeFilter, null, fileFilter, ascending);
        this.preCachedData = null;
        this.timeRange = new TimeRange(Long.MIN_VALUE, Long.MAX_VALUE);
        this.ascending = ascending;
    }

    @Override
    public void addAggregateResult(List<AggregateResult> aggregateResults) {
        this.results.add(aggregateResults);
    }

    @Override
    public List<List<AggregateResult>> calcAlignedResult(long curStartTime, long curEndTime) throws IOException, QueryProcessException {
        for (List<AggregateResult> resultsOfOneMeasurement : this.results) {
            for (AggregateResult result : resultsOfOneMeasurement) {
                result.reset();
            }
        }
        this.timeRange.set(curStartTime, curEndTime - 1L);
        if (this.calcFromCacheData(curStartTime, curEndTime)) {
            return this.results;
        }
        if (this.readAndCalcFromPage(curStartTime, curEndTime)) {
            return this.results;
        }
        if (this.readAndCalcFromChunk(curStartTime, curEndTime)) {
            return this.results;
        }
        while (this.reader.hasNextFile()) {
            if (this.reader.canUseCurrentFileStatistics()) {
                Statistics fileTimeStatistics = this.reader.currentFileTimeStatistics();
                if (fileTimeStatistics.getStartTime() >= curEndTime) {
                    if (this.ascending) {
                        return this.results;
                    }
                    this.reader.skipCurrentFile();
                    continue;
                }
                if (this.timeRange.contains(fileTimeStatistics.getStartTime(), fileTimeStatistics.getEndTime())) {
                    while (this.reader.hasNextSubSeries()) {
                        Statistics currentFileStatistics = this.reader.currentFileStatistics();
                        this.calcFromStatistics(currentFileStatistics, this.results.get(this.reader.getCurIndex()));
                        this.reader.nextSeries();
                    }
                    this.reader.skipCurrentFile();
                    continue;
                }
            }
            if (!this.readAndCalcFromChunk(curStartTime, curEndTime)) continue;
            return this.results;
        }
        return this.results;
    }

    private void calcFromStatistics(Statistics statistics, List<AggregateResult> aggregateResultList) throws QueryProcessException {
        if (statistics == null) {
            return;
        }
        if (statistics.getStartTime() == Long.MAX_VALUE && statistics.getEndTime() == Long.MIN_VALUE) {
            return;
        }
        for (AggregateResult result : aggregateResultList) {
            if (result.hasFinalResult()) continue;
            result.updateResultFromStatistics(statistics);
        }
    }

    private boolean readAndCalcFromChunk(long curStartTime, long curEndTime) throws IOException, QueryProcessException {
        while (this.reader.hasNextChunk()) {
            if (this.reader.canUseCurrentChunkStatistics()) {
                Statistics chunkTimeStatistics = this.reader.currentChunkTimeStatistics();
                if (chunkTimeStatistics.getStartTime() >= curEndTime) {
                    if (this.ascending) {
                        return true;
                    }
                    this.reader.skipCurrentChunk();
                    continue;
                }
                if (this.timeRange.contains(chunkTimeStatistics.getStartTime(), chunkTimeStatistics.getEndTime())) {
                    while (this.reader.hasNextSubSeries()) {
                        Statistics currentChunkStatistics = this.reader.currentChunkStatistics();
                        this.calcFromStatistics(currentChunkStatistics, this.results.get(this.reader.getCurIndex()));
                        this.reader.nextSeries();
                    }
                    this.reader.skipCurrentChunk();
                    continue;
                }
            }
            if (!this.readAndCalcFromPage(curStartTime, curEndTime)) continue;
            return true;
        }
        return false;
    }

    private boolean readAndCalcFromPage(long curStartTime, long curEndTime) throws IOException, QueryProcessException {
        while (this.reader.hasNextPage()) {
            BatchData batchData;
            if (this.reader.canUseCurrentPageStatistics()) {
                Statistics pageTimeStatistics = this.reader.currentPageTimeStatistics();
                if (pageTimeStatistics.getStartTime() >= curEndTime) {
                    if (this.ascending) {
                        return true;
                    }
                    this.reader.skipCurrentPage();
                    continue;
                }
                if (this.timeRange.contains(pageTimeStatistics.getStartTime(), pageTimeStatistics.getEndTime())) {
                    while (this.reader.hasNextSubSeries()) {
                        int subIndex = this.reader.getCurIndex();
                        Statistics currentPageStatistics = this.reader.currentPageStatistics();
                        this.calcFromStatistics(currentPageStatistics, this.results.get(subIndex));
                        this.reader.nextSeries();
                    }
                    this.reader.skipCurrentPage();
                    if (!this.isEndCalc()) continue;
                    return true;
                }
            }
            if ((batchData = this.reader.nextPage()) == null || !batchData.hasCurrent()) continue;
            this.lastReadCurArrayIndex = batchData.getReadCurArrayIndex();
            this.lastReadCurListIndex = batchData.getReadCurListIndex();
            if (this.ascending && batchData.currentTime() >= curEndTime) {
                this.preCachedData = batchData;
                return true;
            }
            this.calcFromBatch(batchData, curStartTime, curEndTime);
            if (!this.isEndCalc() && (!batchData.hasCurrent() || !(this.ascending ? batchData.currentTime() >= curEndTime : batchData.currentTime() < curStartTime))) continue;
            return true;
        }
        return false;
    }

    private boolean calcFromCacheData(long curStartTime, long curEndTime) throws IOException {
        this.calcFromBatch(this.preCachedData, curStartTime, curEndTime);
        return this.preCachedData != null && (!this.ascending ? this.preCachedData.getMinTimestamp() < curStartTime : this.preCachedData.getMaxTimestamp() >= curEndTime) || this.isEndCalc();
    }

    private void calcFromBatch(BatchData batchData, long curStartTime, long curEndTime) throws IOException {
        if (!this.satisfied(batchData, curStartTime, curEndTime)) {
            return;
        }
        boolean hasCached = false;
        int curReadCurArrayIndex = this.lastReadCurArrayIndex;
        while (this.reader.hasNextSubSeries()) {
            int subIndex = this.reader.getCurIndex();
            batchData.resetBatchData(this.lastReadCurArrayIndex, this.lastReadCurListIndex);
            List<AggregateResult> aggregateResultList = this.results.get(subIndex);
            for (AggregateResult result : aggregateResultList) {
                if (result.hasFinalResult()) continue;
                batchData.resetBatchData(this.lastReadCurArrayIndex, this.lastReadCurListIndex);
                IBatchDataIterator batchDataIterator = batchData.getBatchDataIterator(subIndex);
                if (this.ascending) {
                    while (batchDataIterator.hasNext(curStartTime, curEndTime) && batchDataIterator.currentTime() < curStartTime) {
                        batchDataIterator.next();
                    }
                } else {
                    while (batchDataIterator.hasNext(curStartTime, curEndTime) && batchDataIterator.currentTime() >= curEndTime) {
                        batchDataIterator.next();
                    }
                }
                if (batchDataIterator.hasNext(curStartTime, curEndTime)) {
                    result.updateResultFromPageData(batchDataIterator, curStartTime, curEndTime);
                }
                curReadCurArrayIndex = this.ascending ? Math.max(curReadCurArrayIndex, batchData.getReadCurArrayIndex()) : Math.min(curReadCurArrayIndex, batchData.getReadCurArrayIndex());
            }
            if (!hasCached && batchData.hasCurrent()) {
                this.preCachedData = batchData;
                hasCached = true;
            }
            this.reader.nextSeries();
        }
        this.lastReadCurArrayIndex = curReadCurArrayIndex;
        this.lastReadCurListIndex = batchData.getReadCurListIndex();
        batchData.resetBatchData(this.lastReadCurArrayIndex, this.lastReadCurListIndex);
    }

    private boolean isEndCalc() {
        for (List<AggregateResult> resultsOfOneMeasurement : this.results) {
            for (AggregateResult result : resultsOfOneMeasurement) {
                if (result.hasFinalResult()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean satisfied(BatchData batchData, long curStartTime, long curEndTime) {
        if (batchData == null || !batchData.hasCurrent()) {
            return false;
        }
        if (this.ascending && (batchData.getMaxTimestamp() < curStartTime || batchData.currentTime() >= curEndTime)) {
            return false;
        }
        if (!(this.ascending || batchData.getTimeByIndex(0) < curEndTime && batchData.currentTime() >= curStartTime)) {
            this.preCachedData = batchData;
            return false;
        }
        return true;
    }
}

