/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.datasource;

import java.io.IOException;
import org.apache.iotdb.db.sync.externalpipe.operation.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOpBlock
implements Comparable<AbstractOpBlock> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractOpBlock.class);
    protected String storageGroup;
    long pipeDataSerialNumber;
    boolean closed = false;
    protected long beginIndex = -1L;
    protected long dataCount = -1L;

    public AbstractOpBlock(String storageGroupName, long pipeDataSerialNumber, long beginIndex) {
        this.storageGroup = storageGroupName;
        this.pipeDataSerialNumber = pipeDataSerialNumber;
        this.beginIndex = beginIndex;
    }

    public String getStorageGroup() {
        return this.storageGroup;
    }

    public long getDataCount() {
        return this.dataCount;
    }

    public void setBeginIndex(long beginIndex) {
        this.beginIndex = beginIndex;
    }

    public long getBeginIndex() {
        return this.beginIndex;
    }

    public long getNextIndex() {
        return this.beginIndex + this.dataCount;
    }

    @Override
    public int compareTo(AbstractOpBlock o) {
        return this.beginIndex > o.beginIndex ? 1 : (this.beginIndex == o.beginIndex ? 0 : -1);
    }

    public abstract Operation getOperation(long var1, long var3) throws IOException;

    public void close() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public long getPipeDataSerialNumber() {
        return this.pipeDataSerialNumber;
    }

    public void setPipeDataSerialNumber(long pipeDataSerialNumber) {
        this.pipeDataSerialNumber = pipeDataSerialNumber;
    }

    public String toString() {
        return "storageGroup=" + this.storageGroup + ", beginIndex=" + this.beginIndex + ", dataCount=" + this.dataCount + ", filePipeSerialNumber=" + this.pipeDataSerialNumber;
    }
}

