/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.trigger.service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.iotdb.commons.path.PatternTreeMap;
import org.apache.iotdb.commons.trigger.TriggerInformation;
import org.apache.iotdb.commons.trigger.TriggerTable;
import org.apache.iotdb.commons.trigger.exception.TriggerManagementException;
import org.apache.iotdb.commons.trigger.service.TriggerExecutableManager;
import org.apache.iotdb.confignode.rpc.thrift.TTriggerState;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.path.PatternTreeMapFactory;
import org.apache.iotdb.db.trigger.executor.TriggerExecutor;
import org.apache.iotdb.db.trigger.service.TriggerClassLoader;
import org.apache.iotdb.db.trigger.service.TriggerClassLoaderManager;
import org.apache.iotdb.trigger.api.Trigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerManagementService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TriggerManagementService.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final TriggerTable triggerTable = new TriggerTable();
    private final Map<String, TriggerExecutor> executorMap = new ConcurrentHashMap<String, TriggerExecutor>();
    private final PatternTreeMap<String, PatternTreeMapFactory.StringSerializer> patternTreeMap = PatternTreeMapFactory.getTriggerPatternTreeMap();
    private static final int DATA_NODE_ID = IoTDBDescriptor.getInstance().getConfig().getDataNodeId();

    private TriggerManagementService() {
    }

    public void acquireLock() {
        this.lock.lock();
    }

    public void releaseLock() {
        this.lock.unlock();
    }

    public void register(TriggerInformation triggerInformation) throws IOException {
        try {
            this.acquireLock();
            this.checkIfRegistered(triggerInformation);
            this.doRegister(triggerInformation);
        }
        finally {
            this.releaseLock();
        }
    }

    public void activeTrigger(String triggerName) {
        try {
            this.acquireLock();
            this.triggerTable.setTriggerState(triggerName, TTriggerState.ACTIVE);
        }
        finally {
            this.releaseLock();
        }
    }

    public void inactiveTrigger(String triggerName) {
        try {
            this.acquireLock();
            this.triggerTable.setTriggerState(triggerName, TTriggerState.INACTIVE);
        }
        finally {
            this.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTrigger(String triggerName, boolean needToDeleteJar) throws IOException {
        try {
            this.acquireLock();
            TriggerInformation triggerInformation = this.triggerTable.removeTriggerInformation(triggerName);
            TriggerExecutor executor = this.executorMap.remove(triggerName);
            if (executor != null) {
                executor.onDrop();
            }
            if (triggerInformation == null) {
                return;
            }
            this.patternTreeMap.delete(triggerInformation.getPathPattern(), (Object)triggerName);
            if (needToDeleteJar) {
                TriggerExecutableManager.getInstance().removeFileUnderLibRoot(triggerInformation.getJarName());
                TriggerExecutableManager.getInstance().removeFileUnderTemporaryRoot(triggerName + ".txt");
            }
        }
        finally {
            this.releaseLock();
        }
    }

    private void checkIfRegistered(TriggerInformation triggerInformation) throws TriggerManagementException {
        String triggerName = triggerInformation.getTriggerName();
        String jarName = triggerInformation.getJarName();
        if (this.triggerTable.containsTrigger(triggerName) && TriggerExecutableManager.getInstance().hasFileUnderLibRoot(jarName) && !this.isLocalJarCorrect(triggerInformation)) {
            String errorMessage = String.format("Failed to registered trigger %s, because existed md5 of jar file for trigger %s is different from the new jar file. ", triggerName, triggerName);
            LOGGER.warn(errorMessage);
            throw new TriggerManagementException(errorMessage);
        }
    }

    public boolean isLocalJarCorrect(TriggerInformation triggerInformation) throws TriggerManagementException {
        String jarName = triggerInformation.getJarName();
        String triggerName = triggerInformation.getTriggerName();
        String existedMd5 = "";
        String md5FilePath = triggerName + ".txt";
        boolean hasComputed = false;
        if (TriggerExecutableManager.getInstance().hasFileUnderTemporaryRoot(md5FilePath)) {
            try {
                existedMd5 = TriggerExecutableManager.getInstance().readTextFromFileUnderTemporaryRoot(md5FilePath);
                hasComputed = true;
            }
            catch (IOException e) {
                LOGGER.warn("Error occurred when trying to read md5 of {}", (Object)md5FilePath);
            }
        }
        if (!hasComputed) {
            try {
                existedMd5 = DigestUtils.md5Hex((InputStream)Files.newInputStream(Paths.get(TriggerExecutableManager.getInstance().getLibRoot() + File.separator + triggerInformation.getJarName(), new String[0]), new OpenOption[0]));
                TriggerExecutableManager.getInstance().saveTextAsFileUnderTemporaryRoot(existedMd5, md5FilePath);
            }
            catch (IOException e) {
                String errorMessage = String.format("Failed to registered trigger %s, because error occurred when trying to compute md5 of jar file for trigger %s ", triggerName, triggerName);
                LOGGER.warn(errorMessage, (Throwable)e);
                throw new TriggerManagementException(errorMessage);
            }
        }
        return existedMd5.equals(triggerInformation.getJarFileMD5());
    }

    public void doRegister(TriggerInformation triggerInformation) throws IOException {
        try (TriggerClassLoader currentActiveClassLoader = TriggerClassLoaderManager.getInstance().updateAndGetActiveClassLoader();){
            String triggerName = triggerInformation.getTriggerName();
            this.triggerTable.addTriggerInformation(triggerName, triggerInformation);
            this.patternTreeMap.append(triggerInformation.getPathPattern(), (Object)triggerName);
            if (!triggerInformation.isStateful() || triggerInformation.getDataNodeLocation().getDataNodeId() == DATA_NODE_ID) {
                Trigger trigger = this.constructTriggerInstance(triggerInformation.getClassName(), currentActiveClassLoader);
                TriggerExecutor triggerExecutor = new TriggerExecutor(triggerInformation, trigger);
                this.executorMap.put(triggerName, triggerExecutor);
            }
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to register trigger %s with className: %s. The cause is: %s", triggerInformation.getTriggerName(), triggerInformation.getClassName(), e);
            LOGGER.warn(errorMessage);
            throw e;
        }
    }

    public Trigger constructTriggerInstance(String className, TriggerClassLoader classLoader) throws TriggerManagementException {
        try {
            Class<?> triggerClass = Class.forName(className, true, classLoader);
            return (Trigger)triggerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TriggerManagementException(String.format("Failed to reflect trigger instance with className(%s), because %s", className, e));
        }
    }

    public List<TriggerInformation> getAllTriggerInformationInTriggerTable() {
        return this.triggerTable.getAllTriggerInformation();
    }

    public List<TriggerExecutor> getAllTriggerExecutors() {
        return new ArrayList<TriggerExecutor>(this.executorMap.values());
    }

    public static TriggerManagementService getInstance() {
        return TriggerManagementServiceHolder.INSTANCE;
    }

    private static class TriggerManagementServiceHolder {
        private static final TriggerManagementService INSTANCE = new TriggerManagementService();

        private TriggerManagementServiceHolder() {
        }
    }
}

