/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.writelog;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.NoSuchElementException;
import java.util.zip.CRC32;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.utils.writelog.BatchLogReader;
import org.apache.iotdb.db.utils.writelog.ILogReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleFileLogReader
implements ILogReader {
    private static final Logger logger = LoggerFactory.getLogger(SingleFileLogReader.class);
    public static final int LEAST_LOG_SIZE = 12;
    private DataInputStream logStream;
    private String filepath;
    private byte[] buffer;
    private CRC32 checkSummer = new CRC32();
    private int idx;
    private long unbrokenLogsSize = 0L;
    private BatchLogReader batchLogReader;
    private boolean fileCorrupted = false;

    public SingleFileLogReader(File logFile) throws FileNotFoundException {
        this.open(logFile);
    }

    @Override
    public boolean hasNext() {
        try {
            int logSize;
            if (this.batchLogReader != null && this.batchLogReader.hasNext()) {
                return true;
            }
            try {
                logSize = this.logStream.readInt();
            }
            catch (EOFException e) {
                this.truncateBrokenLogs();
                return false;
            }
            if (logSize <= 0) {
                this.truncateBrokenLogs();
                return false;
            }
            this.buffer = new byte[logSize];
            int readLen = this.logStream.read(this.buffer, 0, logSize);
            if (readLen < logSize) {
                throw new IOException("Reach eof");
            }
            long checkSum = this.logStream.readLong();
            this.checkSummer.reset();
            this.checkSummer.update(this.buffer, 0, logSize);
            if (this.checkSummer.getValue() != checkSum) {
                throw new IOException(String.format("The check sum of the No.%d log batch is incorrect! In file: %d Calculated: %d.", this.idx, checkSum, this.checkSummer.getValue()));
            }
            this.batchLogReader = new BatchLogReader(ByteBuffer.wrap(this.buffer));
            if (!this.batchLogReader.isFileCorrupted()) {
                this.unbrokenLogsSize = this.unbrokenLogsSize + (long)logSize + 12L;
            } else {
                this.truncateBrokenLogs();
            }
            this.fileCorrupted = this.fileCorrupted || this.batchLogReader.isFileCorrupted();
        }
        catch (Exception e) {
            logger.error("Cannot read more PhysicalPlans from {}, successfully read index is {}. The reason is", new Object[]{this.idx, this.filepath, e});
            this.truncateBrokenLogs();
            this.fileCorrupted = true;
            return false;
        }
        return this.batchLogReader != null && this.batchLogReader.hasNext();
    }

    @Override
    public PhysicalPlan next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.idx;
        return this.batchLogReader.next();
    }

    @Override
    public void close() {
        if (this.logStream != null) {
            try {
                this.logStream.close();
            }
            catch (IOException e) {
                logger.error("Cannot close log file {}", (Object)this.filepath, (Object)e);
            }
        }
    }

    public void open(File logFile) throws FileNotFoundException {
        this.close();
        this.logStream = new DataInputStream(new BufferedInputStream(new FileInputStream(logFile)));
        logger.info("open WAL file: {} size is {}", (Object)logFile.getName(), (Object)logFile.length());
        this.filepath = logFile.getPath();
        this.idx = 0;
    }

    public boolean isFileCorrupted() {
        return this.fileCorrupted;
    }

    private void truncateBrokenLogs() {
        try (FileOutputStream outputStream = new FileOutputStream(this.filepath, true);
             FileChannel channel = outputStream.getChannel();){
            channel.truncate(this.unbrokenLogsSize);
        }
        catch (IOException e) {
            logger.error("Fail to truncate log file to size {}", (Object)this.unbrokenLogsSize, (Object)e);
        }
    }
}

