/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.cache;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadataIndex;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetaData;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;

public class TsFileMetadataUtils {
    private TsFileMetadataUtils() {
    }

    public static TsFileMetaData getTsFileMetaData(String filePath) throws IOException {
        try (TsFileSequenceReader reader = new TsFileSequenceReader(filePath);){
            TsFileMetaData tsFileMetaData = reader.readFileMetadata();
            return tsFileMetaData;
        }
    }

    public static TsDeviceMetadata getTsRowGroupBlockMetaData(String filePath, String deviceId, TsFileMetaData fileMetaData) throws IOException {
        if (!fileMetaData.getDeviceMap().containsKey(deviceId)) {
            return null;
        }
        try (TsFileSequenceReader reader = new TsFileSequenceReader(filePath);){
            long offset = ((TsDeviceMetadataIndex)fileMetaData.getDeviceMap().get(deviceId)).getOffset();
            int size = ((TsDeviceMetadataIndex)fileMetaData.getDeviceMap().get(deviceId)).getLen();
            ByteBuffer data = ByteBuffer.allocate(size);
            reader.readRaw(offset, size, data);
            data.flip();
            TsDeviceMetadata tsDeviceMetadata = TsDeviceMetadata.deserializeFrom((ByteBuffer)data);
            return tsDeviceMetadata;
        }
    }
}

