/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class TsFileResource {
    private File file;
    public static final String RESOURCE_SUFFIX = ".resource";
    private Map<String, Long> startTimeMap;
    private Map<String, Long> endTimeMap;
    private TsFileProcessor processor;
    private ModificationFile modFile;
    private volatile boolean closed = false;
    private List<ChunkMetaData> chunkMetaDatas;
    private ReadOnlyMemChunk readOnlyMemChunk;

    public TsFileResource(File file) {
        this.file = file;
        this.startTimeMap = new HashMap<String, Long>();
        this.endTimeMap = new HashMap<String, Long>();
        this.closed = true;
    }

    public TsFileResource(File file, TsFileProcessor processor) {
        this.file = file;
        this.startTimeMap = new HashMap<String, Long>();
        this.endTimeMap = new HashMap<String, Long>();
        this.processor = processor;
    }

    public TsFileResource(File file, Map<String, Long> startTimeMap, Map<String, Long> endTimeMap) {
        this.file = file;
        this.startTimeMap = startTimeMap;
        this.endTimeMap = endTimeMap;
        this.closed = true;
    }

    public TsFileResource(File file, Map<String, Long> startTimeMap, Map<String, Long> endTimeMap, ReadOnlyMemChunk readOnlyMemChunk, List<ChunkMetaData> chunkMetaDatas) {
        this.file = file;
        this.startTimeMap = startTimeMap;
        this.endTimeMap = endTimeMap;
        this.chunkMetaDatas = chunkMetaDatas;
        this.readOnlyMemChunk = readOnlyMemChunk;
    }

    public void serialize() throws IOException {
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(this.file + RESOURCE_SUFFIX));){
            ReadWriteIOUtils.write((int)this.startTimeMap.size(), (OutputStream)outputStream);
            for (Map.Entry<String, Long> entry : this.startTimeMap.entrySet()) {
                ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((long)entry.getValue(), (OutputStream)outputStream);
            }
            ReadWriteIOUtils.write((int)this.endTimeMap.size(), (OutputStream)outputStream);
            for (Map.Entry<String, Long> entry : this.endTimeMap.entrySet()) {
                ReadWriteIOUtils.write((String)entry.getKey(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((long)entry.getValue(), (OutputStream)outputStream);
            }
        }
    }

    public void deSerialize() throws IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(this.file + RESOURCE_SUFFIX));){
            int size = ReadWriteIOUtils.readInt((InputStream)inputStream);
            HashMap<String, Long> startTimes = new HashMap<String, Long>();
            for (int i = 0; i < size; ++i) {
                String path = ReadWriteIOUtils.readString((InputStream)inputStream);
                long time = ReadWriteIOUtils.readLong((InputStream)inputStream);
                startTimes.put(path, time);
            }
            size = ReadWriteIOUtils.readInt((InputStream)inputStream);
            HashMap<String, Long> endTimes = new HashMap<String, Long>();
            for (int i = 0; i < size; ++i) {
                String path = ReadWriteIOUtils.readString((InputStream)inputStream);
                long time = ReadWriteIOUtils.readLong((InputStream)inputStream);
                endTimes.put(path, time);
            }
            this.startTimeMap = startTimes;
            this.endTimeMap = endTimes;
        }
    }

    public void updateStartTime(String device, long time) {
        long startTime = this.startTimeMap.getOrDefault(device, Long.MAX_VALUE);
        if (time < startTime) {
            this.startTimeMap.put(device, time);
        }
    }

    public void updateEndTime(String device, long time) {
        long endTime = this.endTimeMap.getOrDefault(device, Long.MIN_VALUE);
        if (time > endTime) {
            this.endTimeMap.put(device, time);
        }
    }

    public boolean fileExists() {
        return new File(this.file + RESOURCE_SUFFIX).exists();
    }

    public void forceUpdateEndTime(String device, long time) {
        this.endTimeMap.put(device, time);
    }

    public List<ChunkMetaData> getChunkMetaDatas() {
        return this.chunkMetaDatas;
    }

    public ReadOnlyMemChunk getReadOnlyMemChunk() {
        return this.readOnlyMemChunk;
    }

    public synchronized ModificationFile getModFile() {
        if (this.modFile == null) {
            this.modFile = new ModificationFile(this.file.getAbsolutePath() + ".mods");
        }
        return this.modFile;
    }

    public boolean containsDevice(String deviceId) {
        return this.startTimeMap.containsKey(deviceId);
    }

    public File getFile() {
        return this.file;
    }

    public long getFileSize() {
        return this.file.length();
    }

    public Map<String, Long> getStartTimeMap() {
        return this.startTimeMap;
    }

    public void setEndTimeMap(Map<String, Long> endTimeMap) {
        this.endTimeMap = endTimeMap;
    }

    public Map<String, Long> getEndTimeMap() {
        return this.endTimeMap;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() throws IOException {
        this.closed = true;
        if (this.modFile != null) {
            this.modFile.close();
            this.modFile = null;
        }
        this.processor = null;
        this.chunkMetaDatas = null;
    }

    public TsFileProcessor getUnsealedFileProcessor() {
        return this.processor;
    }

    public void updateTime(String deviceId, long time) {
        this.startTimeMap.putIfAbsent(deviceId, time);
        Long endTime = this.endTimeMap.get(deviceId);
        if (endTime == null || endTime < time) {
            this.endTimeMap.put(deviceId, time);
        }
    }
}

