/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.adapter.IoTDBConfigDynamicAdapter;
import org.apache.iotdb.db.exception.ConfigAdjusterException;
import org.apache.iotdb.db.exception.MetadataErrorException;
import org.apache.iotdb.db.exception.PathErrorException;
import org.apache.iotdb.db.metadata.MGraph;
import org.apache.iotdb.db.metadata.MNode;
import org.apache.iotdb.db.metadata.Metadata;
import org.apache.iotdb.db.utils.RandomDeleteCache;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.exception.cache.CacheException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MManager {
    private static final Logger logger = LoggerFactory.getLogger(MManager.class);
    private static final String ROOT_NAME = "root";
    private static final String TIME_SERIES_TREE_HEADER = "===  Timeseries Tree  ===\n\n";
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private String logFilePath;
    private MGraph mgraph;
    private BufferedWriter logWriter;
    private boolean writeToLog;
    private String schemaDir;
    private RandomDeleteCache<String, PathCheckRet> checkAndGetDataTypeCache;
    private RandomDeleteCache<String, MNode> mNodeCache;
    private Map<String, Integer> seriesNumberInStorageGroups = new HashMap<String, Integer>();
    private long maxSeriesNumberAmongStorageGroup;
    private boolean initialized;

    private MManager() {
        this.schemaDir = IoTDBDescriptor.getInstance().getConfig().getSystemDir() + File.separator + "schema";
        File systemFolder = new File(this.schemaDir);
        if (!systemFolder.exists()) {
            if (systemFolder.mkdirs()) {
                logger.info("create system folder {}", (Object)systemFolder.getAbsolutePath());
            } else {
                logger.info("create system folder {} failed.", (Object)systemFolder.getAbsolutePath());
            }
        }
        this.logFilePath = this.schemaDir + File.separator + "mlog.txt";
        this.writeToLog = false;
        int cacheSize = IoTDBDescriptor.getInstance().getConfig().getmManagerCacheSize();
        this.checkAndGetDataTypeCache = new RandomDeleteCache<String, PathCheckRet>(cacheSize){

            @Override
            public void beforeRemove(PathCheckRet object) {
            }

            @Override
            public PathCheckRet loadObjectByKey(String key) throws CacheException {
                return MManager.this.loadPathToCache(key);
            }
        };
        this.mNodeCache = new RandomDeleteCache<String, MNode>(cacheSize){

            @Override
            public void beforeRemove(MNode object) {
            }

            @Override
            public MNode loadObjectByKey(String key) throws CacheException {
                try {
                    return MManager.this.getNodeByPathWithCheck(key);
                }
                catch (PathErrorException e) {
                    throw new CacheException((Throwable)e);
                }
            }
        };
    }

    public static MManager getInstance() {
        return MManagerHolder.INSTANCE;
    }

    public void init() {
        if (this.initialized) {
            return;
        }
        this.lock.writeLock().lock();
        File logFile = new File(this.logFilePath);
        try {
            this.initFromLog(logFile);
            this.seriesNumberInStorageGroups = this.mgraph.countSeriesNumberInEachStorageGroup();
            this.maxSeriesNumberAmongStorageGroup = this.seriesNumberInStorageGroups.isEmpty() ? 0L : (long)this.seriesNumberInStorageGroups.values().stream().max(Integer::compareTo).get().intValue();
            this.writeToLog = true;
        }
        catch (IOException | MetadataErrorException | PathErrorException e) {
            this.mgraph = new MGraph(ROOT_NAME);
            logger.error("Cannot read MGraph from file, using an empty new one", (Throwable)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.initialized = true;
    }

    private void initFromLog(File logFile) throws IOException, PathErrorException, MetadataErrorException {
        this.mgraph = new MGraph(ROOT_NAME);
        if (logFile.exists()) {
            try (FileReader fr = new FileReader(logFile);
                 BufferedReader br = new BufferedReader(fr);){
                String cmd;
                while ((cmd = br.readLine()) != null) {
                    this.operation(cmd);
                }
            }
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.mgraph = new MGraph(ROOT_NAME);
            this.checkAndGetDataTypeCache.clear();
            this.mNodeCache.clear();
            this.seriesNumberInStorageGroups.clear();
            this.maxSeriesNumberAmongStorageGroup = 0L;
            if (this.logWriter != null) {
                this.logWriter.close();
                this.logWriter = null;
            }
        }
        catch (IOException e) {
            logger.error("Cannot close metadata log writer, because:", (Throwable)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void operation(String cmd) throws PathErrorException, IOException, MetadataErrorException {
        String[] args = cmd.trim().split(",");
        switch (args[0]) {
            case "0": {
                HashMap<String, String> props = null;
                if (args.length > 5) {
                    props = new HashMap<String, String>(args.length - 5 + 1, 1.0f);
                    for (int k = 5; k < args.length; ++k) {
                        String[] kv = args[k].split("=");
                        props.put(kv[0], kv[1]);
                    }
                }
                this.addPathToMTree(new Path(args[1]), TSDataType.deserialize((short)Short.valueOf(args[2])), TSEncoding.deserialize((short)Short.valueOf(args[3])), CompressionType.deserialize((short)Short.valueOf(args[4])), props);
                break;
            }
            case "1": {
                this.deletePaths(Collections.singletonList(new Path(args[1])));
                break;
            }
            case "2": {
                this.setStorageLevelToMTree(args[1]);
                break;
            }
            case "3": {
                this.addAPTree(args[1]);
                break;
            }
            case "4": {
                this.addPathToPTree(args[1]);
                break;
            }
            case "5": {
                this.deletePathFromPTree(args[1]);
                break;
            }
            case "6": {
                this.linkMNodeToPTree(args[1], args[2]);
                break;
            }
            case "7": {
                this.unlinkMNodeFromPTree(args[1], args[2]);
                break;
            }
            default: {
                logger.error("Unrecognizable command {}", (Object)cmd);
            }
        }
    }

    private BufferedWriter getLogWriter() throws IOException {
        if (this.logWriter == null) {
            File logFile = new File(this.logFilePath);
            File metadataDir = new File(this.schemaDir);
            if (!metadataDir.exists()) {
                if (metadataDir.mkdirs()) {
                    logger.info("create schema folder {}.", (Object)metadataDir);
                } else {
                    logger.info("create schema folder {} failed.", (Object)metadataDir);
                }
            }
            FileWriter fileWriter = new FileWriter(logFile, true);
            this.logWriter = new BufferedWriter(fileWriter);
        }
        return this.logWriter;
    }

    public boolean addPathToMTree(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props) throws MetadataErrorException {
        return this.addPathToMTree(new Path(path), dataType, encoding, compressor, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPathToMTree(Path path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props) throws MetadataErrorException {
        String fileNodePath;
        if (this.pathExist(path.getFullPath())) {
            throw new MetadataErrorException(String.format("Timeseries %s already exist", path.getFullPath()));
        }
        if (!this.checkFileNameByPath(path.getFullPath())) {
            throw new MetadataErrorException("Storage group should be created first");
        }
        try {
            fileNodePath = this.getStorageGroupNameByPath(path.getFullPath());
        }
        catch (PathErrorException e) {
            throw new MetadataErrorException(e);
        }
        try {
            IoTDBConfigDynamicAdapter.getInstance().addOrDeleteTimeSeries(1);
        }
        catch (ConfigAdjusterException e) {
            throw new MetadataErrorException(e);
        }
        Map<String, MeasurementSchema> schemaMap = this.getStorageGroupSchemaMap(fileNodePath);
        Map<String, Integer> numSchemaMap = this.getStorageGroupNumSchemaMap(fileNodePath);
        String lastNode = path.getMeasurement();
        boolean isNewMeasurement = true;
        Map<String, MeasurementSchema> map = schemaMap;
        synchronized (map) {
            if (this.pathExist(path.getFullPath())) {
                throw new MetadataErrorException(String.format("Timeseries %s already exist", path.getFullPath()));
            }
            if (schemaMap.containsKey(lastNode)) {
                isNewMeasurement = false;
                MeasurementSchema columnSchema = schemaMap.get(lastNode);
                if (!columnSchema.getType().equals((Object)dataType) || !columnSchema.getEncodingType().equals((Object)encoding)) {
                    throw new MetadataErrorException(String.format("The resultDataType or encoding of the last node %s is conflicting in the storage group %s", lastNode, fileNodePath));
                }
                try {
                    this.addPathToMTreeInternal(path.getFullPath(), dataType, encoding, compressor, props);
                }
                catch (IOException | PathErrorException e) {
                    throw new MetadataErrorException(e);
                }
                numSchemaMap.put(lastNode, numSchemaMap.get(lastNode) + 1);
            } else {
                MeasurementSchema columnSchema;
                try {
                    this.addPathToMTreeInternal(path.getFullPath(), dataType, encoding, compressor, props);
                }
                catch (IOException | PathErrorException e) {
                    throw new MetadataErrorException(e);
                }
                try {
                    columnSchema = this.getSchemaForOnePath(path.toString());
                }
                catch (PathErrorException e) {
                    throw new MetadataErrorException(e);
                }
                schemaMap.put(lastNode, columnSchema);
                numSchemaMap.put(lastNode, 1);
            }
            return isNewMeasurement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPathToMTreeInternal(String path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props) throws PathErrorException, IOException {
        this.lock.writeLock().lock();
        try {
            this.mgraph.addPathToMTree(path, dataType, encoding, compressor, props);
            String storageName = this.mgraph.getStorageGroupNameByPath(path);
            int size = this.seriesNumberInStorageGroups.get(this.mgraph.getStorageGroupNameByPath(path));
            this.seriesNumberInStorageGroups.put(storageName, size + 1);
            if ((long)(size + 1) > this.maxSeriesNumberAmongStorageGroup) {
                this.maxSeriesNumberAmongStorageGroup = size + 1;
            }
            if (this.writeToLog) {
                BufferedWriter writer = this.getLogWriter();
                writer.write(String.format("%s,%s,%s,%s,%s", "0", path, dataType.serialize(), encoding.serialize(), compressor.serialize()));
                if (props != null) {
                    for (Map.Entry<String, String> entry : props.entrySet()) {
                        writer.write(String.format(",%s=%s", entry.getKey(), entry.getValue()));
                    }
                }
                writer.newLine();
                writer.flush();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void addPathToMTree(String path, String dataType, String encoding) throws PathErrorException, IOException {
        TSDataType tsDataType = TSDataType.valueOf((String)dataType);
        TSEncoding tsEncoding = TSEncoding.valueOf((String)encoding);
        CompressionType type = CompressionType.valueOf((String)TSFileConfig.compressor);
        this.addPathToMTreeInternal(path, tsDataType, tsEncoding, type, Collections.emptyMap());
    }

    private List<String> collectPaths(List<Path> paths) throws MetadataErrorException {
        HashSet pathSet = new HashSet();
        for (Object p : paths) {
            List<String> subPaths = this.getPaths(p.getFullPath());
            if (subPaths.isEmpty()) {
                throw new MetadataErrorException(String.format("There are no timeseries in the prefix of %s seriesPath", p.getFullPath()));
            }
            ArrayList<String> newSubPaths = new ArrayList<String>();
            for (String eachSubPath : subPaths) {
                String storageGroupName;
                try {
                    storageGroupName = this.getStorageGroupNameByPath(eachSubPath);
                }
                catch (PathErrorException e) {
                    throw new MetadataErrorException(e);
                }
                if ("root.stats".equals(storageGroupName)) continue;
                newSubPaths.add(eachSubPath);
            }
            pathSet.addAll(newSubPaths);
        }
        for (Object p : pathSet) {
            if (this.pathExist((String)p)) continue;
            throw new MetadataErrorException(String.format("Timeseries %s does not exist and cannot be deleted", p));
        }
        return new ArrayList<String>(pathSet);
    }

    public Set<String> deletePaths(List<Path> deletePathList) throws MetadataErrorException {
        if (deletePathList != null && !deletePathList.isEmpty()) {
            List<String> fullPath = this.collectPaths(deletePathList);
            HashSet<String> emptyStorageGroups = new HashSet<String>();
            for (String p : fullPath) {
                try {
                    IoTDBConfigDynamicAdapter.getInstance().addOrDeleteTimeSeries(-1);
                }
                catch (ConfigAdjusterException e) {
                    throw new MetadataErrorException(e);
                }
                String emptiedStorageGroup = this.deletePath(p);
                if (emptiedStorageGroup == null) continue;
                emptyStorageGroups.add(emptiedStorageGroup);
            }
            return emptyStorageGroups;
        }
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String deletePath(String pathStr) throws MetadataErrorException {
        String emptiedStorageGroup;
        String storageGroupName;
        try {
            storageGroupName = this.getStorageGroupNameByPath(pathStr);
        }
        catch (PathErrorException e) {
            throw new MetadataErrorException(e);
        }
        Map<String, MeasurementSchema> schemaMap = this.getStorageGroupSchemaMap(storageGroupName);
        Map<String, Integer> numSchemaMap = this.getStorageGroupNumSchemaMap(storageGroupName);
        Map<String, MeasurementSchema> map = schemaMap;
        synchronized (map) {
            Path path = new Path(pathStr);
            String measurementId = path.getMeasurement();
            if (numSchemaMap.get(measurementId) == 1) {
                numSchemaMap.remove(measurementId);
                schemaMap.remove(measurementId);
            } else {
                numSchemaMap.put(measurementId, numSchemaMap.get(measurementId) - 1);
            }
            try {
                emptiedStorageGroup = this.deletePathFromMTree(pathStr);
            }
            catch (IOException | PathErrorException e) {
                throw new MetadataErrorException(e);
            }
        }
        return emptiedStorageGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String deletePathFromMTree(String path) throws PathErrorException, IOException {
        this.lock.writeLock().lock();
        try {
            this.checkAndGetDataTypeCache.clear();
            this.mNodeCache.clear();
            String dataFileName = this.mgraph.deletePath(path);
            if (this.writeToLog) {
                BufferedWriter writer = this.getLogWriter();
                writer.write("1," + path);
                writer.newLine();
                writer.flush();
            }
            String storageGroup = this.getStorageGroupNameByPath(path);
            int size = this.seriesNumberInStorageGroups.get(storageGroup);
            this.seriesNumberInStorageGroups.put(storageGroup, size - 1);
            this.maxSeriesNumberAmongStorageGroup = (long)size == this.maxSeriesNumberAmongStorageGroup ? (this.seriesNumberInStorageGroups.isEmpty() ? 0L : (long)this.seriesNumberInStorageGroups.values().stream().max(Integer::compareTo).get().intValue()) : --this.maxSeriesNumberAmongStorageGroup;
            String string = dataFileName;
            return string;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void setStorageLevelToMTree(String path) throws MetadataErrorException {
        this.lock.writeLock().lock();
        try {
            this.checkAndGetDataTypeCache.clear();
            this.mNodeCache.clear();
            IoTDBConfigDynamicAdapter.getInstance().addOrDeleteStorageGroup(1);
            this.mgraph.setStorageLevel(path);
            this.seriesNumberInStorageGroups.put(path, 0);
            if (this.writeToLog) {
                BufferedWriter writer = this.getLogWriter();
                writer.write("2," + path);
                writer.newLine();
                writer.flush();
            }
        }
        catch (IOException | ConfigAdjusterException e) {
            throw new MetadataErrorException(e);
        }
        catch (PathErrorException e) {
            try {
                IoTDBConfigDynamicAdapter.getInstance().addOrDeleteStorageGroup(-1);
            }
            catch (ConfigAdjusterException ex) {
                throw new MetadataErrorException(ex);
            }
            throw new MetadataErrorException(e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    boolean checkStorageLevelOfMTree(String path) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.mgraph.checkStorageLevel(path);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void addAPTree(String ptreeRootName) throws IOException, MetadataErrorException {
        this.lock.writeLock().lock();
        try {
            this.mgraph.addAPTree(ptreeRootName);
            if (this.writeToLog) {
                BufferedWriter writer = this.getLogWriter();
                writer.write("3," + ptreeRootName);
                writer.newLine();
                writer.flush();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void addPathToPTree(String path) throws PathErrorException, IOException {
        this.lock.writeLock().lock();
        try {
            this.mgraph.addPathToPTree(path);
            if (this.writeToLog) {
                BufferedWriter writer = this.getLogWriter();
                writer.write("4," + path);
                writer.newLine();
                writer.flush();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void deletePathFromPTree(String path) throws PathErrorException, IOException {
        this.lock.writeLock().lock();
        try {
            this.mgraph.deletePath(path);
            if (this.writeToLog) {
                BufferedWriter writer = this.getLogWriter();
                writer.write("5," + path);
                writer.newLine();
                writer.flush();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkMNodeToPTree(String path, String mpath) throws PathErrorException, IOException {
        this.lock.writeLock().lock();
        try {
            this.mgraph.linkMNodeToPTree(path, mpath);
            if (this.writeToLog) {
                BufferedWriter writer = this.getLogWriter();
                writer.write("6," + path + "," + mpath);
                writer.newLine();
                writer.flush();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlinkMNodeFromPTree(String path, String mpath) throws PathErrorException, IOException {
        this.lock.writeLock().lock();
        try {
            this.mgraph.unlinkMNodeFromPTree(path, mpath);
            if (this.writeToLog) {
                BufferedWriter writer = this.getLogWriter();
                writer.write("7," + path + "," + mpath);
                writer.newLine();
                writer.flush();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public TSDataType getSeriesType(String fullPath) throws PathErrorException {
        this.lock.readLock().lock();
        try {
            TSDataType tSDataType = this.getSchemaForOnePath(fullPath).getType();
            return tSDataType;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSDataType getSeriesType(MNode node, String fullPath) throws PathErrorException {
        this.lock.readLock().lock();
        try {
            TSDataType tSDataType = this.getSchemaForOnePath(node, fullPath).getType();
            return tSDataType;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TSDataType getSeriesTypeWithCheck(MNode node, String fullPath) throws PathErrorException {
        this.lock.readLock().lock();
        try {
            TSDataType tSDataType = this.getSchemaForOnePathWithCheck(node, fullPath).getType();
            return tSDataType;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    TSDataType getSeriesTypeWithCheck(String fullPath) throws PathErrorException {
        this.lock.readLock().lock();
        try {
            TSDataType tSDataType = this.getSchemaForOnePathWithCheck(fullPath).getType();
            return tSDataType;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Map<String, List<MeasurementSchema>> getSchemaForAllType() throws PathErrorException {
        this.lock.readLock().lock();
        try {
            Map<String, List<MeasurementSchema>> map = this.mgraph.getSchemaForAllType();
            return map;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Metadata getMetadata() throws PathErrorException {
        this.lock.readLock().lock();
        try {
            Metadata metadata = this.mgraph.getMetadata();
            return metadata;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<String> getAllStorageGroup() throws PathErrorException {
        this.lock.readLock().lock();
        try {
            HashSet<String> hashSet = this.mgraph.getAllStorageGroup();
            return hashSet;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Deprecated
    public List<MeasurementSchema> getSchemaForOneType(String path) throws PathErrorException {
        this.lock.readLock().lock();
        try {
            ArrayList<MeasurementSchema> arrayList = this.mgraph.getSchemaForOneType(path);
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<MeasurementSchema> getSchemaForStorageGroup(String path) {
        this.lock.readLock().lock();
        try {
            ArrayList<MeasurementSchema> arrayList = this.mgraph.getSchemaInOneStorageGroup(path);
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private Map<String, MeasurementSchema> getStorageGroupSchemaMap(String path) {
        this.lock.readLock().lock();
        try {
            Map<String, MeasurementSchema> map = this.mgraph.getSchemaMapForOneFileNode(path);
            return map;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private Map<String, Integer> getStorageGroupNumSchemaMap(String path) {
        this.lock.readLock().lock();
        try {
            Map<String, Integer> map = this.mgraph.getNumSchemaMapForOneFileNode(path);
            return map;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getFileCountForOneType(String path) throws PathErrorException {
        this.lock.readLock().lock();
        try {
            int n = this.mgraph.getFileCountForOneType(path);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String getStorageGroupNameByPath(String path) throws PathErrorException {
        this.lock.readLock().lock();
        try {
            String string = this.mgraph.getStorageGroupNameByPath(path);
            return string;
        }
        catch (PathErrorException e) {
            throw new PathErrorException(e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private String getStorageGroupNameByPath(MNode node, String path) throws PathErrorException {
        this.lock.readLock().lock();
        try {
            String string = this.mgraph.getStorageGroupNameByPath(node, path);
            return string;
        }
        catch (PathErrorException e) {
            throw new PathErrorException(e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    boolean checkFileNameByPath(String path) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.mgraph.checkFileNameByPath(path);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<String> getAllStorageGroupNames() throws MetadataErrorException {
        this.lock.readLock().lock();
        try {
            Map<String, ArrayList<String>> res = this.getAllPathGroupByFileName(ROOT_NAME);
            ArrayList<String> arrayList = new ArrayList<String>(res.keySet());
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    List<String> getAllFileNamesByPath(String path) throws MetadataErrorException {
        this.lock.readLock().lock();
        try {
            List<String> list = this.mgraph.getAllFileNamesByPath(path);
            return list;
        }
        catch (PathErrorException e) {
            throw new MetadataErrorException(e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    Map<String, ArrayList<String>> getAllPathGroupByFileName(String path) throws MetadataErrorException {
        this.lock.readLock().lock();
        try {
            HashMap<String, ArrayList<String>> hashMap = this.mgraph.getAllPathGroupByFilename(path);
            return hashMap;
        }
        catch (PathErrorException e) {
            throw new MetadataErrorException(e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getPaths(String path) throws MetadataErrorException {
        this.lock.readLock().lock();
        try {
            ArrayList<String> res = new ArrayList<String>();
            Map<String, ArrayList<String>> pathsGroupByFilename = this.getAllPathGroupByFileName(path);
            for (ArrayList<String> ps : pathsGroupByFilename.values()) {
                res.addAll(ps);
            }
            ArrayList<String> arrayList = res;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<List<String>> getShowTimeseriesPath(String path) throws PathErrorException {
        this.lock.readLock().lock();
        try {
            List<List<String>> list = this.mgraph.getShowTimeseriesPath(path);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    List<String> getLeafNodePathInNextLevel(String path) throws PathErrorException {
        this.lock.readLock().lock();
        try {
            List<String> list = this.mgraph.getLeafNodePathInNextLevel(path);
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean pathExist(String path) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.mgraph.pathExist(path);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean pathExist(MNode node, String path) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.mgraph.pathExist(node, path);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    MNode getNodeByPath(String path) throws PathErrorException {
        this.lock.readLock().lock();
        try {
            MNode mNode = this.mgraph.getNodeByPath(path);
            return mNode;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public MNode getNodeByDeviceIdFromCache(String deviceId) throws PathErrorException {
        this.lock.readLock().lock();
        try {
            MNode mNode = this.mNodeCache.get(deviceId);
            return mNode;
        }
        catch (CacheException e) {
            throw new PathErrorException(e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    MNode getNodeByPathWithCheck(String path) throws PathErrorException {
        this.lock.readLock().lock();
        try {
            MNode mNode = this.mgraph.getNodeByPathWithCheck(path);
            return mNode;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private MeasurementSchema getSchemaForOnePath(String path) throws PathErrorException {
        this.lock.readLock().lock();
        try {
            MeasurementSchema measurementSchema = this.mgraph.getSchemaForOnePath(path);
            return measurementSchema;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MeasurementSchema getSchemaForOnePath(MNode node, String path) throws PathErrorException {
        this.lock.readLock().lock();
        try {
            MeasurementSchema measurementSchema = this.mgraph.getSchemaForOnePath(node, path);
            return measurementSchema;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MeasurementSchema getSchemaForOnePathWithCheck(MNode node, String path) throws PathErrorException {
        this.lock.readLock().lock();
        try {
            MeasurementSchema measurementSchema = this.mgraph.getSchemaForOnePathWithCheck(node, path);
            return measurementSchema;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private MeasurementSchema getSchemaForOnePathWithCheck(String path) throws PathErrorException {
        this.lock.readLock().lock();
        try {
            MeasurementSchema measurementSchema = this.mgraph.getSchemaForOnePathWithCheck(path);
            return measurementSchema;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkFileLevel(List<Path> path) throws PathErrorException {
        this.lock.readLock().lock();
        try {
            for (Path p : path) {
                this.getStorageGroupNameByPath(p.getFullPath());
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkFileLevel(MNode node, List<Path> path) throws PathErrorException {
        this.lock.readLock().lock();
        try {
            for (Path p : path) {
                this.getStorageGroupNameByPath(node, p.getFullPath());
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    boolean checkFileLevel(String path) throws PathErrorException {
        this.lock.readLock().lock();
        try {
            this.getStorageGroupNameByPath(path);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkFileLevelWithCheck(MNode node, String path) throws PathErrorException {
        this.lock.readLock().lock();
        try {
            this.getStorageGroupNameByPath(node, path);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String getMetadataInString() {
        this.lock.readLock().lock();
        try {
            String string = TIME_SERIES_TREE_HEADER + this.mgraph.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    PathCheckRet checkPathStorageLevelAndGetDataType(String path) throws PathErrorException {
        try {
            return this.checkAndGetDataTypeCache.get(path);
        }
        catch (CacheException e) {
            throw new PathErrorException(e);
        }
    }

    private PathCheckRet loadPathToCache(String path) throws CacheException {
        try {
            if (!this.pathExist(path)) {
                return new PathCheckRet(false, null);
            }
            ArrayList<Path> p = new ArrayList<Path>();
            p.add(new Path(path));
            if (!this.checkFileLevel(p)) {
                return new PathCheckRet(false, null);
            }
            return new PathCheckRet(true, this.getSeriesType(path));
        }
        catch (PathErrorException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public void setMaxSeriesNumberAmongStorageGroup(long maxSeriesNumberAmongStorageGroup) {
        this.maxSeriesNumberAmongStorageGroup = maxSeriesNumberAmongStorageGroup;
    }

    public long getMaximalSeriesNumberAmongStorageGroups() {
        return this.maxSeriesNumberAmongStorageGroup;
    }

    public static class PathCheckRet {
        private boolean successfully;
        private TSDataType dataType;

        PathCheckRet(boolean successfully, TSDataType dataType) {
            this.successfully = successfully;
            this.dataType = dataType;
        }

        public boolean isSuccessfully() {
            return this.successfully;
        }

        public TSDataType getDataType() {
            return this.dataType;
        }
    }

    private static class MManagerHolder {
        private static final MManager INSTANCE = new MManager();

        private MManagerHolder() {
        }
    }
}

