/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.sys;

import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.RootOperator;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;

public class MetadataOperator
extends RootOperator {
    private final NamespaceType namespaceType;
    private Path path;
    private TSDataType dataType;
    private TSEncoding encoding;
    private CompressionType compressor;
    private Map<String, String> props;
    private List<Path> deletePathList;

    public MetadataOperator(int tokenIntType, NamespaceType type) {
        super(tokenIntType);
        this.namespaceType = type;
        switch (type) {
            case SET_FILE_LEVEL: {
                this.operatorType = Operator.OperatorType.SET_STORAGE_GROUP;
                break;
            }
            case ADD_PATH: {
                this.operatorType = Operator.OperatorType.CREATE_TIMESERIES;
                break;
            }
            case DELETE_PATH: {
                this.operatorType = Operator.OperatorType.DELETE_TIMESERIES;
                break;
            }
        }
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(TSDataType dataType) {
        this.dataType = dataType;
    }

    public TSEncoding getEncoding() {
        return this.encoding;
    }

    public void setEncoding(TSEncoding encoding) {
        this.encoding = encoding;
    }

    public void setCompressor(CompressionType compressor) {
        this.compressor = compressor;
    }

    public CompressionType getCompressor() {
        return this.compressor;
    }

    public Map<String, String> getProps() {
        return this.props;
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    public NamespaceType getNamespaceType() {
        return this.namespaceType;
    }

    public List<Path> getDeletePathList() {
        return this.deletePathList;
    }

    public void setDeletePathList(List<Path> deletePathList) {
        this.deletePathList = deletePathList;
    }

    public static enum NamespaceType {
        ADD_PATH,
        DELETE_PATH,
        SET_FILE_LEVEL;


        public static NamespaceType deserialize(short i) {
            switch (i) {
                case 0: {
                    return ADD_PATH;
                }
                case 1: {
                    return DELETE_PATH;
                }
                case 2: {
                    return SET_FILE_LEVEL;
                }
            }
            return null;
        }

        public short serialize() {
            switch (this) {
                case ADD_PATH: {
                    return 0;
                }
                case DELETE_PATH: {
                    return 1;
                }
                case SET_FILE_LEVEL: {
                    return 2;
                }
            }
            return -1;
        }
    }
}

