/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;

public class QueryContext {
    private Map<String, Map<String, List<Modification>>> filePathModCache = new HashMap<String, Map<String, List<Modification>>>();
    private Map<String, List<Modification>> fileModCache = new HashMap<String, List<Modification>>();
    private long jobId;

    public QueryContext() {
    }

    public QueryContext(long jobId) {
        this.jobId = jobId;
    }

    public List<Modification> getPathModifications(ModificationFile modFile, String path) {
        Map fileModifications = this.filePathModCache.computeIfAbsent(modFile.getFilePath(), k -> new HashMap());
        ArrayList pathModifications = (ArrayList)fileModifications.get(path);
        if (pathModifications == null) {
            List allModifications = this.fileModCache.get(modFile.getFilePath());
            if (allModifications == null) {
                allModifications = (List)modFile.getModifications();
                this.fileModCache.put(modFile.getFilePath(), allModifications);
            }
            pathModifications = new ArrayList();
            if (!allModifications.isEmpty()) {
                ArrayList finalPathModifications = pathModifications;
                allModifications.forEach(modification -> {
                    if (modification.getPathString().equals(path)) {
                        finalPathModifications.add(modification);
                    }
                });
            }
            fileModifications.put(path, pathModifications);
        }
        return pathModifications;
    }

    public long getJobId() {
        return this.jobId;
    }
}

