/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.JobFileManager;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.ExpressionType;
import org.apache.iotdb.tsfile.read.expression.IBinaryExpression;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;

public class QueryResourceManager {
    private ConcurrentHashMap<Long, ConcurrentHashMap<String, List<Integer>>> queryTokensMap = new ConcurrentHashMap();
    private JobFileManager filePathsManager = new JobFileManager();
    private AtomicLong maxJobId = new AtomicLong(0L);

    private QueryResourceManager() {
    }

    public static QueryResourceManager getInstance() {
        return QueryTokenManagerHelper.INSTANCE;
    }

    public long assignJobId() {
        long jobId = this.maxJobId.incrementAndGet();
        this.queryTokensMap.computeIfAbsent(jobId, x -> new ConcurrentHashMap());
        this.filePathsManager.addJobId(jobId);
        return jobId;
    }

    public void beginQueryOfGivenQueryPaths(long jobId, List<Path> queryPaths) throws StorageEngineException {
        HashSet deviceIdSet = new HashSet();
        queryPaths.forEach(path -> deviceIdSet.add(path.getDevice()));
        for (String deviceId : deviceIdSet) {
            this.putQueryTokenForCurrentRequestThread(jobId, deviceId, StorageEngine.getInstance().beginQuery(deviceId));
        }
    }

    public void beginQueryOfGivenExpression(long jobId, IExpression expression) throws StorageEngineException {
        HashSet<String> deviceIdSet = new HashSet<String>();
        this.getUniquePaths(expression, deviceIdSet);
        for (String deviceId : deviceIdSet) {
            this.putQueryTokenForCurrentRequestThread(jobId, deviceId, StorageEngine.getInstance().beginQuery(deviceId));
        }
    }

    public void beginQueryOfGivenExpression(long jobId, IExpression expression, Set<String> remoteDeviceIdSet) throws StorageEngineException {
        HashSet<String> deviceIdSet = new HashSet<String>();
        this.getUniquePaths(expression, deviceIdSet);
        deviceIdSet.removeAll(remoteDeviceIdSet);
        for (String deviceId : deviceIdSet) {
            this.putQueryTokenForCurrentRequestThread(jobId, deviceId, StorageEngine.getInstance().beginQuery(deviceId));
        }
    }

    public QueryDataSource getQueryDataSource(Path selectedPath, QueryContext context) throws StorageEngineException {
        SingleSeriesExpression singleSeriesExpression = new SingleSeriesExpression(selectedPath, null);
        QueryDataSource queryDataSource = StorageEngine.getInstance().query(singleSeriesExpression, context);
        this.filePathsManager.addUsedFilesForGivenJob(context.getJobId(), queryDataSource);
        return queryDataSource;
    }

    public void endQueryForGivenJob(long jobId) throws StorageEngineException {
        if (this.queryTokensMap.get(jobId) == null) {
            return;
        }
        for (Map.Entry<String, List<Integer>> entry : this.queryTokensMap.get(jobId).entrySet()) {
            for (int token : entry.getValue()) {
                StorageEngine.getInstance().endQuery(entry.getKey(), token);
            }
        }
        this.queryTokensMap.remove(jobId);
        this.filePathsManager.removeUsedFilesForGivenJob(jobId);
    }

    private void getUniquePaths(IExpression expression, Set<String> deviceIdSet) {
        if (expression.getType() == ExpressionType.AND || expression.getType() == ExpressionType.OR) {
            this.getUniquePaths(((IBinaryExpression)expression).getLeft(), deviceIdSet);
            this.getUniquePaths(((IBinaryExpression)expression).getRight(), deviceIdSet);
        } else if (expression.getType() == ExpressionType.SERIES) {
            SingleSeriesExpression singleSeriesExp = (SingleSeriesExpression)expression;
            deviceIdSet.add(singleSeriesExp.getSeriesPath().getDevice());
        }
    }

    private void putQueryTokenForCurrentRequestThread(long jobId, String deviceId, int queryToken) {
        this.queryTokensMap.get(jobId).computeIfAbsent(deviceId, x -> new ArrayList()).add(queryToken);
    }

    private static class QueryTokenManagerHelper {
        private static final QueryResourceManager INSTANCE = new QueryResourceManager();

        private QueryTokenManagerHelper() {
        }
    }
}

