/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.auth.authorizer.LocalFileAuthorizer;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.cost.statistic.Measurement;
import org.apache.iotdb.db.cost.statistic.Operation;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.exception.ArgsErrorException;
import org.apache.iotdb.db.exception.MetadataErrorException;
import org.apache.iotdb.db.exception.PathErrorException;
import org.apache.iotdb.db.exception.ProcessorException;
import org.apache.iotdb.db.exception.QueryInBatchStmtException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.qp.IllegalASTFormatException;
import org.apache.iotdb.db.exception.qp.QueryProcessorException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.metadata.Metadata;
import org.apache.iotdb.db.qp.QueryProcessor;
import org.apache.iotdb.db.qp.executor.QueryProcessExecutor;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.sys.AuthorPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.utils.QueryDataSetUtils;
import org.apache.iotdb.service.rpc.thrift.ServerProperties;
import org.apache.iotdb.service.rpc.thrift.TSCancelOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSCancelOperationResp;
import org.apache.iotdb.service.rpc.thrift.TSCloseOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSCloseOperationResp;
import org.apache.iotdb.service.rpc.thrift.TSCloseSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSCloseSessionResp;
import org.apache.iotdb.service.rpc.thrift.TSExecuteBatchStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteBatchStatementResp;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.iotdb.service.rpc.thrift.TSFetchMetadataReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchMetadataResp;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsResp;
import org.apache.iotdb.service.rpc.thrift.TSGetTimeZoneResp;
import org.apache.iotdb.service.rpc.thrift.TSHandleIdentifier;
import org.apache.iotdb.service.rpc.thrift.TSIService;
import org.apache.iotdb.service.rpc.thrift.TSInsertionReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionResp;
import org.apache.iotdb.service.rpc.thrift.TSOperationHandle;
import org.apache.iotdb.service.rpc.thrift.TSProtocolVersion;
import org.apache.iotdb.service.rpc.thrift.TSQueryDataSet;
import org.apache.iotdb.service.rpc.thrift.TSSetTimeZoneReq;
import org.apache.iotdb.service.rpc.thrift.TSSetTimeZoneResp;
import org.apache.iotdb.service.rpc.thrift.TS_SessionHandle;
import org.apache.iotdb.service.rpc.thrift.TS_Status;
import org.apache.iotdb.service.rpc.thrift.TS_StatusCode;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.thrift.TException;
import org.apache.thrift.server.ServerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSServiceImpl
implements TSIService.Iface,
ServerContext {
    private static final Logger logger = LoggerFactory.getLogger(TSServiceImpl.class);
    private static final String INFO_NOT_LOGIN = "{}: Not login.";
    private static final String ERROR_NOT_LOGIN = "Not login";
    protected QueryProcessor processor;
    protected ThreadLocal<String> username = new ThreadLocal();
    private ThreadLocal<HashMap<String, PhysicalPlan>> queryStatus = new ThreadLocal();
    private ThreadLocal<HashMap<String, QueryDataSet>> queryRet = new ThreadLocal();
    private ThreadLocal<ZoneId> zoneIds = new ThreadLocal();
    private IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private ThreadLocal<Map<Long, QueryContext>> contextMapLocal = new ThreadLocal();
    private AtomicLong globalStmtId = new AtomicLong(0L);
    private Map<Long, PhysicalPlan> idStmtMap = new ConcurrentHashMap<Long, PhysicalPlan>();

    public TSServiceImpl() throws IOException {
        this.processor = new QueryProcessor(new QueryProcessExecutor());
    }

    public TSOpenSessionResp openSession(TSOpenSessionReq req) throws TException {
        TS_Status tsStatus;
        boolean status;
        LocalFileAuthorizer authorizer;
        logger.info("{}: receive open session request from username {}", (Object)"IoTDB", (Object)req.getUsername());
        try {
            authorizer = LocalFileAuthorizer.getInstance();
        }
        catch (AuthException e) {
            throw new TException((Throwable)e);
        }
        try {
            status = authorizer.login(req.getUsername(), req.getPassword());
        }
        catch (AuthException e) {
            logger.error("meet error while logging in.", (Throwable)e);
            status = false;
        }
        if (status) {
            tsStatus = new TS_Status(TS_StatusCode.SUCCESS_STATUS);
            tsStatus.setErrorMessage("login successfully.");
            this.username.set(req.getUsername());
            this.zoneIds.set(this.config.getZoneID());
            this.initForOneSession();
        } else {
            tsStatus = new TS_Status(TS_StatusCode.ERROR_STATUS);
            tsStatus.setErrorMessage("login failed. Username or password is wrong.");
        }
        TSOpenSessionResp resp = new TSOpenSessionResp(tsStatus, TSProtocolVersion.TSFILE_SERVICE_PROTOCOL_V1);
        resp.setSessionHandle(new TS_SessionHandle(new TSHandleIdentifier(ByteBuffer.wrap(req.getUsername().getBytes()), ByteBuffer.wrap(req.getPassword().getBytes()))));
        logger.info("{}: Login status: {}. User : {}", new Object[]{"IoTDB", tsStatus.getErrorMessage(), req.getUsername()});
        return resp;
    }

    private void initForOneSession() {
        this.queryStatus.set(new HashMap());
        this.queryRet.set(new HashMap());
    }

    public TSCloseSessionResp closeSession(TSCloseSessionReq req) {
        TS_Status tsStatus;
        logger.info("{}: receive close session", (Object)"IoTDB");
        if (this.username.get() == null) {
            tsStatus = new TS_Status(TS_StatusCode.ERROR_STATUS);
            tsStatus.setErrorMessage("Has not logged in");
            if (this.zoneIds.get() != null) {
                this.zoneIds.remove();
            }
        } else {
            tsStatus = new TS_Status(TS_StatusCode.SUCCESS_STATUS);
            this.username.remove();
            if (this.zoneIds.get() != null) {
                this.zoneIds.remove();
            }
        }
        return new TSCloseSessionResp(tsStatus);
    }

    public TSCancelOperationResp cancelOperation(TSCancelOperationReq req) {
        return new TSCancelOperationResp(new TS_Status(TS_StatusCode.SUCCESS_STATUS));
    }

    public TSCloseOperationResp closeOperation(TSCloseOperationReq req) {
        logger.info("{}: receive close operation", (Object)"IoTDB");
        try {
            if (req != null && req.isSetStmtId()) {
                long stmtId = req.getStmtId();
                this.idStmtMap.remove(stmtId);
            }
            this.releaseQueryResource(req);
            this.clearAllStatusForCurrentRequest();
        }
        catch (Exception e) {
            logger.error("Error in closeOperation : ", (Throwable)e);
        }
        return new TSCloseOperationResp(new TS_Status(TS_StatusCode.SUCCESS_STATUS));
    }

    private void releaseQueryResource(TSCloseOperationReq req) throws StorageEngineException {
        Map<Long, QueryContext> contextMap = this.contextMapLocal.get();
        if (contextMap == null) {
            return;
        }
        if (req == null || req.queryId == -1L) {
            for (QueryContext context : contextMap.values()) {
                QueryResourceManager.getInstance().endQueryForGivenJob(context.getJobId());
            }
            this.contextMapLocal.set(new HashMap());
        } else {
            QueryResourceManager.getInstance().endQueryForGivenJob(contextMap.remove(req.queryId).getJobId());
        }
    }

    private void clearAllStatusForCurrentRequest() {
        if (this.queryRet.get() != null) {
            this.queryRet.get().clear();
        }
        if (this.queryStatus.get() != null) {
            this.queryStatus.get().clear();
        }
    }

    private TS_Status getErrorStatus(String message) {
        TS_Status status = new TS_Status(TS_StatusCode.ERROR_STATUS);
        status.setErrorMessage(message);
        return status;
    }

    public TSFetchMetadataResp fetchMetadata(TSFetchMetadataReq req) {
        TS_Status status;
        if (!this.checkLogin()) {
            logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
            TS_Status status2 = this.getErrorStatus(ERROR_NOT_LOGIN);
            return new TSFetchMetadataResp(status2);
        }
        TSFetchMetadataResp resp = new TSFetchMetadataResp();
        try {
            switch (req.getType()) {
                case "SHOW_TIMESERIES": {
                    String path = req.getColumnPath();
                    List<List<String>> showTimeseriesList = this.getTimeSeriesForPath(path);
                    resp.setShowTimeseriesList(showTimeseriesList);
                    status = new TS_Status(TS_StatusCode.SUCCESS_STATUS);
                    break;
                }
                case "SHOW_STORAGE_GROUP": {
                    Set<String> storageGroups = this.getAllStorageGroups();
                    resp.setShowStorageGroups(storageGroups);
                    status = new TS_Status(TS_StatusCode.SUCCESS_STATUS);
                    break;
                }
                case "METADATA_IN_JSON": {
                    String metadataInJson = this.getMetadataInString();
                    resp.setMetadataInJson(metadataInJson);
                    status = new TS_Status(TS_StatusCode.SUCCESS_STATUS);
                    break;
                }
                case "DELTA_OBEJECT": {
                    Metadata metadata = this.getMetadata();
                    String column = req.getColumnPath();
                    Map<String, List<String>> deviceMap = metadata.getDeviceMap();
                    if (deviceMap == null || !deviceMap.containsKey(column)) {
                        resp.setColumnsList(new ArrayList());
                    } else {
                        resp.setColumnsList(deviceMap.get(column));
                    }
                    status = new TS_Status(TS_StatusCode.SUCCESS_STATUS);
                    break;
                }
                case "COLUMN": {
                    resp.setDataType(this.getSeriesType(req.getColumnPath()).toString());
                    status = new TS_Status(TS_StatusCode.SUCCESS_STATUS);
                    break;
                }
                case "ALL_COLUMNS": {
                    resp.setColumnsList(this.getPaths(req.getColumnPath()));
                    status = new TS_Status(TS_StatusCode.SUCCESS_STATUS);
                    break;
                }
                default: {
                    status = new TS_Status(TS_StatusCode.ERROR_STATUS);
                    status.setErrorMessage(String.format("Unsupported fetch metadata operation %s", req.getType()));
                    break;
                }
            }
        }
        catch (OutOfMemoryError | MetadataErrorException | PathErrorException e) {
            logger.error(String.format("Failed to fetch timeseries %s's metadata", req.getColumnPath()), e);
            Thread.currentThread().interrupt();
            TS_Status status3 = this.getErrorStatus(String.format("Failed to fetch metadata because: %s", e));
            resp.setStatus(status3);
            return resp;
        }
        resp.setStatus(status);
        return resp;
    }

    private Set<String> getAllStorageGroups() throws PathErrorException {
        return MManager.getInstance().getAllStorageGroup();
    }

    private List<List<String>> getTimeSeriesForPath(String path) throws PathErrorException {
        return MManager.getInstance().getShowTimeseriesPath(path);
    }

    private String getMetadataInString() {
        return MManager.getInstance().getMetadataInString();
    }

    protected Metadata getMetadata() throws PathErrorException {
        return MManager.getInstance().getMetadata();
    }

    protected TSDataType getSeriesType(String path) throws PathErrorException {
        switch (path.toLowerCase()) {
            case "role": 
            case "user": 
            case "privilege": {
                return TSDataType.TEXT;
            }
        }
        if (path.contains("(") && !path.startsWith("(") && path.endsWith(")")) {
            int leftBracketIndex = path.indexOf(40);
            String aggrType = path.substring(0, leftBracketIndex);
            String innerPath = path.substring(leftBracketIndex + 1, path.length() - 1);
            switch (aggrType.toLowerCase()) {
                case "min_time": 
                case "max_time": 
                case "count": {
                    return TSDataType.INT64;
                }
                case "last": 
                case "first": 
                case "min_value": 
                case "max_value": {
                    return this.getSeriesType(innerPath);
                }
                case "mean": 
                case "sum": {
                    return TSDataType.DOUBLE;
                }
            }
            throw new PathErrorException("aggregate does not support " + aggrType + " function.");
        }
        return MManager.getInstance().getSeriesType(path);
    }

    protected List<String> getPaths(String path) throws MetadataErrorException {
        return MManager.getInstance().getPaths(path);
    }

    private boolean execAdminCommand(String statement) {
        if (!"root".equals(this.username.get())) {
            return false;
        }
        if (statement == null) {
            return false;
        }
        switch (statement = statement.toLowerCase()) {
            case "flush": {
                StorageEngine.getInstance().syncCloseAllProcessor();
                return true;
            }
            case "merge": {
                throw new UnsupportedOperationException("merge not implemented");
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSExecuteBatchStatementResp executeBatchStatement(TSExecuteBatchStatementReq req) {
        long t1 = System.currentTimeMillis();
        String currStmt = null;
        ArrayList<Integer> result = new ArrayList<Integer>();
        try {
            TSExecuteBatchStatementResp tSExecuteBatchStatementResp;
            if (!this.checkLogin()) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                TSExecuteBatchStatementResp tSExecuteBatchStatementResp2 = this.getTSBathExecuteStatementResp(TS_StatusCode.ERROR_STATUS, ERROR_NOT_LOGIN, null);
                return tSExecuteBatchStatementResp2;
            }
            List statements = req.getStatements();
            boolean isAllSuccessful = true;
            StringBuilder batchErrorMessage = new StringBuilder();
            for (String statement : statements) {
                long t2 = System.currentTimeMillis();
                currStmt = statement;
                isAllSuccessful = isAllSuccessful && this.executeStatementInBatch(statement, batchErrorMessage, result);
                Measurement.INSTANCE.addOperationLatency(Operation.EXECUTE_ONE_SQL_IN_BATCH, t2);
            }
            if (isAllSuccessful) {
                tSExecuteBatchStatementResp = this.getTSBathExecuteStatementResp(TS_StatusCode.SUCCESS_STATUS, "Execute batch statements successfully", result);
                return tSExecuteBatchStatementResp;
            }
            tSExecuteBatchStatementResp = this.getTSBathExecuteStatementResp(TS_StatusCode.ERROR_STATUS, batchErrorMessage.toString(), result);
            return tSExecuteBatchStatementResp;
        }
        catch (Exception e) {
            logger.error("{}: error occurs when executing statements", (Object)"IoTDB", (Object)e);
            TSExecuteBatchStatementResp tSExecuteBatchStatementResp = this.getTSBathExecuteStatementResp(TS_StatusCode.ERROR_STATUS, e.getMessage(), null);
            return tSExecuteBatchStatementResp;
        }
        finally {
            Measurement.INSTANCE.addOperationLatency(Operation.EXECUTE_BATCH, t1);
        }
    }

    private boolean executeStatementInBatch(String statement, StringBuilder batchErrorMessage, List<Integer> result) {
        try {
            PhysicalPlan physicalPlan = this.processor.parseSQLToPhysicalPlan(statement, this.zoneIds.get());
            if (physicalPlan.isQuery()) {
                throw new QueryInBatchStmtException("Query statement not allowed in batch: " + statement);
            }
            TSExecuteStatementResp resp = this.executeUpdateStatement(physicalPlan);
            if (!resp.getStatus().getStatusCode().equals((Object)TS_StatusCode.SUCCESS_STATUS)) {
                result.add(-3);
                batchErrorMessage.append(resp.getStatus().getErrorMessage()).append("\n");
                return false;
            }
            result.add(-2);
        }
        catch (Exception e) {
            String errMessage = String.format("Fail to generate physcial plan and execute for statement %s beacuse %s", statement, e.getMessage());
            logger.warn("Error occurred when executing {}", (Object)statement, (Object)e);
            result.add(-3);
            batchErrorMessage.append(errMessage).append("\n");
            return false;
        }
        return true;
    }

    public TSExecuteStatementResp executeStatement(TSExecuteStatementReq req) {
        try {
            if (!this.checkLogin()) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                return this.getTSExecuteStatementResp(TS_StatusCode.ERROR_STATUS, ERROR_NOT_LOGIN);
            }
            String statement = req.getStatement();
            if (this.execAdminCommand(statement)) {
                return this.getTSExecuteStatementResp(TS_StatusCode.SUCCESS_STATUS, "ADMIN_COMMAND_SUCCESS");
            }
            if (this.execSetConsistencyLevel(statement)) {
                return this.getTSExecuteStatementResp(TS_StatusCode.SUCCESS_STATUS, "Execute set consistency level successfully");
            }
            PhysicalPlan physicalPlan = this.processor.parseSQLToPhysicalPlan(statement, this.zoneIds.get());
            if (physicalPlan.isQuery()) {
                return this.executeQueryStatement(req);
            }
            return this.executeUpdateStatement(physicalPlan);
        }
        catch (IllegalASTFormatException e) {
            logger.debug("meet error while parsing SQL to physical plan: ", (Throwable)e);
            return this.getTSExecuteStatementResp(TS_StatusCode.ERROR_STATUS, "Statement format is not right:" + e.getMessage());
        }
        catch (Exception e) {
            logger.info("meet error while executing statement: {}", (Object)req.getStatement(), (Object)e);
            return this.getTSExecuteStatementResp(TS_StatusCode.ERROR_STATUS, e.getMessage());
        }
    }

    private boolean execSetConsistencyLevel(String statement) throws SQLException {
        if (statement == null) {
            return false;
        }
        if (Pattern.matches("set\\s+read.*level.*", statement = statement.toLowerCase().trim())) {
            throw new SQLException("IoTDB Stand-alone version does not support setting read-insert consistency level");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSExecuteStatementResp executeQueryStatement(TSExecuteStatementReq req) {
        long t1 = System.currentTimeMillis();
        try {
            if (!this.checkLogin()) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                TSExecuteStatementResp tSExecuteStatementResp = this.getTSExecuteStatementResp(TS_StatusCode.ERROR_STATUS, ERROR_NOT_LOGIN);
                return tSExecuteStatementResp;
            }
            String statement = req.getStatement();
            PhysicalPlan plan = this.processor.parseSQLToPhysicalPlan(statement, this.zoneIds.get());
            ArrayList<String> columns = new ArrayList<String>();
            TSExecuteStatementResp resp = !(plan instanceof AuthorPlan) ? this.executeDataQuery(plan, columns) : this.executeAuthQuery(plan, columns);
            resp.setOperationType(plan.getOperatorType().toString());
            TSHandleIdentifier operationId = new TSHandleIdentifier(ByteBuffer.wrap(this.username.get().getBytes()), ByteBuffer.wrap("PASS".getBytes()));
            resp.setColumns(columns);
            TSOperationHandle operationHandle = new TSOperationHandle(operationId, true);
            resp.setOperationHandle(operationHandle);
            this.recordANewQuery(statement, plan);
            TSExecuteStatementResp tSExecuteStatementResp = resp;
            return tSExecuteStatementResp;
        }
        catch (Exception e) {
            logger.error("{}: Internal server error: ", (Object)"IoTDB", (Object)e);
            TSExecuteStatementResp tSExecuteStatementResp = this.getTSExecuteStatementResp(TS_StatusCode.ERROR_STATUS, e.getMessage());
            return tSExecuteStatementResp;
        }
        finally {
            Measurement.INSTANCE.addOperationLatency(Operation.EXECUTE_QUERY, t1);
        }
    }

    private TSExecuteStatementResp executeAuthQuery(PhysicalPlan plan, List<String> columns) {
        TSExecuteStatementResp resp = this.getTSExecuteStatementResp(TS_StatusCode.SUCCESS_STATUS, "");
        resp.setIgnoreTimeStamp(true);
        AuthorPlan authorPlan = (AuthorPlan)plan;
        switch (authorPlan.getAuthorType()) {
            case LIST_ROLE: {
                columns.add("Role");
                break;
            }
            case LIST_USER: {
                columns.add("User");
                break;
            }
            case LIST_ROLE_USERS: {
                columns.add("User");
                break;
            }
            case LIST_USER_ROLES: {
                columns.add("Role");
                break;
            }
            case LIST_ROLE_PRIVILEGE: {
                columns.add("Privilege");
                break;
            }
            case LIST_USER_PRIVILEGE: {
                columns.add("Role");
                columns.add("Privilege");
                break;
            }
            default: {
                return this.getTSExecuteStatementResp(TS_StatusCode.ERROR_STATUS, String.format("%s is not an auth query", new Object[]{authorPlan.getAuthorType()}));
            }
        }
        return resp;
    }

    private TSExecuteStatementResp executeDataQuery(PhysicalPlan plan, List<String> columns) throws AuthException, TException {
        List<Path> paths = plan.getPaths();
        if (paths.isEmpty()) {
            return this.getTSExecuteStatementResp(TS_StatusCode.ERROR_STATUS, "Timeseries does not exist.");
        }
        try {
            this.checkFileLevelSet(paths);
        }
        catch (PathErrorException e) {
            logger.error("meet error while checking file level.", (Throwable)e);
            return this.getTSExecuteStatementResp(TS_StatusCode.ERROR_STATUS, e.getMessage());
        }
        if (!this.checkAuthorization(paths, plan)) {
            return this.getTSExecuteStatementResp(TS_StatusCode.ERROR_STATUS, "No permissions for this query.");
        }
        TSExecuteStatementResp resp = this.getTSExecuteStatementResp(TS_StatusCode.SUCCESS_STATUS, "");
        switch (plan.getOperatorType()) {
            case QUERY: 
            case FILL: {
                for (Path p : paths) {
                    columns.add(p.getFullPath());
                }
                break;
            }
            case AGGREGATION: 
            case GROUPBY: {
                int i;
                List<String> aggregations = plan.getAggregations();
                if (aggregations.size() != paths.size()) {
                    for (i = 1; i < paths.size(); ++i) {
                        aggregations.add(aggregations.get(0));
                    }
                }
                for (i = 0; i < paths.size(); ++i) {
                    columns.add(aggregations.get(i) + "(" + paths.get(i).getFullPath() + ")");
                }
                break;
            }
            default: {
                throw new TException("unsupported query type: " + (Object)((Object)plan.getOperatorType()));
            }
        }
        return resp;
    }

    private void checkFileLevelSet(List<Path> paths) throws PathErrorException {
        MManager.getInstance().checkFileLevel(paths);
    }

    public TSFetchResultsResp fetchResults(TSFetchResultsReq req) {
        try {
            boolean hasResultSet;
            if (!this.checkLogin()) {
                return this.getTSFetchResultsResp(TS_StatusCode.ERROR_STATUS, "Not login.");
            }
            String statement = req.getStatement();
            if (!this.queryStatus.get().containsKey(statement)) {
                return this.getTSFetchResultsResp(TS_StatusCode.ERROR_STATUS, "Has not executed statement");
            }
            QueryDataSet queryDataSet = !this.queryRet.get().containsKey(statement) ? this.createNewDataSet(statement, req) : this.queryRet.get().get(statement);
            int fetchSize = req.getFetch_size();
            TSQueryDataSet result = QueryDataSetUtils.convertQueryDataSetByFetchSize(queryDataSet, fetchSize);
            boolean bl = hasResultSet = !result.getRecords().isEmpty();
            if (!hasResultSet && this.queryRet.get() != null) {
                this.queryRet.get().remove(statement);
            }
            TSFetchResultsResp resp = this.getTSFetchResultsResp(TS_StatusCode.SUCCESS_STATUS, "FetchResult successfully. Has more result: " + hasResultSet);
            resp.setHasResultSet(hasResultSet);
            resp.setQueryDataSet(result);
            return resp;
        }
        catch (Exception e) {
            logger.error("{}: Internal server error: ", (Object)"IoTDB", (Object)e);
            return this.getTSFetchResultsResp(TS_StatusCode.ERROR_STATUS, e.getMessage());
        }
    }

    private QueryDataSet createNewDataSet(String statement, TSFetchResultsReq req) throws PathErrorException, QueryFilterOptimizationException, StorageEngineException, ProcessorException, IOException {
        PhysicalPlan physicalPlan = this.queryStatus.get().get(statement);
        QueryContext context = new QueryContext(QueryResourceManager.getInstance().assignJobId());
        this.initContextMap();
        this.contextMapLocal.get().put(req.queryId, context);
        QueryDataSet queryDataSet = this.processor.getExecutor().processQuery(physicalPlan, context);
        this.queryRet.get().put(statement, queryDataSet);
        return queryDataSet;
    }

    private void initContextMap() {
        Map<Long, QueryContext> contextMap = this.contextMapLocal.get();
        if (contextMap == null) {
            contextMap = new HashMap<Long, QueryContext>();
            this.contextMapLocal.set(contextMap);
        }
    }

    public TSExecuteStatementResp executeUpdateStatement(TSExecuteStatementReq req) {
        try {
            if (!this.checkLogin()) {
                return this.getTSExecuteStatementResp(TS_StatusCode.ERROR_STATUS, ERROR_NOT_LOGIN);
            }
            String statement = req.getStatement();
            return this.executeUpdateStatement(statement);
        }
        catch (Exception e) {
            logger.error("{}: server Internal Error: ", (Object)"IoTDB", (Object)e);
            return this.getTSExecuteStatementResp(TS_StatusCode.ERROR_STATUS, e.getMessage());
        }
    }

    private TSExecuteStatementResp executeUpdateStatement(PhysicalPlan plan) {
        boolean execRet;
        List<Path> paths = plan.getPaths();
        try {
            if (!this.checkAuthorization(paths, plan)) {
                return this.getTSExecuteStatementResp(TS_StatusCode.ERROR_STATUS, "No permissions for this operation " + (Object)((Object)plan.getOperatorType()));
            }
        }
        catch (AuthException e) {
            logger.error("meet error while checking authorization.", (Throwable)e);
            return this.getTSExecuteStatementResp(TS_StatusCode.ERROR_STATUS, "Uninitialized authorizer " + e.getMessage());
        }
        try {
            execRet = this.executeNonQuery(plan);
        }
        catch (ProcessorException e) {
            logger.debug("meet error while processing non-query. ", (Throwable)e);
            return this.getTSExecuteStatementResp(TS_StatusCode.ERROR_STATUS, e.getMessage());
        }
        TS_StatusCode statusCode = execRet ? TS_StatusCode.SUCCESS_STATUS : TS_StatusCode.ERROR_STATUS;
        String msg = execRet ? "Execute successfully" : "Execute statement error.";
        TSExecuteStatementResp resp = this.getTSExecuteStatementResp(statusCode, msg);
        TSHandleIdentifier operationId = new TSHandleIdentifier(ByteBuffer.wrap(this.username.get().getBytes()), ByteBuffer.wrap("PASS".getBytes()));
        TSOperationHandle operationHandle = new TSOperationHandle(operationId, false);
        resp.setOperationHandle(operationHandle);
        return resp;
    }

    private boolean executeNonQuery(PhysicalPlan plan) throws ProcessorException {
        if (IoTDBDescriptor.getInstance().getConfig().isReadOnly()) {
            throw new ProcessorException("Current system mode is read-only, does not support non-query operation");
        }
        return this.processor.getExecutor().processNonQuery(plan);
    }

    private TSExecuteStatementResp executeUpdateStatement(String statement) {
        PhysicalPlan physicalPlan;
        try {
            physicalPlan = this.processor.parseSQLToPhysicalPlan(statement, this.zoneIds.get());
        }
        catch (ArgsErrorException | MetadataErrorException | QueryProcessorException e) {
            logger.error("meet error while parsing SQL to physical plan!", (Throwable)e);
            return this.getTSExecuteStatementResp(TS_StatusCode.ERROR_STATUS, e.getMessage());
        }
        if (physicalPlan.isQuery()) {
            return this.getTSExecuteStatementResp(TS_StatusCode.ERROR_STATUS, "Statement is a query statement.");
        }
        return this.executeUpdateStatement(physicalPlan);
    }

    private void recordANewQuery(String statement, PhysicalPlan physicalPlan) {
        this.queryStatus.get().put(statement, physicalPlan);
        this.queryRet.get().remove(statement);
    }

    private boolean checkLogin() {
        return this.username.get() != null;
    }

    private boolean checkAuthorization(List<Path> paths, PhysicalPlan plan) throws AuthException {
        String targetUser = null;
        if (plan instanceof AuthorPlan) {
            targetUser = ((AuthorPlan)plan).getUserName();
        }
        return AuthorityChecker.check(this.username.get(), paths, plan.getOperatorType(), targetUser);
    }

    private TSExecuteStatementResp getTSExecuteStatementResp(TS_StatusCode code, String msg) {
        TSExecuteStatementResp resp = new TSExecuteStatementResp();
        TS_Status tsStatus = new TS_Status(code);
        tsStatus.setErrorMessage(msg);
        resp.setStatus(tsStatus);
        TSHandleIdentifier operationId = new TSHandleIdentifier(ByteBuffer.wrap(this.username.get().getBytes()), ByteBuffer.wrap("PASS".getBytes()));
        TSOperationHandle operationHandle = new TSOperationHandle(operationId, false);
        resp.setOperationHandle(operationHandle);
        return resp;
    }

    private TSExecuteBatchStatementResp getTSBathExecuteStatementResp(TS_StatusCode code, String msg, List<Integer> result) {
        TSExecuteBatchStatementResp resp = new TSExecuteBatchStatementResp();
        TS_Status tsStatus = new TS_Status(code);
        tsStatus.setErrorMessage(msg);
        resp.setStatus(tsStatus);
        resp.setResult(result);
        return resp;
    }

    private TSFetchResultsResp getTSFetchResultsResp(TS_StatusCode code, String msg) {
        TSFetchResultsResp resp = new TSFetchResultsResp();
        TS_Status tsStatus = new TS_Status(code);
        tsStatus.setErrorMessage(msg);
        resp.setStatus(tsStatus);
        return resp;
    }

    void handleClientExit() throws TException {
        this.closeOperation(null);
        this.closeSession(null);
    }

    public TSGetTimeZoneResp getTimeZone() {
        TSGetTimeZoneResp resp;
        try {
            TS_Status tsStatus = new TS_Status(TS_StatusCode.SUCCESS_STATUS);
            resp = new TSGetTimeZoneResp(tsStatus, this.zoneIds.get().toString());
        }
        catch (Exception e) {
            logger.error("meet error while generating time zone.", (Throwable)e);
            TS_Status tsStatus = new TS_Status(TS_StatusCode.ERROR_STATUS);
            tsStatus.setErrorMessage(e.getMessage());
            resp = new TSGetTimeZoneResp(tsStatus, "Unknown time zone");
        }
        return resp;
    }

    public TSSetTimeZoneResp setTimeZone(TSSetTimeZoneReq req) {
        TS_Status tsStatus;
        try {
            String timeZoneID = req.getTimeZone();
            this.zoneIds.set(ZoneId.of(timeZoneID));
            tsStatus = new TS_Status(TS_StatusCode.SUCCESS_STATUS);
        }
        catch (Exception e) {
            logger.error("meet error while setting time zone.", (Throwable)e);
            tsStatus = new TS_Status(TS_StatusCode.ERROR_STATUS);
            tsStatus.setErrorMessage(e.getMessage());
        }
        return new TSSetTimeZoneResp(tsStatus);
    }

    public ServerProperties getProperties() {
        ServerProperties properties = new ServerProperties();
        properties.setVersion("0.8.0");
        properties.setSupportedTimeAggregationOperations(new ArrayList());
        properties.getSupportedTimeAggregationOperations().add("max_time");
        properties.getSupportedTimeAggregationOperations().add("min_time");
        return properties;
    }

    public TSExecuteStatementResp executeInsertion(TSInsertionReq req) {
        if (!this.checkLogin()) {
            logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
            return this.getTSExecuteStatementResp(TS_StatusCode.ERROR_STATUS, ERROR_NOT_LOGIN);
        }
        long stmtId = req.getStmtId();
        InsertPlan plan = (InsertPlan)this.idStmtMap.computeIfAbsent(stmtId, k -> new InsertPlan());
        if (req.isSetDeviceId()) {
            plan.setDeviceId(req.getDeviceId());
        }
        if (req.isSetTimestamp()) {
            plan.setTime(req.getTimestamp());
        }
        if (req.isSetMeasurements()) {
            plan.setMeasurements(req.getMeasurements().toArray(new String[0]));
        }
        if (req.isSetValues()) {
            plan.setValues(req.getValues().toArray(new String[0]));
        }
        try {
            return this.executeUpdateStatement(plan);
        }
        catch (Exception e) {
            logger.info("meet error while executing an insertion into {}", (Object)req.getDeviceId(), (Object)e);
            return this.getTSExecuteStatementResp(TS_StatusCode.ERROR_STATUS, e.getMessage());
        }
    }

    public long requestStatementId() {
        return this.globalStmtId.incrementAndGet();
    }
}

