/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.writelog.recover;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.iotdb.db.engine.memtable.MemTableFlushTask;
import org.apache.iotdb.db.engine.memtable.PrimitiveMemTable;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.version.VersionController;
import org.apache.iotdb.db.exception.ProcessorException;
import org.apache.iotdb.db.writelog.manager.MultiFileLogNodeManager;
import org.apache.iotdb.db.writelog.recover.LogReplayer;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetaData;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadataIndex;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetaData;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.write.schema.FileSchema;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileRecoverPerformer {
    private static final Logger logger = LoggerFactory.getLogger(TsFileRecoverPerformer.class);
    private String insertFilePath;
    private String logNodePrefix;
    private FileSchema fileSchema;
    private VersionController versionController;
    private LogReplayer logReplayer;
    private TsFileResource tsFileResource;
    private boolean acceptUnseq;

    public TsFileRecoverPerformer(String logNodePrefix, FileSchema fileSchema, VersionController versionController, TsFileResource currentTsFileResource, boolean acceptUnseq) {
        this.insertFilePath = currentTsFileResource.getFile().getPath();
        this.logNodePrefix = logNodePrefix;
        this.fileSchema = fileSchema;
        this.versionController = versionController;
        this.tsFileResource = currentTsFileResource;
        this.acceptUnseq = acceptUnseq;
    }

    public void recover() throws ProcessorException {
        RestorableTsFileIOWriter restorableTsFileIOWriter;
        PrimitiveMemTable recoverMemTable = new PrimitiveMemTable();
        this.logReplayer = new LogReplayer(this.logNodePrefix, this.insertFilePath, this.tsFileResource.getModFile(), this.versionController, this.tsFileResource, this.fileSchema, recoverMemTable, this.acceptUnseq);
        File insertFile = new File(this.insertFilePath);
        if (!insertFile.exists()) {
            logger.error("TsFile {} is missing, will skip its recovery.", (Object)this.insertFilePath);
            return;
        }
        try {
            restorableTsFileIOWriter = new RestorableTsFileIOWriter(insertFile);
        }
        catch (IOException e) {
            throw new ProcessorException(e);
        }
        if (!restorableTsFileIOWriter.hasCrashed()) {
            try {
                if (this.tsFileResource.fileExists()) {
                    this.tsFileResource.deSerialize();
                } else {
                    try (TsFileSequenceReader reader = new TsFileSequenceReader(this.tsFileResource.getFile().getAbsolutePath());){
                        TsFileMetaData metaData = reader.readFileMetadata();
                        ArrayList deviceMetadataIndexList = new ArrayList(metaData.getDeviceMap().values());
                        for (TsDeviceMetadataIndex index : deviceMetadataIndexList) {
                            TsDeviceMetadata deviceMetadata = reader.readTsDeviceMetaData(index);
                            List chunkGroupMetaDataList = deviceMetadata.getChunkGroupMetaDataList();
                            for (ChunkGroupMetaData chunkGroupMetaData : chunkGroupMetaDataList) {
                                for (ChunkMetaData chunkMetaData : chunkGroupMetaData.getChunkMetaDataList()) {
                                    this.tsFileResource.updateTime(chunkGroupMetaData.getDeviceID(), chunkMetaData.getStartTime());
                                    this.tsFileResource.updateTime(chunkGroupMetaData.getDeviceID(), chunkMetaData.getEndTime());
                                }
                            }
                        }
                    }
                    this.tsFileResource.serialize();
                }
                return;
            }
            catch (IOException e) {
                throw new ProcessorException("recover the resource file failed: " + this.insertFilePath + ".resource", e);
            }
        }
        for (ChunkGroupMetaData chunkGroupMetaData : restorableTsFileIOWriter.getChunkGroupMetaDatas()) {
            for (ChunkMetaData chunkMetaData : chunkGroupMetaData.getChunkMetaDataList()) {
                this.tsFileResource.updateTime(chunkGroupMetaData.getDeviceID(), chunkMetaData.getStartTime());
                this.tsFileResource.updateTime(chunkGroupMetaData.getDeviceID(), chunkMetaData.getEndTime());
            }
        }
        this.logReplayer.replayLogs();
        try {
            if (!recoverMemTable.isEmpty()) {
                MemTableFlushTask tableFlushTask = new MemTableFlushTask(recoverMemTable, this.fileSchema, restorableTsFileIOWriter, this.logNodePrefix);
                tableFlushTask.syncFlushMemTable();
            }
            restorableTsFileIOWriter.endFile(this.fileSchema);
            this.tsFileResource.serialize();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            Thread.currentThread().interrupt();
            throw new ProcessorException(e);
        }
        try {
            MultiFileLogNodeManager.getInstance().deleteNode(this.logNodePrefix + new File(this.insertFilePath).getName());
        }
        catch (IOException e) {
            throw new ProcessorException(e);
        }
    }
}

