/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.adapter.CompressionRatio;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.memtable.MemSeriesLazyMerger;
import org.apache.iotdb.db.engine.memtable.MemTableFlushTask;
import org.apache.iotdb.db.engine.memtable.NotifyFlushMemTable;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.engine.storagegroup.FlushManager;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.version.VersionController;
import org.apache.iotdb.db.exception.TsFileProcessorException;
import org.apache.iotdb.db.qp.constant.DatetimeUtils;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.rescon.MemTablePool;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.db.writelog.manager.MultiFileLogNodeManager;
import org.apache.iotdb.db.writelog.node.WriteLogNode;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.FileSchema;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileProcessor {
    private static final Logger logger = LoggerFactory.getLogger(TsFileProcessor.class);
    private RestorableTsFileIOWriter writer;
    private FileSchema fileSchema;
    private final String storageGroupName;
    private TsFileResource tsFileResource;
    private volatile boolean managedByFlushManager;
    private ReadWriteLock flushQueryLock = new ReentrantReadWriteLock();
    private volatile boolean shouldClose;
    private IMemTable workMemTable;
    private final ConcurrentLinkedDeque<IMemTable> flushingMemTables = new ConcurrentLinkedDeque();
    private VersionController versionController;
    private StorageGroupProcessor.CloseTsFileCallBack closeTsFileCallback;
    private Supplier updateLatestFlushTimeCallback;
    private WriteLogNode logNode;
    private boolean sequence;
    private long totalMemTableSize;

    TsFileProcessor(String storageGroupName, File tsfile, FileSchema fileSchema, VersionController versionController, StorageGroupProcessor.CloseTsFileCallBack closeTsFileCallback, Supplier updateLatestFlushTimeCallback, boolean sequence) throws IOException {
        this.storageGroupName = storageGroupName;
        this.fileSchema = fileSchema;
        this.tsFileResource = new TsFileResource(tsfile, this);
        this.versionController = versionController;
        this.writer = new RestorableTsFileIOWriter(tsfile);
        this.closeTsFileCallback = closeTsFileCallback;
        this.updateLatestFlushTimeCallback = updateLatestFlushTimeCallback;
        this.sequence = sequence;
        logger.info("create a new tsfile processor {}", (Object)tsfile.getAbsolutePath());
    }

    public boolean insert(InsertPlan insertPlan) {
        if (this.workMemTable == null) {
            this.workMemTable = MemTablePool.getInstance().getAvailableMemTable(this);
            if (this.workMemTable == null) {
                return false;
            }
        }
        if (IoTDBDescriptor.getInstance().getConfig().isEnableWal()) {
            try {
                this.getLogNode().write(insertPlan);
            }
            catch (IOException e) {
                logger.error("write WAL failed", (Throwable)e);
                return false;
            }
        }
        this.tsFileResource.updateStartTime(insertPlan.getDeviceId(), insertPlan.getTime());
        if (!this.sequence) {
            this.tsFileResource.updateEndTime(insertPlan.getDeviceId(), insertPlan.getTime());
        }
        this.workMemTable.insert(insertPlan);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDataInMemory(Deletion deletion) {
        this.flushQueryLock.writeLock().lock();
        try {
            if (this.workMemTable != null) {
                this.workMemTable.delete(deletion.getDevice(), deletion.getMeasurement(), deletion.getTimestamp());
            }
            for (IMemTable memTable : this.flushingMemTables) {
                memTable.delete(deletion);
            }
        }
        finally {
            this.flushQueryLock.writeLock().unlock();
        }
    }

    TsFileResource getTsFileResource() {
        return this.tsFileResource;
    }

    boolean shouldFlush() {
        return this.workMemTable != null && this.workMemTable.memSize() > IoTDBDescriptor.getInstance().getConfig().getMemtableSizeThreshold();
    }

    boolean shouldClose() {
        long fileSizeThreshold;
        long fileSize = this.tsFileResource.getFileSize();
        return fileSize > (fileSizeThreshold = IoTDBDescriptor.getInstance().getConfig().getTsFileSizeThreshold());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncClose() {
        logger.info("Sync close file: {}, will firstly async close it", (Object)this.tsFileResource.getFile().getAbsolutePath());
        if (this.shouldClose) {
            return;
        }
        ConcurrentLinkedDeque<IMemTable> concurrentLinkedDeque = this.flushingMemTables;
        synchronized (concurrentLinkedDeque) {
            try {
                this.asyncClose();
                this.flushingMemTables.wait();
            }
            catch (InterruptedException e) {
                logger.error("wait close interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        logger.info("File {} is closed synchronously", (Object)this.tsFileResource.getFile().getAbsolutePath());
    }

    void asyncClose() {
        this.flushQueryLock.writeLock().lock();
        try {
            IMemTable tmpMemTable;
            logger.info("Async close the file: {}", (Object)this.tsFileResource.getFile().getAbsolutePath());
            if (this.shouldClose) {
                return;
            }
            this.shouldClose = true;
            IMemTable iMemTable = tmpMemTable = this.workMemTable == null ? new NotifyFlushMemTable() : this.workMemTable;
            if (logger.isDebugEnabled()) {
                if (tmpMemTable.isSignalMemTable()) {
                    logger.debug("storage group {} add a signal memtable into flushing memtable list when async close", (Object)this.storageGroupName);
                } else {
                    logger.debug("storage group {} async flush a memtable when async close", (Object)this.storageGroupName);
                }
            }
            try {
                this.addAMemtableIntoFlushingList(tmpMemTable);
            }
            catch (IOException e) {
                logger.error("async close failed, because", (Throwable)e);
            }
        }
        finally {
            this.flushQueryLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncFlush() throws IOException {
        IMemTable tmpMemTable;
        this.flushQueryLock.writeLock().lock();
        try {
            IMemTable iMemTable = tmpMemTable = this.workMemTable == null ? new NotifyFlushMemTable() : this.workMemTable;
            if (tmpMemTable.isSignalMemTable()) {
                logger.debug("add a signal memtable into flushing memtable list when sync flush");
            }
            this.addAMemtableIntoFlushingList(tmpMemTable);
        }
        finally {
            this.flushQueryLock.writeLock().unlock();
        }
        IMemTable iMemTable = tmpMemTable;
        synchronized (iMemTable) {
            try {
                long startWait = System.currentTimeMillis();
                while (true) {
                    block14: {
                        tmpMemTable.wait(1000L);
                        this.flushQueryLock.readLock().lock();
                        try {
                            if (this.flushingMemTables.contains(tmpMemTable)) break block14;
                            break;
                        }
                        finally {
                            this.flushQueryLock.readLock().unlock();
                        }
                    }
                    if (System.currentTimeMillis() - startWait <= 60000L) continue;
                    logger.warn("has waited for synced flushing a memtable in {} for 60 seconds.", (Object)this.tsFileResource.getFile().getAbsolutePath());
                    startWait = System.currentTimeMillis();
                }
            }
            catch (InterruptedException e) {
                logger.error("wait flush finished meets error", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    public void asyncFlush() {
        this.flushQueryLock.writeLock().lock();
        try {
            if (this.workMemTable == null) {
                return;
            }
            this.addAMemtableIntoFlushingList(this.workMemTable);
        }
        catch (IOException e) {
            logger.error("WAL notify start flush failed", (Throwable)e);
        }
        finally {
            this.flushQueryLock.writeLock().unlock();
        }
    }

    private void addAMemtableIntoFlushingList(IMemTable tobeFlushed) throws IOException {
        this.updateLatestFlushTimeCallback.get();
        this.flushingMemTables.addLast(tobeFlushed);
        tobeFlushed.setVersion(this.versionController.nextVersion());
        if (IoTDBDescriptor.getInstance().getConfig().isEnableWal()) {
            this.getLogNode().notifyStartFlush();
        }
        if (!tobeFlushed.isSignalMemTable()) {
            this.totalMemTableSize += tobeFlushed.memSize();
        }
        this.workMemTable = null;
        FlushManager.getInstance().registerTsFileProcessor(this);
    }

    private void releaseFlushedMemTable(IMemTable memTable) {
        this.flushQueryLock.writeLock().lock();
        try {
            this.writer.makeMetadataVisible();
            this.flushingMemTables.remove(memTable);
            memTable.release();
            MemTablePool.getInstance().putBack(memTable, this.storageGroupName);
            logger.debug("storage group {} flush finished, remove a memtable from flushing list, flushing memtable list size: {}", (Object)this.storageGroupName, (Object)this.flushingMemTables.size());
        }
        finally {
            this.flushQueryLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushOneMemTable() {
        Object flushTask;
        IMemTable memTableToFlush = this.flushingMemTables.getFirst();
        logger.info("storage group {} starts to flush a memtable in a flush thread", (Object)this.storageGroupName);
        if (!memTableToFlush.isSignalMemTable()) {
            flushTask = new MemTableFlushTask(memTableToFlush, this.fileSchema, this.writer, this.storageGroupName);
            try {
                this.writer.mark();
                ((MemTableFlushTask)flushTask).syncFlushMemTable();
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                logger.error("meet error when flushing a memtable, change system mode to read-only", (Throwable)e);
                IoTDBDescriptor.getInstance().getConfig().setReadOnly(true);
                try {
                    logger.error("IOTask meets error, truncate the corrupted data", (Throwable)e);
                    this.writer.reset();
                }
                catch (IOException e1) {
                    logger.error("Truncate corrupted data meets error", (Throwable)e1);
                }
                Thread.currentThread().interrupt();
            }
            if (IoTDBDescriptor.getInstance().getConfig().isEnableWal()) {
                this.getLogNode().notifyEndFlush();
            }
        }
        this.releaseFlushedMemTable(memTableToFlush);
        flushTask = memTableToFlush;
        synchronized (flushTask) {
            memTableToFlush.notifyAll();
        }
        if (this.shouldClose && this.flushingMemTables.isEmpty()) {
            try {
                this.writer.mark();
                try {
                    double compressionRatio = (double)this.totalMemTableSize / (double)this.writer.getPos();
                    logger.debug("totalMemTableSize: {}, writer.getPos(): {}", (Object)this.totalMemTableSize, (Object)this.writer.getPos());
                    if (compressionRatio == 0.0) {
                        logger.error("compressionRatio = 0, please check the log.");
                    }
                    CompressionRatio.getInstance().updateRatio(compressionRatio);
                }
                catch (IOException e) {
                    logger.error("update compression ratio failed", (Throwable)e);
                }
                this.endFile();
            }
            catch (IOException | TsFileProcessorException e) {
                logger.error("meet error when flush FileMetadata to {}, change system mode to read-only", (Object)this.tsFileResource.getFile().getAbsolutePath());
                IoTDBDescriptor.getInstance().getConfig().setReadOnly(true);
                try {
                    this.writer.reset();
                }
                catch (IOException e1) {
                    logger.error("truncate corrupted data meets error", (Throwable)e1);
                }
                logger.error("marking or ending file meet error", (Throwable)e);
            }
            ConcurrentLinkedDeque<IMemTable> concurrentLinkedDeque = this.flushingMemTables;
            synchronized (concurrentLinkedDeque) {
                this.flushingMemTables.notifyAll();
            }
        }
    }

    private void endFile() throws IOException, TsFileProcessorException {
        long closeStartTime = System.currentTimeMillis();
        this.tsFileResource.serialize();
        this.writer.endFile(this.fileSchema);
        this.closeTsFileCallback.call(this);
        this.writer = null;
        if (logger.isInfoEnabled()) {
            long closeEndTime = System.currentTimeMillis();
            logger.info("Storage group {} close the file {}, start time is {}, end time is {}, time consumption of flushing metadata is {}ms", new Object[]{this.storageGroupName, this.tsFileResource.getFile().getAbsoluteFile(), DatetimeUtils.convertMillsecondToZonedDateTime(closeStartTime), DatetimeUtils.convertMillsecondToZonedDateTime(closeEndTime), closeEndTime - closeStartTime});
        }
    }

    boolean isManagedByFlushManager() {
        return this.managedByFlushManager;
    }

    WriteLogNode getLogNode() {
        if (this.logNode == null) {
            this.logNode = MultiFileLogNodeManager.getInstance().getNode(this.storageGroupName + "-" + this.tsFileResource.getFile().getName());
        }
        return this.logNode;
    }

    public void close() throws TsFileProcessorException {
        try {
            this.tsFileResource.close();
            MultiFileLogNodeManager.getInstance().deleteNode(this.storageGroupName + "-" + this.tsFileResource.getFile().getName());
        }
        catch (IOException e) {
            throw new TsFileProcessorException(e);
        }
    }

    void setManagedByFlushManager(boolean managedByFlushManager) {
        this.managedByFlushManager = managedByFlushManager;
    }

    int getFlushingMemTableSize() {
        return this.flushingMemTables.size();
    }

    long getWorkMemTableMemory() {
        return this.workMemTable.memSize();
    }

    RestorableTsFileIOWriter getWriter() {
        return this.writer;
    }

    String getStorageGroupName() {
        return this.storageGroupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<ReadOnlyMemChunk, List<ChunkMetaData>> query(String deviceId, String measurementId, TSDataType dataType, Map<String, String> props, QueryContext context) {
        this.flushQueryLock.readLock().lock();
        try {
            ReadOnlyMemChunk memChunk;
            MemSeriesLazyMerger memSeriesLazyMerger = new MemSeriesLazyMerger();
            for (IMemTable flushingMemTable : this.flushingMemTables) {
                ReadOnlyMemChunk memChunk2;
                if (flushingMemTable.isSignalMemTable() || (memChunk2 = flushingMemTable.query(deviceId, measurementId, dataType, props)) == null) continue;
                memSeriesLazyMerger.addMemSeries(memChunk2);
            }
            if (this.workMemTable != null && (memChunk = this.workMemTable.query(deviceId, measurementId, dataType, props)) != null) {
                memSeriesLazyMerger.addMemSeries(memChunk);
            }
            ReadOnlyMemChunk timeValuePairSorter = new ReadOnlyMemChunk(dataType, memSeriesLazyMerger, Collections.emptyMap());
            ModificationFile modificationFile = this.tsFileResource.getModFile();
            List<Modification> modifications = context.getPathModifications(modificationFile, deviceId + '.' + measurementId);
            List chunkMetaDataList = this.writer.getVisibleMetadataList(deviceId, measurementId, dataType);
            QueryUtils.modifyChunkMetaData(chunkMetaDataList, modifications);
            Pair pair = new Pair((Object)timeValuePairSorter, (Object)chunkMetaDataList);
            return pair;
        }
        finally {
            this.flushQueryLock.readLock().unlock();
        }
    }
}

