/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import org.apache.iotdb.db.exception.ProcessorException;
import org.apache.iotdb.db.query.aggregation.AggreResultData;
import org.apache.iotdb.db.query.aggregation.AggregateFunction;
import org.apache.iotdb.db.query.reader.IPointReader;
import org.apache.iotdb.db.query.reader.IReaderByTimestamp;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;

public class FirstAggrFunc
extends AggregateFunction {
    public FirstAggrFunc(TSDataType dataType) {
        super(dataType);
    }

    @Override
    public void init() {
        this.resultData.reset();
    }

    @Override
    public AggreResultData getResult() {
        return this.resultData;
    }

    @Override
    public void calculateValueFromPageHeader(PageHeader pageHeader) throws ProcessorException {
        if (this.resultData.isSetTime()) {
            return;
        }
        Object firstVal = pageHeader.getStatistics().getFirst();
        if (firstVal == null) {
            throw new ProcessorException("PageHeader contains no FIRST value");
        }
        this.resultData.putTimeAndValue(0L, firstVal);
    }

    @Override
    public void calculateValueFromPageData(BatchData dataInThisPage, IPointReader unsequenceReader) throws IOException {
        if (this.resultData.isSetTime()) {
            return;
        }
        if (dataInThisPage.hasNext() && unsequenceReader.hasNext()) {
            if (dataInThisPage.currentTime() >= unsequenceReader.current().getTimestamp()) {
                this.resultData.putTimeAndValue(0L, unsequenceReader.current().getValue().getValue());
                unsequenceReader.next();
                return;
            }
            this.resultData.putTimeAndValue(0L, dataInThisPage.currentValue());
            dataInThisPage.next();
            return;
        }
        if (dataInThisPage.hasNext()) {
            this.resultData.putTimeAndValue(0L, dataInThisPage.currentValue());
        }
    }

    @Override
    public void calculateValueFromPageData(BatchData dataInThisPage, IPointReader unsequenceReader, long bound) throws IOException {
        if (this.resultData.isSetTime()) {
            return;
        }
        if (dataInThisPage.hasNext() && unsequenceReader.hasNext()) {
            if (dataInThisPage.currentTime() >= unsequenceReader.current().getTimestamp()) {
                if (unsequenceReader.current().getTimestamp() < bound) {
                    this.resultData.putTimeAndValue(0L, unsequenceReader.current().getValue().getValue());
                    unsequenceReader.next();
                    return;
                }
            } else if (dataInThisPage.currentTime() < bound) {
                this.resultData.putTimeAndValue(0L, dataInThisPage.currentValue());
                dataInThisPage.next();
                return;
            }
        }
        if (dataInThisPage.hasNext() && dataInThisPage.currentTime() < bound) {
            this.resultData.putTimeAndValue(0L, dataInThisPage.currentValue());
            dataInThisPage.next();
        }
    }

    @Override
    public void calculateValueFromUnsequenceReader(IPointReader unsequenceReader) throws IOException {
        if (this.resultData.isSetTime()) {
            return;
        }
        if (unsequenceReader.hasNext()) {
            this.resultData.putTimeAndValue(0L, unsequenceReader.current().getValue().getValue());
        }
    }

    @Override
    public void calculateValueFromUnsequenceReader(IPointReader unsequenceReader, long bound) throws IOException {
        if (this.resultData.isSetTime()) {
            return;
        }
        if (unsequenceReader.hasNext() && unsequenceReader.current().getTimestamp() < bound) {
            this.resultData.putTimeAndValue(0L, unsequenceReader.current().getValue().getValue());
        }
    }

    @Override
    public void calcAggregationUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        if (this.resultData.isSetTime()) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            Object value = dataReader.getValueInTimestamp(timestamps[i]);
            if (value == null) continue;
            this.resultData.putTimeAndValue(0L, value);
            break;
        }
    }

    @Override
    public boolean isCalculatedAggregationResult() {
        return this.resultData.isSetTime();
    }
}

