/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.aggregation.impl;

import java.io.IOException;
import org.apache.iotdb.db.query.aggregation.AggreResultData;
import org.apache.iotdb.db.query.aggregation.AggregateFunction;
import org.apache.iotdb.db.query.reader.IPointReader;
import org.apache.iotdb.db.query.reader.IReaderByTimestamp;
import org.apache.iotdb.db.utils.TimeValuePair;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;

public class LastAggrFunc
extends AggregateFunction {
    public LastAggrFunc(TSDataType dataType) {
        super(dataType);
    }

    @Override
    public void init() {
        this.resultData.reset();
    }

    @Override
    public AggreResultData getResult() {
        if (this.resultData.isSetTime()) {
            this.resultData.setTimestamp(0L);
        }
        return this.resultData;
    }

    @Override
    public void calculateValueFromPageHeader(PageHeader pageHeader) {
        Object lastVal = pageHeader.getStatistics().getLast();
        this.updateLastResult(pageHeader.getMaxTimestamp(), lastVal);
    }

    @Override
    public void calculateValueFromPageData(BatchData dataInThisPage, IPointReader unsequenceReader) throws IOException {
        this.calculateValueFromPageData(dataInThisPage, unsequenceReader, Long.MAX_VALUE);
    }

    @Override
    public void calculateValueFromPageData(BatchData dataInThisPage, IPointReader unsequenceReader, long bound) throws IOException {
        long time = -1L;
        Object lastVal = null;
        while (dataInThisPage.hasNext() && dataInThisPage.currentTime() < bound) {
            time = dataInThisPage.currentTime();
            lastVal = dataInThisPage.currentValue();
            dataInThisPage.next();
        }
        while (unsequenceReader.hasNext()) {
            if (unsequenceReader.current().getTimestamp() < time) {
                unsequenceReader.next();
                continue;
            }
            if (unsequenceReader.current().getTimestamp() != time) break;
            lastVal = unsequenceReader.current().getValue().getValue();
            unsequenceReader.next();
        }
        if (time != -1L) {
            this.updateLastResult(time, lastVal);
        }
    }

    @Override
    public void calculateValueFromUnsequenceReader(IPointReader unsequenceReader) throws IOException {
        TimeValuePair pair = null;
        while (unsequenceReader.hasNext()) {
            pair = unsequenceReader.next();
        }
        if (pair != null) {
            this.updateLastResult(pair.getTimestamp(), pair.getValue().getValue());
        }
    }

    @Override
    public void calculateValueFromUnsequenceReader(IPointReader unsequenceReader, long bound) throws IOException {
        TimeValuePair pair = null;
        while (unsequenceReader.hasNext() && unsequenceReader.current().getTimestamp() < bound) {
            pair = unsequenceReader.next();
        }
        if (pair != null) {
            this.updateLastResult(pair.getTimestamp(), pair.getValue().getValue());
        }
    }

    @Override
    public void calcAggregationUsingTimestamps(long[] timestamps, int length, IReaderByTimestamp dataReader) throws IOException {
        long time = -1L;
        Object lastVal = null;
        for (int i = 0; i < length; ++i) {
            Object value = dataReader.getValueInTimestamp(timestamps[i]);
            if (value == null) continue;
            time = timestamps[i];
            lastVal = value;
        }
        if (time != -1L) {
            this.updateLastResult(time, lastVal);
        }
    }

    @Override
    public boolean isCalculatedAggregationResult() {
        return false;
    }

    private void updateLastResult(long time, Object value) {
        if (!this.resultData.isSetTime()) {
            this.resultData.putTimeAndValue(time, value);
        } else if (time >= this.resultData.getTimestamp()) {
            this.resultData.putTimeAndValue(time, value);
        }
    }
}

