/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.chunkRelated;

import java.util.Iterator;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.query.reader.IReaderByTimestamp;
import org.apache.iotdb.db.utils.TimeValuePair;

public class MemChunkReaderByTimestamp
implements IReaderByTimestamp {
    private Iterator<TimeValuePair> timeValuePairIterator;
    private boolean hasCachedTimeValuePair;
    private TimeValuePair cachedTimeValuePair;

    public MemChunkReaderByTimestamp(ReadOnlyMemChunk readableChunk) {
        this.timeValuePairIterator = readableChunk.getIterator();
    }

    @Override
    public boolean hasNext() {
        if (this.hasCachedTimeValuePair) {
            return true;
        }
        return this.timeValuePairIterator.hasNext();
    }

    private TimeValuePair next() {
        if (this.hasCachedTimeValuePair) {
            this.hasCachedTimeValuePair = false;
            return this.cachedTimeValuePair;
        }
        return this.timeValuePairIterator.next();
    }

    @Override
    public Object getValueInTimestamp(long timestamp) {
        while (this.hasNext()) {
            TimeValuePair timeValuePair = this.next();
            long time = timeValuePair.getTimestamp();
            if (time == timestamp) {
                return timeValuePair.getValue().getValue();
            }
            if (time <= timestamp) continue;
            this.hasCachedTimeValuePair = true;
            this.cachedTimeValuePair = timeValuePair;
            break;
        }
        return null;
    }
}

