/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.timegenerator;

import java.io.IOException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.reader.seriesRelated.SeriesReaderWithValueFilter;
import org.apache.iotdb.db.query.timegenerator.AbstractNodeConstructor;
import org.apache.iotdb.db.query.timegenerator.EngineLeafNode;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.ExpressionType;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.query.timegenerator.node.Node;

public class EngineNodeConstructor
extends AbstractNodeConstructor {
    @Override
    public Node construct(IExpression expression, QueryContext context) throws StorageEngineException {
        if (expression.getType() == ExpressionType.SERIES) {
            try {
                Filter filter = ((SingleSeriesExpression)expression).getFilter();
                Path path = ((SingleSeriesExpression)expression).getSeriesPath();
                return new EngineLeafNode(new SeriesReaderWithValueFilter(path, filter, context));
            }
            catch (IOException e) {
                throw new StorageEngineException(e);
            }
        }
        return this.constructNotSeriesNode(expression, context);
    }
}

