/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.iotdb.db.sync.conf.SyncSenderConfig;
import org.apache.iotdb.db.utils.FilePathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncSenderDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(SyncSenderDescriptor.class);
    private SyncSenderConfig conf = new SyncSenderConfig();

    private SyncSenderDescriptor() {
        this.loadProps();
    }

    public static final SyncSenderDescriptor getInstance() {
        return PostBackDescriptorHolder.INSTANCE;
    }

    public SyncSenderConfig getConfig() {
        return this.conf;
    }

    public void setConfig(SyncSenderConfig conf) {
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadProps() {
        FileInputStream inputStream;
        this.conf.init();
        String url = System.getProperty("IOTDB_CONF", null);
        if (url == null) {
            url = System.getProperty("IOTDB_HOME", null);
            if (url == null) {
                logger.warn("Cannot find IOTDB_HOME or IOTDB_CONF environment variable when loading config file {}, use default configuration", (Object)"iotdb-sync-client.properties");
                return;
            }
            url = url + File.separatorChar + "conf" + File.separatorChar + "iotdb-sync-client.properties";
        } else {
            url = url + File.separatorChar + "iotdb-sync-client.properties";
        }
        try {
            inputStream = new FileInputStream(new File(url));
        }
        catch (FileNotFoundException e) {
            logger.warn("Fail to find sync config file {}", (Object)url, (Object)e);
            return;
        }
        logger.info("Start to read sync config file {}", (Object)url);
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            this.conf.setServerIp(properties.getProperty("server_ip", this.conf.getServerIp()));
            this.conf.setServerPort(Integer.parseInt(properties.getProperty("server_port", Integer.toString(this.conf.getServerPort()))));
            this.conf.setSyncPeriodInSecond(Integer.parseInt(properties.getProperty("sync_period_in_second", Integer.toString(this.conf.getSyncPeriodInSecond()))));
            this.conf.setSchemaPath(properties.getProperty("iotdb_schema_directory", this.conf.getSchemaPath()));
            this.conf.setDataDirectory(properties.getProperty("iotdb_bufferWrite_directory", this.conf.getDataDirectory()));
            String dataDirectory = this.conf.getDataDirectory();
            if (dataDirectory.length() > 0 && dataDirectory.charAt(dataDirectory.length() - 1) != File.separatorChar) {
                dataDirectory = dataDirectory + File.separatorChar;
            }
            this.conf.setUuidPath(dataDirectory + "sync-client" + File.separatorChar + "uuid.txt");
            this.conf.setLastFileInfo(dataDirectory + "sync-client" + File.separatorChar + "last_local_files.txt");
            String[] sequenceFileDirectory = this.conf.getSeqFileDirectory();
            String[] snapshots = new String[this.conf.getSeqFileDirectory().length];
            for (int i = 0; i < this.conf.getSeqFileDirectory().length; ++i) {
                sequenceFileDirectory[i] = FilePathUtils.regularizePath(sequenceFileDirectory[i]);
                snapshots[i] = sequenceFileDirectory[i] + "sync-client" + File.separatorChar + "data-snapshot" + File.separatorChar;
            }
            this.conf.setSeqFileDirectory(sequenceFileDirectory);
            this.conf.setSnapshotPaths(snapshots);
            return;
        }
        catch (IOException e) {
            logger.warn("Cannot load config file because {}, use default configuration", (Throwable)e);
            return;
        }
        catch (Exception e) {
            logger.warn("Error format in config file because {}, use default configuration", (Throwable)e);
            return;
        }
        finally {
            try {
                ((InputStream)inputStream).close();
            }
            catch (IOException e) {
                logger.error("Fail to close sync config file input stream because ", (Throwable)e);
            }
        }
    }

    private static class PostBackDescriptorHolder {
        private static final SyncSenderDescriptor INSTANCE = new SyncSenderDescriptor();

        private PostBackDescriptorHolder() {
        }
    }
}

