/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sync.sender;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.sync.conf.SyncSenderConfig;
import org.apache.iotdb.db.sync.conf.SyncSenderDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncFileManager {
    private static final Logger logger = LoggerFactory.getLogger(SyncFileManager.class);
    private Map<String, Set<String>> validAllFiles = new HashMap<String, Set<String>>();
    private Set<String> lastLocalFiles = new HashSet<String>();
    private Map<String, Set<String>> currentLocalFiles = new HashMap<String, Set<String>>();
    private SyncSenderConfig syncConfig = SyncSenderDescriptor.getInstance().getConfig();
    private IoTDBConfig systemConfig = IoTDBDescriptor.getInstance().getConfig();
    private static final String RESTORE_SUFFIX = ".restore";

    private SyncFileManager() {
    }

    public static final SyncFileManager getInstance() {
        return FileManagerHolder.INSTANCE;
    }

    public void init() throws IOException {
        this.validAllFiles.clear();
        this.lastLocalFiles.clear();
        this.currentLocalFiles.clear();
        this.getLastLocalFileList(this.syncConfig.getLastFileInfo());
        this.getCurrentLocalFileList(this.systemConfig.getDataDirs());
        this.getValidFileList();
    }

    public void getValidFileList() {
        for (Map.Entry<String, Set<String>> entry : this.currentLocalFiles.entrySet()) {
            for (String path : entry.getValue()) {
                if (this.lastLocalFiles.contains(path)) continue;
                this.validAllFiles.get(entry.getKey()).add(path);
            }
        }
        logger.info("Acquire list of valid files.");
        for (Map.Entry<String, Set<String>> entry : this.validAllFiles.entrySet()) {
            for (String path : entry.getValue()) {
                this.currentLocalFiles.get(entry.getKey()).remove(path);
            }
        }
    }

    public void getLastLocalFileList(String path) throws IOException {
        HashSet<String> fileList = new HashSet<String>();
        File file = new File(path);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new IOException("Cannot get last local file list", e);
            }
        }
        try (BufferedReader bf = new BufferedReader(new FileReader(file));){
            String fileName;
            while ((fileName = bf.readLine()) != null) {
                fileList.add(fileName);
            }
        }
        catch (IOException e) {
            logger.error("Cannot get last local file list when reading file {}.", (Object)this.syncConfig.getLastFileInfo());
            throw new IOException(e);
        }
        this.lastLocalFiles = fileList;
    }

    public void getCurrentLocalFileList(String[] paths) {
        for (String path : paths) {
            File[] listFiles;
            if (!new File(path).exists()) continue;
            for (File storageGroup : listFiles = new File(path).listFiles()) {
                if (!storageGroup.isDirectory() || storageGroup.getName().equals("sync-client")) continue;
                this.getStorageGroupFiles(storageGroup);
            }
        }
    }

    private void getStorageGroupFiles(File storageGroup) {
        File[] files;
        if (!this.currentLocalFiles.containsKey(storageGroup.getName())) {
            this.currentLocalFiles.put(storageGroup.getName(), new HashSet());
        }
        if (!this.validAllFiles.containsKey(storageGroup.getName())) {
            this.validAllFiles.put(storageGroup.getName(), new HashSet());
        }
        for (File file : files = storageGroup.listFiles()) {
            if (file.getPath().endsWith(RESTORE_SUFFIX) || new File(file.getPath() + RESTORE_SUFFIX).exists()) continue;
            this.currentLocalFiles.get(storageGroup.getName()).add(file.getPath());
        }
    }

    public void backupNowLocalFileInfo(String backupFile) {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(backupFile));){
            for (Map.Entry<String, Set<String>> entry : this.currentLocalFiles.entrySet()) {
                for (String file : entry.getValue()) {
                    bufferedWriter.write(file + "\n");
                }
            }
        }
        catch (IOException e) {
            logger.error("Cannot back up current local file info", (Throwable)e);
        }
    }

    public Map<String, Set<String>> getValidAllFiles() {
        return this.validAllFiles;
    }

    public Set<String> getLastLocalFiles() {
        return this.lastLocalFiles;
    }

    public Map<String, Set<String>> getCurrentLocalFiles() {
        return this.currentLocalFiles;
    }

    public void setCurrentLocalFiles(Map<String, Set<String>> newNowLocalFiles) {
        this.currentLocalFiles = newNowLocalFiles;
    }

    private static class FileManagerHolder {
        private static final SyncFileManager INSTANCE = new SyncFileManager();

        private FileManagerHolder() {
        }
    }
}

