/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.List;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.tsfile.write.schema.FileSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class FileSchemaUtils {
    private FileSchemaUtils() {
    }

    public static FileSchema constructFileSchema(String processorName) {
        List<MeasurementSchema> columnSchemaList = MManager.getInstance().getSchemaForStorageGroup(processorName);
        return FileSchemaUtils.getFileSchemaFromColumnSchema(columnSchemaList);
    }

    public static FileSchema getFileSchemaFromColumnSchema(List<MeasurementSchema> schemaList) {
        FileSchema schema = new FileSchema();
        for (MeasurementSchema measurementSchema : schemaList) {
            schema.registerMeasurement(measurementSchema);
        }
        return schema;
    }
}

