/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.writelog.recover;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.version.VersionController;
import org.apache.iotdb.db.exception.ProcessorException;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.UpdatePlan;
import org.apache.iotdb.db.writelog.io.ILogReader;
import org.apache.iotdb.db.writelog.manager.MultiFileLogNodeManager;
import org.apache.iotdb.db.writelog.node.WriteLogNode;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.schema.FileSchema;

public class LogReplayer {
    private String logNodePrefix;
    private String insertFilePath;
    private ModificationFile modFile;
    private VersionController versionController;
    private TsFileResource currentTsFileResource;
    private FileSchema fileSchema;
    private IMemTable recoverMemTable;
    private boolean acceptDuplication;
    private Map<String, Long> tempStartTimeMap = new HashMap<String, Long>();
    private Map<String, Long> tempEndTimeMap = new HashMap<String, Long>();

    public LogReplayer(String logNodePrefix, String insertFilePath, ModificationFile modFile, VersionController versionController, TsFileResource currentTsFileResource, FileSchema fileSchema, IMemTable memTable, boolean acceptDuplication) {
        this.logNodePrefix = logNodePrefix;
        this.insertFilePath = insertFilePath;
        this.modFile = modFile;
        this.versionController = versionController;
        this.currentTsFileResource = currentTsFileResource;
        this.fileSchema = fileSchema;
        this.recoverMemTable = memTable;
        this.acceptDuplication = acceptDuplication;
    }

    public void replayLogs() throws ProcessorException {
        WriteLogNode logNode = MultiFileLogNodeManager.getInstance().getNode(this.logNodePrefix + new File(this.insertFilePath).getName());
        try (ILogReader logReader = logNode.getLogReader();){
            while (logReader.hasNext()) {
                PhysicalPlan plan = logReader.next();
                if (plan instanceof InsertPlan) {
                    this.replayInsert((InsertPlan)plan);
                    continue;
                }
                if (plan instanceof DeletePlan) {
                    this.replayDelete((DeletePlan)plan);
                    continue;
                }
                if (!(plan instanceof UpdatePlan)) continue;
                this.replayUpdate((UpdatePlan)plan);
            }
        }
        this.tempStartTimeMap.forEach((k, v) -> this.currentTsFileResource.updateStartTime((String)k, (long)v));
        this.tempEndTimeMap.forEach((k, v) -> this.currentTsFileResource.updateEndTime((String)k, (long)v));
    }

    private void replayDelete(DeletePlan deletePlan) throws IOException {
        List<Path> paths = deletePlan.getPaths();
        for (Path path : paths) {
            this.recoverMemTable.delete(path.getDevice(), path.getMeasurement(), deletePlan.getDeleteTime());
            this.modFile.write(new Deletion(path, this.versionController.nextVersion(), deletePlan.getDeleteTime()));
        }
    }

    private void replayInsert(InsertPlan insertPlan) {
        if (this.currentTsFileResource != null) {
            Long lastEndTime = this.currentTsFileResource.getEndTimeMap().get(insertPlan.getDeviceId());
            if (lastEndTime != null && lastEndTime >= insertPlan.getTime() && !this.acceptDuplication) {
                return;
            }
            this.tempStartTimeMap.putIfAbsent(insertPlan.getDeviceId(), insertPlan.getTime());
            Long endTime = this.tempEndTimeMap.get(insertPlan.getDeviceId());
            if (endTime == null || endTime < insertPlan.getTime()) {
                this.tempEndTimeMap.put(insertPlan.getDeviceId(), insertPlan.getTime());
            }
        }
        String[] measurementList = insertPlan.getMeasurements();
        TSDataType[] dataTypes = new TSDataType[measurementList.length];
        for (int i = 0; i < measurementList.length; ++i) {
            dataTypes[i] = this.fileSchema.getMeasurementDataType(measurementList[i]);
        }
        insertPlan.setDataTypes(dataTypes);
        this.recoverMemTable.insert(insertPlan);
    }

    private void replayUpdate(UpdatePlan updatePlan) {
        throw new UnsupportedOperationException("Update not supported");
    }
}

