/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth.authorizer;

import java.io.File;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.auth.authorizer.BasicAuthorizer;
import org.apache.iotdb.db.auth.role.LocalFileRoleManager;
import org.apache.iotdb.db.auth.user.LocalFileUserManager;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileAuthorizer
extends BasicAuthorizer {
    private static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static Logger logger = LoggerFactory.getLogger(LocalFileAuthorizer.class);

    private LocalFileAuthorizer() throws AuthException {
        super(new LocalFileUserManager(config.getSystemDir() + File.separator + "users"), new LocalFileRoleManager(config.getSystemDir() + File.separator + "roles"));
    }

    public static LocalFileAuthorizer getInstance() throws AuthException {
        if (InstanceHolder.instance == null) {
            throw new AuthException("Authorizer uninitialized");
        }
        return InstanceHolder.instance;
    }

    private static class InstanceHolder {
        private static LocalFileAuthorizer instance;

        private InstanceHolder() {
        }

        static {
            try {
                instance = new LocalFileAuthorizer();
            }
            catch (AuthException e) {
                logger.error("Authorizer initialization failed due to ", (Throwable)e);
                instance = null;
            }
        }
    }
}

