/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf.directories;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.directories.strategy.DirectoryStrategy;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryManager {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryManager.class);
    private List<String> sequenceFileFolders = new ArrayList<String>(Arrays.asList(IoTDBDescriptor.getInstance().getConfig().getDataDirs()));
    private List<String> unsequenceFileFolders;
    private DirectoryStrategy sequenceStrategy;
    private DirectoryStrategy unsequenceStrategy;

    private DirectoryManager() {
        int i;
        for (i = 0; i < this.sequenceFileFolders.size(); ++i) {
            this.sequenceFileFolders.set(i, this.sequenceFileFolders.get(i) + File.separator + "sequence");
        }
        this.mkDirs(this.sequenceFileFolders);
        this.unsequenceFileFolders = new ArrayList<String>(Arrays.asList(IoTDBDescriptor.getInstance().getConfig().getDataDirs()));
        for (i = 0; i < this.unsequenceFileFolders.size(); ++i) {
            this.unsequenceFileFolders.set(i, this.unsequenceFileFolders.get(i) + File.separator + "unsequence");
        }
        this.mkDirs(this.unsequenceFileFolders);
        String strategyName = "";
        try {
            strategyName = IoTDBDescriptor.getInstance().getConfig().getMultiDirStrategyClassName();
            Class<?> clazz = Class.forName(strategyName);
            this.sequenceStrategy = (DirectoryStrategy)clazz.newInstance();
            this.sequenceStrategy.init(this.sequenceFileFolders);
            this.unsequenceStrategy = (DirectoryStrategy)clazz.newInstance();
            this.unsequenceStrategy.init(this.unsequenceFileFolders);
        }
        catch (Exception e) {
            logger.error("can't find sequenceStrategy {} for mult-directories.", (Object)strategyName, (Object)e);
        }
    }

    public static DirectoryManager getInstance() {
        return DirectoriesHolder.INSTANCE;
    }

    private void mkDirs(List<String> folders) {
        for (String folder : folders) {
            File file = new File(folder);
            if (file.mkdirs()) {
                logger.info("folder {} doesn't exist, create it", (Object)file.getPath());
                continue;
            }
            logger.info("create folder {} failed. Is the folder existed: {}", (Object)file.getPath(), (Object)file.exists());
        }
    }

    public String getSequenceFolderForTest() {
        return this.sequenceFileFolders.get(0);
    }

    public void setSequenceFolderForTest(String path) {
        this.sequenceFileFolders.set(0, path);
    }

    public String getNextFolderForSequenceFile() throws DiskSpaceInsufficientException {
        return this.getSequenceFileFolder(this.getNextFolderIndexForSequenceFile());
    }

    public int getNextFolderIndexForSequenceFile() throws DiskSpaceInsufficientException {
        return this.sequenceStrategy.nextFolderIndex();
    }

    public String getSequenceFileFolder(int index) {
        return this.sequenceFileFolders.get(index);
    }

    public int getSequenceFileFolderIndex(String folder) {
        return this.sequenceFileFolders.indexOf(folder);
    }

    public List<String> getAllSequenceFileFolders() {
        return new ArrayList<String>(this.sequenceFileFolders);
    }

    public String getWALFolder() {
        return IoTDBDescriptor.getInstance().getConfig().getWalFolder();
    }

    public String getNextFolderForUnSequenceFile() throws DiskSpaceInsufficientException {
        return this.getUnSequenceFileFolder(this.getNextFolderIndexForUnSequenceFile());
    }

    public int getNextFolderIndexForUnSequenceFile() throws DiskSpaceInsufficientException {
        return this.unsequenceStrategy.nextFolderIndex();
    }

    public String getUnSequenceFileFolder(int index) {
        return this.unsequenceFileFolders.get(index);
    }

    public int getUnSequenceFileFolderIndex(String folder) {
        return this.unsequenceFileFolders.indexOf(folder);
    }

    public List<String> getAllUnSequenceFileFolders() {
        return new ArrayList<String>(this.unsequenceFileFolders);
    }

    public String getUnSequenceFolderForTest() {
        return this.unsequenceFileFolders.get(0);
    }

    private static class DirectoriesHolder {
        private static final DirectoryManager INSTANCE = new DirectoryManager();

        private DirectoriesHolder() {
        }
    }
}

