/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.querycontext;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.engine.memtable.MemSeriesLazyMerger;
import org.apache.iotdb.db.engine.memtable.TimeValuePairSorter;
import org.apache.iotdb.db.utils.MathUtils;
import org.apache.iotdb.db.utils.TimeValuePair;
import org.apache.iotdb.db.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class ReadOnlyMemChunk
implements TimeValuePairSorter {
    private boolean initialized;
    private TSDataType dataType;
    private TimeValuePairSorter memSeries;
    private List<TimeValuePair> sortedTimeValuePairList;
    Map<String, String> props;
    private int floatPrecision = TSFileConfig.floatPrecision;

    public ReadOnlyMemChunk(TSDataType dataType, TimeValuePairSorter memSeries, Map<String, String> props) {
        this.dataType = dataType;
        this.memSeries = memSeries;
        this.initialized = false;
        this.props = props;
        if (props.containsKey("max_point_number")) {
            this.floatPrecision = Integer.parseInt(props.get("max_point_number"));
        }
    }

    private void checkInitialized() {
        if (!this.initialized) {
            this.init();
        }
    }

    private void init() {
        this.sortedTimeValuePairList = this.memSeries.getSortedTimeValuePairList();
        if (!(this.memSeries instanceof MemSeriesLazyMerger)) {
            switch (this.dataType) {
                case FLOAT: {
                    this.sortedTimeValuePairList.replaceAll(x -> new TimeValuePair(x.getTimestamp(), new TsPrimitiveType.TsFloat(MathUtils.roundWithGivenPrecision(x.getValue().getFloat(), this.floatPrecision))));
                    break;
                }
                case DOUBLE: {
                    this.sortedTimeValuePairList.replaceAll(x -> new TimeValuePair(x.getTimestamp(), new TsPrimitiveType.TsDouble(MathUtils.roundWithGivenPrecision(x.getValue().getDouble(), this.floatPrecision))));
                    break;
                }
            }
        }
        this.memSeries = null;
        this.initialized = true;
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    @Override
    public List<TimeValuePair> getSortedTimeValuePairList() {
        this.checkInitialized();
        return Collections.unmodifiableList(this.sortedTimeValuePairList);
    }

    @Override
    public Iterator<TimeValuePair> getIterator() {
        this.checkInitialized();
        return this.sortedTimeValuePairList.iterator();
    }

    @Override
    public boolean isEmpty() {
        this.checkInitialized();
        return this.sortedTimeValuePairList.isEmpty();
    }
}

