/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.iotdb.db.engine.pool.FlushPoolManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlushManager {
    private static final Logger logger = LoggerFactory.getLogger(FlushManager.class);
    private ConcurrentLinkedDeque<TsFileProcessor> tsFileProcessorQueue = new ConcurrentLinkedDeque();
    private FlushPoolManager flushPool = FlushPoolManager.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerTsFileProcessor(TsFileProcessor tsFileProcessor) {
        TsFileProcessor tsFileProcessor2 = tsFileProcessor;
        synchronized (tsFileProcessor2) {
            if (!tsFileProcessor.isManagedByFlushManager() && tsFileProcessor.getFlushingMemTableSize() > 0) {
                logger.info("storage group {} begin to submit a flush thread, flushing memtable size: {}", (Object)tsFileProcessor.getStorageGroupName(), (Object)tsFileProcessor.getFlushingMemTableSize());
                this.tsFileProcessorQueue.add(tsFileProcessor);
                tsFileProcessor.setManagedByFlushManager(true);
                this.flushPool.submit(new FlushThread());
            }
        }
    }

    private FlushManager() {
    }

    public static FlushManager getInstance() {
        return InstanceHolder.instance;
    }

    private static class InstanceHolder {
        private static FlushManager instance = new FlushManager();

        private InstanceHolder() {
        }
    }

    class FlushThread
    implements Runnable {
        FlushThread() {
        }

        @Override
        public void run() {
            TsFileProcessor tsFileProcessor = (TsFileProcessor)FlushManager.this.tsFileProcessorQueue.poll();
            tsFileProcessor.flushOneMemTable();
            tsFileProcessor.setManagedByFlushManager(false);
            FlushManager.this.registerTsFileProcessor(tsFileProcessor);
        }
    }
}

