/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp;

import java.time.ZoneId;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.ArgsErrorException;
import org.apache.iotdb.db.exception.MetadataErrorException;
import org.apache.iotdb.db.exception.qp.IllegalASTFormatException;
import org.apache.iotdb.db.exception.qp.LogicalOperatorException;
import org.apache.iotdb.db.exception.qp.QueryProcessorException;
import org.apache.iotdb.db.qp.executor.IQueryProcessExecutor;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.RootOperator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.SFWOperator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.strategy.LogicalGenerator;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;
import org.apache.iotdb.db.qp.strategy.optimizer.ConcatPathOptimizer;
import org.apache.iotdb.db.qp.strategy.optimizer.DnfFilterOptimizer;
import org.apache.iotdb.db.qp.strategy.optimizer.MergeSingleFilterOptimizer;
import org.apache.iotdb.db.qp.strategy.optimizer.RemoveNotOptimizer;
import org.apache.iotdb.db.sql.ParseGenerator;
import org.apache.iotdb.db.sql.parse.AstNode;
import org.apache.iotdb.db.sql.parse.ParseException;
import org.apache.iotdb.db.sql.parse.ParseUtils;

public class QueryProcessor {
    private IQueryProcessExecutor executor;

    public QueryProcessor(IQueryProcessExecutor executor) {
        this.executor = executor;
    }

    public IQueryProcessExecutor getExecutor() {
        return this.executor;
    }

    public PhysicalPlan parseSQLToPhysicalPlan(String sqlStr) throws QueryProcessorException, ArgsErrorException, MetadataErrorException {
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        return this.parseSQLToPhysicalPlan(sqlStr, config.getZoneID());
    }

    public PhysicalPlan parseSQLToPhysicalPlan(String sqlStr, ZoneId zoneId) throws QueryProcessorException, ArgsErrorException, MetadataErrorException {
        AstNode astNode = this.parseSQLToAST(sqlStr);
        Operator operator = this.parseASTToOperator(astNode, zoneId);
        operator = this.logicalOptimize(operator, this.executor);
        PhysicalGenerator physicalGenerator = new PhysicalGenerator(this.executor);
        PhysicalPlan qp = physicalGenerator.transformToPhysicalPlan(operator);
        return qp;
    }

    private RootOperator parseASTToOperator(AstNode astNode, ZoneId zoneId) throws QueryProcessorException, ArgsErrorException, MetadataErrorException {
        LogicalGenerator generator = new LogicalGenerator(zoneId);
        return generator.getLogicalPlan(astNode);
    }

    private AstNode parseSQLToAST(String sqlStr) throws IllegalASTFormatException {
        AstNode astTree;
        try {
            astTree = ParseGenerator.generateAST(sqlStr);
        }
        catch (ParseException e) {
            throw new IllegalASTFormatException("parsing error,statement: " + sqlStr, e);
        }
        return ParseUtils.findRootNonNullToken(astTree);
    }

    private Operator logicalOptimize(Operator operator, IQueryProcessExecutor executor) throws LogicalOperatorException {
        switch (operator.getType()) {
            case AUTHOR: 
            case METADATA: 
            case SET_STORAGE_GROUP: 
            case CREATE_TIMESERIES: 
            case DELETE_TIMESERIES: 
            case PROPERTY: 
            case LOADDATA: 
            case INSERT: 
            case INDEX: 
            case INDEXQUERY: {
                return operator;
            }
            case QUERY: 
            case UPDATE: 
            case DELETE: {
                SFWOperator root = (SFWOperator)operator;
                return this.optimizeSFWOperator(root, executor);
            }
        }
        throw new LogicalOperatorException("unknown operator type:" + (Object)((Object)operator.getType()));
    }

    private SFWOperator optimizeSFWOperator(SFWOperator root, IQueryProcessExecutor executor) throws LogicalOperatorException {
        ConcatPathOptimizer concatPathOptimizer = new ConcatPathOptimizer(executor);
        FilterOperator filter = (root = (SFWOperator)concatPathOptimizer.transform(root)).getFilterOperator();
        if (filter == null) {
            return root;
        }
        RemoveNotOptimizer removeNot = new RemoveNotOptimizer();
        filter = removeNot.optimize(filter);
        DnfFilterOptimizer dnf = new DnfFilterOptimizer();
        filter = dnf.optimize(filter);
        MergeSingleFilterOptimizer merge = new MergeSingleFilterOptimizer();
        filter = merge.optimize(filter);
        root.setFilterOperator(filter);
        return root;
    }
}

