/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.constant;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.tsfile.read.common.Path;

public class SQLConstant {
    public static final String RESERVED_TIME = "time";
    public static final String RESERVED_FREQ = "freq";
    public static final String IS_AGGREGATION = "IS_AGGREGATION";
    public static final String NOW_FUNC = "now";
    public static final String START_TIME_STR = "1970-1-01T00:00:00";
    public static final String LINE_FEED_SIGNAL = "\n";
    public static final String ROOT = "root";
    public static final String METADATA_PARAM_EQUAL = "=";
    public static final String QUOTE = "'";
    public static final String DQUOTE = "\"";
    public static final String BOOLEN_TRUE = "true";
    public static final String BOOLEN_FALSE = "false";
    public static final String BOOLEAN_TRUE_NUM = "1";
    public static final String BOOLEAN_FALSE_NUM = "0";
    public static final int KW_AND = 1;
    public static final int KW_OR = 2;
    public static final int KW_NOT = 3;
    public static final int EQUAL = 11;
    public static final int NOTEQUAL = 12;
    public static final int LESSTHANOREQUALTO = 13;
    public static final int LESSTHAN = 14;
    public static final int GREATERTHANOREQUALTO = 15;
    public static final int GREATERTHAN = 16;
    public static final int EQUAL_NS = 17;
    public static final int TOK_SELECT = 21;
    public static final int TOK_FROM = 22;
    public static final int TOK_WHERE = 23;
    public static final int TOK_INSERT = 24;
    public static final int TOK_DELETE = 25;
    public static final int TOK_UPDATE = 26;
    public static final int TOK_QUERY = 27;
    public static final int TOK_CREATE_INDEX = 31;
    public static final int TOK_DROP_INDEX = 32;
    public static final int TOK_QUERY_INDEX = 33;
    public static final int TOK_AUTHOR_CREATE = 41;
    public static final int TOK_AUTHOR_DROP = 42;
    public static final int TOK_AUTHOR_GRANT = 43;
    public static final int TOK_AUTHOR_REVOKE = 44;
    public static final int TOK_AUTHOR_UPDATE_USER = 46;
    public static final int TOK_DATALOAD = 45;
    public static final int TOK_METADATA_CREATE = 51;
    public static final int TOK_METADATA_DELETE = 52;
    public static final int TOK_METADATA_SET_FILE_LEVEL = 53;
    public static final int TOK_PROPERTY_CREATE = 54;
    public static final int TOK_PROPERTY_ADD_LABEL = 55;
    public static final int TOK_PROPERTY_DELETE_LABEL = 56;
    public static final int TOK_PROPERTY_LINK = 57;
    public static final int TOK_PROPERTY_UNLINK = 58;
    public static final int TOK_LIST = 59;
    public static final Map<Integer, String> tokenSymbol = new HashMap<Integer, String>();
    public static final Map<Integer, String> tokenNames = new HashMap<Integer, String>();
    public static final Map<Integer, Integer> reverseWords = new HashMap<Integer, Integer>();

    private SQLConstant() {
    }

    public static boolean isReservedPath(Path pathStr) {
        return pathStr.equals(RESERVED_TIME) || pathStr.equals(RESERVED_FREQ);
    }

    static {
        tokenSymbol.put(1, "&");
        tokenSymbol.put(2, "|");
        tokenSymbol.put(3, "!");
        tokenSymbol.put(11, METADATA_PARAM_EQUAL);
        tokenSymbol.put(12, "<>");
        tokenSymbol.put(17, "<=>");
        tokenSymbol.put(13, "<=");
        tokenSymbol.put(14, "<");
        tokenSymbol.put(15, ">=");
        tokenSymbol.put(16, ">");
        tokenNames.put(1, "and");
        tokenNames.put(2, "or");
        tokenNames.put(3, "not");
        tokenNames.put(11, "equal");
        tokenNames.put(12, "not_equal");
        tokenNames.put(17, "equal_ns");
        tokenNames.put(13, "lessthan_or_equalto");
        tokenNames.put(14, "lessthan");
        tokenNames.put(15, "greaterthan_or_equalto");
        tokenNames.put(16, "greaterthan");
        tokenNames.put(21, "TOK_SELECT");
        tokenNames.put(22, "TOK_FROM");
        tokenNames.put(23, "TOK_WHERE");
        tokenNames.put(24, "TOK_INSERT");
        tokenNames.put(25, "TOK_DELETE");
        tokenNames.put(26, "TOK_UPDATE");
        tokenNames.put(27, "TOK_QUERY");
        tokenNames.put(41, "TOK_AUTHOR_CREATE");
        tokenNames.put(42, "TOK_AUTHOR_DROP");
        tokenNames.put(43, "TOK_AUTHOR_GRANT");
        tokenNames.put(44, "TOK_AUTHOR_REVOKE");
        tokenNames.put(46, "TOK_AUTHOR_UPDATE_USER");
        tokenNames.put(45, "TOK_DATALOAD");
        tokenNames.put(51, "TOK_METADATA_CREATE");
        tokenNames.put(52, "TOK_METADATA_DELETE");
        tokenNames.put(53, "TOK_METADATA_SET_FILE_LEVEL");
        tokenNames.put(54, "TOK_PROPERTY_CREATE");
        tokenNames.put(55, "TOK_PROPERTY_ADD_LABEL");
        tokenNames.put(56, "TOK_PROPERTY_DELETE_LABEL");
        tokenNames.put(57, "TOK_PROPERTY_LINK");
        tokenNames.put(58, "TOK_PROPERTY_UNLINK");
        tokenNames.put(59, "TOK_LIST");
        reverseWords.put(1, 2);
        reverseWords.put(2, 1);
        reverseWords.put(11, 12);
        reverseWords.put(12, 11);
        reverseWords.put(14, 15);
        reverseWords.put(15, 14);
        reverseWords.put(13, 16);
        reverseWords.put(16, 13);
    }
}

