/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.MemEst;

import io.airlift.airline.Command;
import io.airlift.airline.Option;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.adapter.IoTDBConfigDynamicAdapter;
import org.apache.iotdb.db.exception.ConfigAdjusterException;
import org.apache.iotdb.db.metadata.MManager;

@Command(name="calmem", description="calculate minimum memory required for writing based on the number of storage groups and timeseries")
public class MemEstToolCmd
implements Runnable {
    @Option(title="storage group number", name={"-sg", "--storagegroup"}, description="Storage group number")
    private String sgNumString = "10";
    @Option(title="total timeseries number", name={"-ts", "--timeseries"}, description="Total timeseries number")
    private String tsNumString = "1000";
    @Option(title="max timeseries", name={"-mts", "--maxtimeseries"}, description="Maximum timeseries number among storage groups, make sure that it's smaller than total timeseries number")
    private String maxTsNumString = "0";

    @Override
    public void run() {
        long maxTsNum;
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        long memTableSize = config.getMemtableSizeThreshold();
        int maxMemtableNumber = config.getMaxMemtableNumber();
        long tsFileSize = config.getTsFileSizeThreshold();
        long memory = 0x40000000L;
        long sgNum = Long.parseLong(this.sgNumString);
        long tsNum = Long.parseLong(this.tsNumString);
        long maxTsNumValid = maxTsNum = Long.parseLong(this.maxTsNumString);
        long maxProcess = 0L;
        while (true) {
            long sgCnt;
            config.setAllocateMemoryForWrite(memory);
            config.setMemtableSizeThreshold(memTableSize);
            config.setMaxMemtableNumber(maxMemtableNumber);
            config.setTsFileSizeThreshold(tsFileSize);
            IoTDBConfigDynamicAdapter.getInstance().reset();
            IoTDBConfigDynamicAdapter.getInstance().setInitialized(true);
            MManager.getInstance().clear();
            long tsCnt = 1L;
            try {
                for (sgCnt = 1L; sgCnt <= sgNum; ++sgCnt) {
                    IoTDBConfigDynamicAdapter.getInstance().addOrDeleteStorageGroup(1);
                }
                while (tsCnt <= tsNum) {
                    IoTDBConfigDynamicAdapter.getInstance().addOrDeleteTimeSeries(1);
                    if (maxTsNum == 0L) {
                        maxTsNumValid = tsCnt / sgNum + 1L;
                    } else {
                        maxTsNumValid = Math.min(tsCnt, maxTsNum);
                        maxTsNumValid = Math.max(maxTsNumValid, tsCnt / sgNum + 1L);
                    }
                    MManager.getInstance().setMaxSeriesNumberAmongStorageGroup(maxTsNumValid);
                    ++tsCnt;
                }
            }
            catch (ConfigAdjusterException e) {
                if (sgCnt > sgNum) {
                    maxProcess = Math.max(maxProcess, tsCnt * 100L / tsNum);
                    System.out.print(String.format("Memory estimation progress : %d%%\r", maxProcess));
                }
                memory += 0x40000000L;
                continue;
            }
            break;
        }
        System.out.println(String.format("Memory for writing: %dGB, SG: %d, TS: %d, MTS: %d", memory / 0x40000000L, sgNum, tsNum, maxTsNumValid));
    }
}

