/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.merge.task;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.engine.cache.DeviceMetaDataCache;
import org.apache.iotdb.db.engine.cache.TsFileMetaDataCache;
import org.apache.iotdb.db.engine.merge.manage.MergeContext;
import org.apache.iotdb.db.engine.merge.manage.MergeResource;
import org.apache.iotdb.db.engine.merge.recover.MergeLogger;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.tsfile.exception.write.TsFileNotCompleteException;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetaData;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.schema.Schema;
import org.apache.iotdb.tsfile.write.writer.ForceAppendTsFileWriter;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MergeFileTask {
    private static final Logger logger = LoggerFactory.getLogger(MergeFileTask.class);
    private String taskName;
    private MergeContext context;
    private MergeLogger mergeLogger;
    private MergeResource resource;
    private List<TsFileResource> unmergedFiles;

    MergeFileTask(String taskName, MergeContext context, MergeLogger mergeLogger, MergeResource resource, List<TsFileResource> unmergedSeqFiles) {
        this.taskName = taskName;
        this.context = context;
        this.mergeLogger = mergeLogger;
        this.resource = resource;
        this.unmergedFiles = unmergedSeqFiles;
    }

    void mergeFiles() throws IOException {
        if (logger.isInfoEnabled()) {
            logger.info("{} starts to merge {} files", (Object)this.taskName, (Object)this.unmergedFiles.size());
        }
        long startTime = System.currentTimeMillis();
        int cnt = 0;
        for (TsFileResource seqFile : this.unmergedFiles) {
            int unmergedChunkNum;
            int mergedChunkNum = this.context.getMergedChunkCnt().getOrDefault(seqFile, 0);
            if (mergedChunkNum >= (unmergedChunkNum = this.context.getUnmergedChunkCnt().getOrDefault(seqFile, 0).intValue())) {
                if (logger.isInfoEnabled()) {
                    logger.info("{} moving unmerged data of {} to the merged file, {} merged chunks, {} unmerged chunks", new Object[]{this.taskName, seqFile.getFile().getName(), mergedChunkNum, unmergedChunkNum});
                }
                this.moveUnmergedToNew(seqFile);
            } else {
                if (logger.isInfoEnabled()) {
                    logger.info("{} moving merged data of {} to the old file {} merged chunks, {} unmerged chunks", new Object[]{this.taskName, seqFile.getFile().getName(), mergedChunkNum, unmergedChunkNum});
                }
                this.moveMergedToOld(seqFile);
            }
            ++cnt;
            if (!logger.isInfoEnabled()) continue;
            logger.debug("{} has merged {}/{} files", new Object[]{this.taskName, cnt, this.unmergedFiles.size()});
        }
        if (logger.isInfoEnabled()) {
            logger.info("{} has merged all files after {}ms", (Object)this.taskName, (Object)(System.currentTimeMillis() - startTime));
        }
        this.mergeLogger.logMergeEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveMergedToOld(TsFileResource seqFile) throws IOException {
        int mergedChunkNum = this.context.getMergedChunkCnt().getOrDefault(seqFile, 0);
        if (mergedChunkNum == 0) {
            this.resource.removeFileAndWriter(seqFile);
            return;
        }
        seqFile.getWriteQueryLock().writeLock().lock();
        try {
            ForceAppendTsFileWriter oldFileWriter;
            TsFileMetaDataCache.getInstance().remove(seqFile);
            DeviceMetaDataCache.getInstance().remove(seqFile);
            FileReaderManager.getInstance().closeFileAndRemoveReader(seqFile);
            this.resource.removeFileReader(seqFile);
            try {
                oldFileWriter = new ForceAppendTsFileWriter(seqFile.getFile());
                this.mergeLogger.logFileMergeStart(seqFile.getFile(), oldFileWriter.getTruncatePosition());
                logger.debug("{} moving merged chunks of {} to the old file", (Object)this.taskName, (Object)seqFile);
                oldFileWriter.doTruncate();
            }
            catch (TsFileNotCompleteException e) {
                oldFileWriter = new RestorableTsFileIOWriter(seqFile.getFile());
            }
            oldFileWriter.filterChunks(this.context.getUnmergedChunkStartTimes().get(seqFile));
            RestorableTsFileIOWriter newFileWriter = this.resource.getMergeFileWriter(seqFile);
            newFileWriter.close();
            try (TsFileSequenceReader newFileReader = new TsFileSequenceReader(newFileWriter.getFile().getPath());){
                List chunkGroupMetadataList = newFileWriter.getChunkGroupMetaDatas();
                if (logger.isDebugEnabled()) {
                    logger.debug("{} find {} merged chunk groups", (Object)this.taskName, (Object)chunkGroupMetadataList.size());
                }
                for (ChunkGroupMetaData chunkGroupMetaData : chunkGroupMetadataList) {
                    this.writeMergedChunkGroup(chunkGroupMetaData, newFileReader, (TsFileIOWriter)oldFileWriter);
                }
            }
            oldFileWriter.endFile(new Schema(newFileWriter.getKnownSchema()));
            seqFile.serialize();
            this.mergeLogger.logFileMergeEnd();
            logger.debug("{} moved merged chunks of {} to the old file", (Object)this.taskName, (Object)seqFile);
            newFileWriter.getFile().delete();
            File nextMergeVersionFile = this.getNextMergeVersionFile(seqFile.getFile());
            FileUtils.moveFile((File)seqFile.getFile(), (File)nextMergeVersionFile);
            FileUtils.moveFile((File)new File(seqFile.getFile().getAbsolutePath() + ".resource"), (File)new File(nextMergeVersionFile.getAbsolutePath() + ".resource"));
            seqFile.setFile(nextMergeVersionFile);
        }
        finally {
            seqFile.getWriteQueryLock().writeLock().unlock();
        }
    }

    private void writeMergedChunkGroup(ChunkGroupMetaData chunkGroupMetaData, TsFileSequenceReader reader, TsFileIOWriter fileWriter) throws IOException {
        fileWriter.startChunkGroup(chunkGroupMetaData.getDeviceID());
        long version = chunkGroupMetaData.getVersion();
        for (ChunkMetaData chunkMetaData : chunkGroupMetaData.getChunkMetaDataList()) {
            Chunk chunk = reader.readMemChunk(chunkMetaData);
            fileWriter.writeChunk(chunk, chunkMetaData);
            this.context.incTotalPointWritten(chunkMetaData.getNumOfPoints());
        }
        fileWriter.endChunkGroup(version + 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveUnmergedToNew(TsFileResource seqFile) throws IOException {
        Map<Path, List<Long>> fileUnmergedChunkStartTimes = this.context.getUnmergedChunkStartTimes().get(seqFile);
        RestorableTsFileIOWriter fileWriter = this.resource.getMergeFileWriter(seqFile);
        this.mergeLogger.logFileMergeStart(fileWriter.getFile(), fileWriter.getFile().length());
        logger.debug("{} moving unmerged chunks of {} to the new file", (Object)this.taskName, (Object)seqFile);
        int unmergedChunkNum = this.context.getUnmergedChunkCnt().getOrDefault(seqFile, 0);
        if (unmergedChunkNum > 0) {
            for (Map.Entry<Path, List<Long>> entry : fileUnmergedChunkStartTimes.entrySet()) {
                Path path = entry.getKey();
                List<Long> chunkStartTimes = entry.getValue();
                if (chunkStartTimes.isEmpty()) continue;
                List<ChunkMetaData> chunkMetaDataList = this.resource.queryChunkMetadata(path, seqFile);
                if (logger.isDebugEnabled()) {
                    logger.debug("{} find {} unmerged chunks", (Object)this.taskName, (Object)chunkMetaDataList.size());
                }
                fileWriter.startChunkGroup(path.getDevice());
                long maxVersion = this.writeUnmergedChunks(chunkStartTimes, chunkMetaDataList, this.resource.getFileReader(seqFile), fileWriter);
                fileWriter.endChunkGroup(maxVersion + 1L);
            }
        }
        fileWriter.endFile(new Schema(fileWriter.getKnownSchema()));
        seqFile.serialize();
        this.mergeLogger.logFileMergeEnd();
        logger.debug("{} moved unmerged chunks of {} to the new file", (Object)this.taskName, (Object)seqFile);
        seqFile.getWriteQueryLock().writeLock().lock();
        try {
            this.resource.removeFileReader(seqFile);
            TsFileMetaDataCache.getInstance().remove(seqFile);
            DeviceMetaDataCache.getInstance().remove(seqFile);
            FileReaderManager.getInstance().closeFileAndRemoveReader(seqFile);
            seqFile.getFile().delete();
            File nextMergeVersionFile = this.getNextMergeVersionFile(seqFile.getFile());
            FileUtils.moveFile((File)fileWriter.getFile(), (File)nextMergeVersionFile);
            FileUtils.moveFile((File)new File(seqFile.getFile().getAbsolutePath() + ".resource"), (File)new File(nextMergeVersionFile.getAbsolutePath() + ".resource"));
            seqFile.setFile(nextMergeVersionFile);
        }
        finally {
            seqFile.getWriteQueryLock().writeLock().unlock();
        }
    }

    private File getNextMergeVersionFile(File seqFile) {
        String[] splits = seqFile.getName().replace(".tsfile", "").split("-");
        int mergeVersion = Integer.parseInt(splits[2]) + 1;
        return new File(seqFile.getParentFile(), splits[0] + "-" + splits[1] + "-" + mergeVersion + ".tsfile");
    }

    private long writeUnmergedChunks(List<Long> chunkStartTimes, List<ChunkMetaData> chunkMetaDataList, TsFileSequenceReader reader, RestorableTsFileIOWriter fileWriter) throws IOException {
        long maxVersion = 0L;
        int chunkIdx = 0;
        block0: for (Long startTime : chunkStartTimes) {
            while (chunkIdx < chunkMetaDataList.size()) {
                ChunkMetaData metaData = chunkMetaDataList.get(chunkIdx);
                if (metaData.getStartTime() == startTime.longValue()) {
                    Chunk chunk = reader.readMemChunk(metaData);
                    fileWriter.writeChunk(chunk, metaData);
                    maxVersion = metaData.getVersion() > maxVersion ? metaData.getVersion() : maxVersion;
                    this.context.incTotalPointWritten(metaData.getNumOfPoints());
                    continue block0;
                }
                ++chunkIdx;
            }
        }
        return maxVersion;
    }
}

