/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.engine.merge.manage.MergeManager;
import org.apache.iotdb.db.engine.merge.manage.MergeResource;
import org.apache.iotdb.db.engine.merge.selector.IMergeFileSelector;
import org.apache.iotdb.db.engine.merge.selector.MaxFileMergeFileSelector;
import org.apache.iotdb.db.engine.merge.selector.MaxSeriesMergeFileSelector;
import org.apache.iotdb.db.engine.merge.selector.MergeFileStrategy;
import org.apache.iotdb.db.engine.merge.task.MergeTask;
import org.apache.iotdb.db.engine.merge.task.RecoverMergeTask;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.version.SimpleFileVersionController;
import org.apache.iotdb.db.engine.version.VersionController;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.exception.MergeException;
import org.apache.iotdb.db.exception.TsFileProcessorException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.OutOfTTLException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.storageGroup.StorageGroupProcessorException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.qp.physical.crud.BatchInsertPlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.JobFileManager;
import org.apache.iotdb.db.utils.CopyOnReadLinkedList;
import org.apache.iotdb.db.utils.UpgradeUtils;
import org.apache.iotdb.db.writelog.recover.TsFileRecoverPerformer;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.fileSystem.fsFactory.FSFactory;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageGroupProcessor {
    private static final String MERGING_MODIFICATION_FILE_NAME = "merge.mods";
    private static final Logger logger = LoggerFactory.getLogger(StorageGroupProcessor.class);
    private static final int MAX_CACHE_SENSORS = 5000;
    private final ReadWriteLock insertLock = new ReentrantReadWriteLock();
    private final Object closeStorageGroupCondition = new Object();
    private final ReadWriteLock closeQueryLock = new ReentrantReadWriteLock();
    private Schema schema;
    private List<TsFileResource> sequenceFileList = new ArrayList<TsFileResource>();
    private TsFileProcessor workSequenceTsFileProcessor = null;
    private CopyOnReadLinkedList<TsFileProcessor> closingSequenceTsFileProcessor = new CopyOnReadLinkedList();
    private List<TsFileResource> unSequenceFileList = new ArrayList<TsFileResource>();
    private TsFileProcessor workUnSequenceTsFileProcessor = null;
    private CopyOnReadLinkedList<TsFileProcessor> closingUnSequenceTsFileProcessor = new CopyOnReadLinkedList();
    private Map<String, Long> latestTimeForEachDevice = new HashMap<String, Long>();
    private Map<String, Long> latestFlushedTimeForEachDevice = new HashMap<String, Long>();
    private String storageGroupName;
    private File storageGroupSysDir;
    private VersionController versionController;
    private ReentrantReadWriteLock mergeLock = new ReentrantReadWriteLock();
    private ModificationFile mergingModification;
    private volatile boolean isMerging = false;
    private long mergeStartTime;
    private LinkedList<String> lruForSensorUsedInQuery = new LinkedList();
    private long dataTTL = Long.MAX_VALUE;
    private FSFactory fsFactory = FSFactoryProducer.getFSFactory();

    public StorageGroupProcessor(String systemInfoDir, String storageGroupName) throws StorageGroupProcessorException {
        this.storageGroupName = storageGroupName;
        this.schema = this.constructSchema(storageGroupName);
        try {
            this.storageGroupSysDir = SystemFileFactory.INSTANCE.getFile(systemInfoDir, storageGroupName);
            if (this.storageGroupSysDir.mkdirs()) {
                logger.info("Storage Group system Directory {} doesn't exist, create it", (Object)this.storageGroupSysDir.getPath());
            } else if (!this.storageGroupSysDir.exists()) {
                logger.error("create Storage Group system Directory {} failed", (Object)this.storageGroupSysDir.getPath());
            }
            this.versionController = new SimpleFileVersionController(this.storageGroupSysDir.getPath());
        }
        catch (IOException e) {
            throw new StorageGroupProcessorException(e);
        }
        this.recover();
    }

    private void recover() throws StorageGroupProcessorException {
        logger.info("recover Storage Group  {}", (Object)this.storageGroupName);
        try {
            List<TsFileResource> seqTsFiles = this.getAllFiles(DirectoryManager.getInstance().getAllSequenceFileFolders());
            List<TsFileResource> unseqTsFiles = this.getAllFiles(DirectoryManager.getInstance().getAllUnSequenceFileFolders());
            this.recoverSeqFiles(seqTsFiles);
            this.recoverUnseqFiles(unseqTsFiles);
            String taskName = this.storageGroupName + "-" + System.currentTimeMillis();
            File mergingMods = SystemFileFactory.INSTANCE.getFile(this.storageGroupSysDir, MERGING_MODIFICATION_FILE_NAME);
            if (mergingMods.exists()) {
                this.mergingModification = new ModificationFile(mergingMods.getPath());
            }
            RecoverMergeTask recoverMergeTask = new RecoverMergeTask(seqTsFiles, unseqTsFiles, this.storageGroupSysDir.getPath(), this::mergeEndAction, taskName, IoTDBDescriptor.getInstance().getConfig().isForceFullMerge(), this.storageGroupName);
            logger.info("{} a RecoverMergeTask {} starts...", (Object)this.storageGroupName, (Object)taskName);
            recoverMergeTask.recoverMerge(IoTDBDescriptor.getInstance().getConfig().isContinueMergeAfterReboot());
            if (!IoTDBDescriptor.getInstance().getConfig().isContinueMergeAfterReboot()) {
                mergingMods.delete();
            }
        }
        catch (IOException | MetadataException e) {
            throw new StorageGroupProcessorException(e);
        }
        for (TsFileResource resource : this.sequenceFileList) {
            this.latestTimeForEachDevice.putAll(resource.getEndTimeMap());
            this.latestFlushedTimeForEachDevice.putAll(resource.getEndTimeMap());
        }
    }

    private List<TsFileResource> getAllFiles(List<String> folders) {
        ArrayList tsFiles = new ArrayList();
        for (String baseDir : folders) {
            File fileFolder = this.fsFactory.getFile(baseDir, this.storageGroupName);
            if (!fileFolder.exists()) continue;
            this.continueFailedRenames(fileFolder, ".temp");
            this.continueFailedRenames(fileFolder, ".merge");
            Collections.addAll(tsFiles, this.fsFactory.listFilesBySuffix(fileFolder.getAbsolutePath(), ".tsfile"));
        }
        tsFiles.sort(this::compareFileName);
        ArrayList<TsFileResource> ret = new ArrayList<TsFileResource>();
        tsFiles.forEach(f -> ret.add(new TsFileResource((File)f)));
        return ret;
    }

    private void continueFailedRenames(File fileFolder, String suffix) {
        File[] files = this.fsFactory.listFilesBySuffix(fileFolder.getAbsolutePath(), suffix);
        if (files != null) {
            for (File tempResource : files) {
                File originResource = this.fsFactory.getFile(tempResource.getPath().replace(suffix, ""));
                if (originResource.exists()) {
                    tempResource.delete();
                    continue;
                }
                tempResource.renameTo(originResource);
            }
        }
    }

    private void recoverSeqFiles(List<TsFileResource> tsFiles) throws StorageGroupProcessorException {
        for (TsFileResource tsFileResource : tsFiles) {
            this.sequenceFileList.add(tsFileResource);
            TsFileRecoverPerformer recoverPerformer = new TsFileRecoverPerformer(this.storageGroupName + "-", this.schema, this.versionController, tsFileResource, false);
            recoverPerformer.recover();
            tsFileResource.setClosed(true);
        }
    }

    private void recoverUnseqFiles(List<TsFileResource> tsFiles) throws StorageGroupProcessorException {
        for (TsFileResource tsFileResource : tsFiles) {
            this.unSequenceFileList.add(tsFileResource);
            TsFileRecoverPerformer recoverPerformer = new TsFileRecoverPerformer(this.storageGroupName + "-", this.schema, this.versionController, tsFileResource, true);
            recoverPerformer.recover();
            tsFileResource.setClosed(true);
        }
    }

    private int compareFileName(File o1, File o2) {
        long ver2;
        String[] items1 = o1.getName().replace(".tsfile", "").split("-");
        String[] items2 = o2.getName().replace(".tsfile", "").split("-");
        long ver1 = Long.parseLong(items1[0]);
        int cmp = Long.compare(ver1, ver2 = Long.parseLong(items2[0]));
        if (cmp == 0) {
            return Long.compare(Long.parseLong(items1[1]), Long.parseLong(items2[1]));
        }
        return cmp;
    }

    private Schema constructSchema(String storageGroupName) {
        List<MeasurementSchema> columnSchemaList = MManager.getInstance().getSchemaForStorageGroup(storageGroupName);
        Schema newSchema = new Schema();
        for (MeasurementSchema measurementSchema : columnSchemaList) {
            newSchema.registerMeasurement(measurementSchema);
        }
        return newSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMeasurement(String measurementId, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props) {
        this.writeLock();
        try {
            this.schema.registerMeasurement(new MeasurementSchema(measurementId, dataType, encoding, compressor, props));
        }
        finally {
            this.writeUnlock();
        }
    }

    public void insert(InsertPlan insertPlan) throws QueryProcessException {
        if (!this.checkTTL(insertPlan.getTime())) {
            throw new OutOfTTLException(insertPlan.getTime(), System.currentTimeMillis() - this.dataTTL);
        }
        this.writeLock();
        try {
            this.latestTimeForEachDevice.putIfAbsent(insertPlan.getDeviceId(), Long.MIN_VALUE);
            this.latestFlushedTimeForEachDevice.putIfAbsent(insertPlan.getDeviceId(), Long.MIN_VALUE);
            this.insertToTsFileProcessor(insertPlan, insertPlan.getTime() > this.latestFlushedTimeForEachDevice.get(insertPlan.getDeviceId()));
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer[] insertBatch(BatchInsertPlan batchInsertPlan) throws QueryProcessException {
        this.writeLock();
        try {
            this.latestTimeForEachDevice.putIfAbsent(batchInsertPlan.getDeviceId(), Long.MIN_VALUE);
            this.latestFlushedTimeForEachDevice.putIfAbsent(batchInsertPlan.getDeviceId(), Long.MIN_VALUE);
            Integer[] results = new Integer[batchInsertPlan.getRowCount()];
            ArrayList<Integer> sequenceIndexes = new ArrayList<Integer>();
            ArrayList<Integer> unsequenceIndexes = new ArrayList<Integer>();
            long lastFlushTime = this.latestFlushedTimeForEachDevice.get(batchInsertPlan.getDeviceId());
            for (int i = 0; i < batchInsertPlan.getRowCount(); ++i) {
                long currTime = batchInsertPlan.getTimes()[i];
                if (!this.checkTTL(currTime)) {
                    results[i] = TSStatusCode.OUT_OF_TTL_ERROR.getStatusCode();
                    continue;
                }
                results[i] = TSStatusCode.SUCCESS_STATUS.getStatusCode();
                if (currTime > lastFlushTime) {
                    sequenceIndexes.add(i);
                    continue;
                }
                unsequenceIndexes.add(i);
            }
            if (!sequenceIndexes.isEmpty()) {
                this.insertBatchToTsFileProcessor(batchInsertPlan, sequenceIndexes, true, results);
            }
            if (!unsequenceIndexes.isEmpty()) {
                this.insertBatchToTsFileProcessor(batchInsertPlan, unsequenceIndexes, false, results);
            }
            Integer[] integerArray = results;
            return integerArray;
        }
        finally {
            this.writeUnlock();
        }
    }

    private boolean checkTTL(long time) {
        return this.dataTTL == Long.MAX_VALUE || System.currentTimeMillis() - time <= this.dataTTL;
    }

    private void insertBatchToTsFileProcessor(BatchInsertPlan batchInsertPlan, List<Integer> indexes, boolean sequence, Integer[] results) throws QueryProcessException {
        TsFileProcessor tsFileProcessor = this.getOrCreateTsFileProcessor(sequence);
        if (tsFileProcessor == null) {
            for (int index : indexes) {
                results[index] = TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode();
            }
            return;
        }
        boolean result = tsFileProcessor.insertBatch(batchInsertPlan, indexes, results);
        if (result && this.latestTimeForEachDevice.get(batchInsertPlan.getDeviceId()) < batchInsertPlan.getMaxTime()) {
            this.latestTimeForEachDevice.put(batchInsertPlan.getDeviceId(), batchInsertPlan.getMaxTime());
        }
        if (tsFileProcessor.shouldFlush()) {
            logger.info("The memtable size {} reaches the threshold, async flush it to tsfile: {}", (Object)tsFileProcessor.getWorkMemTableMemory(), (Object)tsFileProcessor.getTsFileResource().getFile().getAbsolutePath());
            if (tsFileProcessor.shouldClose()) {
                this.moveOneWorkProcessorToClosingList(sequence);
            } else {
                tsFileProcessor.asyncFlush();
            }
        }
    }

    private void insertToTsFileProcessor(InsertPlan insertPlan, boolean sequence) throws QueryProcessException {
        TsFileProcessor tsFileProcessor = this.getOrCreateTsFileProcessor(sequence);
        if (tsFileProcessor == null) {
            return;
        }
        boolean result = tsFileProcessor.insert(insertPlan);
        if (result && this.latestTimeForEachDevice.get(insertPlan.getDeviceId()) < insertPlan.getTime()) {
            this.latestTimeForEachDevice.put(insertPlan.getDeviceId(), insertPlan.getTime());
        }
        if (tsFileProcessor.shouldFlush()) {
            logger.info("The memtable size {} reaches the threshold, async flush it to tsfile: {}", (Object)tsFileProcessor.getWorkMemTableMemory(), (Object)tsFileProcessor.getTsFileResource().getFile().getAbsolutePath());
            if (tsFileProcessor.shouldClose()) {
                this.moveOneWorkProcessorToClosingList(sequence);
            } else {
                tsFileProcessor.asyncFlush();
            }
        }
    }

    private TsFileProcessor getOrCreateTsFileProcessor(boolean sequence) {
        TsFileProcessor tsFileProcessor = null;
        try {
            if (sequence) {
                if (this.workSequenceTsFileProcessor == null) {
                    this.workSequenceTsFileProcessor = this.createTsFileProcessor(true);
                    this.sequenceFileList.add(this.workSequenceTsFileProcessor.getTsFileResource());
                }
                tsFileProcessor = this.workSequenceTsFileProcessor;
            } else {
                if (this.workUnSequenceTsFileProcessor == null) {
                    this.workUnSequenceTsFileProcessor = this.createTsFileProcessor(false);
                    this.unSequenceFileList.add(this.workUnSequenceTsFileProcessor.getTsFileResource());
                }
                tsFileProcessor = this.workUnSequenceTsFileProcessor;
            }
        }
        catch (DiskSpaceInsufficientException e) {
            logger.error("disk space is insufficient when creating TsFile processor, change system mode to read-only", (Throwable)e);
            IoTDBDescriptor.getInstance().getConfig().setReadOnly(true);
        }
        catch (IOException e) {
            logger.error("meet IOException when creating TsFileProcessor, change system mode to read-only", (Throwable)e);
            IoTDBDescriptor.getInstance().getConfig().setReadOnly(true);
        }
        return tsFileProcessor;
    }

    private TsFileProcessor createTsFileProcessor(boolean sequence) throws IOException, DiskSpaceInsufficientException {
        String baseDir = sequence ? DirectoryManager.getInstance().getNextFolderForSequenceFile() : DirectoryManager.getInstance().getNextFolderForUnSequenceFile();
        this.fsFactory.getFile(baseDir, this.storageGroupName).mkdirs();
        String filePath = baseDir + File.separator + this.storageGroupName + File.separator + System.currentTimeMillis() + "-" + this.versionController.nextVersion() + "-" + "0" + ".tsfile";
        if (sequence) {
            return new TsFileProcessor(this.storageGroupName, this.fsFactory.getFile(filePath), this.schema, this.versionController, this::closeUnsealedTsFileProcessor, this::updateLatestFlushTimeCallback, sequence);
        }
        return new TsFileProcessor(this.storageGroupName, this.fsFactory.getFile(filePath), this.schema, this.versionController, this::closeUnsealedTsFileProcessor, () -> true, sequence);
    }

    private void moveOneWorkProcessorToClosingList(boolean sequence) {
        if (sequence) {
            this.closingSequenceTsFileProcessor.add(this.workSequenceTsFileProcessor);
            this.updateEndTimeMap(this.workSequenceTsFileProcessor);
            this.workSequenceTsFileProcessor.asyncClose();
            this.workSequenceTsFileProcessor = null;
            logger.info("close a sequence tsfile processor {}", (Object)this.storageGroupName);
        } else {
            this.closingUnSequenceTsFileProcessor.add(this.workUnSequenceTsFileProcessor);
            this.workUnSequenceTsFileProcessor.asyncClose();
            this.workUnSequenceTsFileProcessor = null;
            logger.info("close an unsequence tsfile processor {}", (Object)this.storageGroupName);
        }
    }

    public void deleteFolder(String systemDir) {
        this.waitForAllCurrentTsFileProcessorsClosed();
        this.writeLock();
        try {
            File storageGroupFolder = SystemFileFactory.INSTANCE.getFile(systemDir, this.storageGroupName);
            if (storageGroupFolder.exists()) {
                FileUtils.deleteDirectory((File)storageGroupFolder);
            }
        }
        catch (IOException e) {
            logger.error("Cannot delete the folder in storage group {}, because", (Object)this.storageGroupName, (Object)e);
        }
        finally {
            this.writeUnlock();
        }
    }

    public void syncDeleteDataFiles() {
        this.waitForAllCurrentTsFileProcessorsClosed();
        this.writeLock();
        try {
            for (TsFileResource tsFileResource : this.unSequenceFileList) {
                tsFileResource.close();
            }
            for (TsFileResource tsFileResource : this.sequenceFileList) {
                tsFileResource.close();
            }
            List<String> folder = DirectoryManager.getInstance().getAllSequenceFileFolders();
            folder.addAll(DirectoryManager.getInstance().getAllUnSequenceFileFolders());
            this.deleteAllSGFolders(folder);
            this.workSequenceTsFileProcessor = null;
            this.workUnSequenceTsFileProcessor = null;
            this.sequenceFileList.clear();
            this.unSequenceFileList.clear();
            this.latestFlushedTimeForEachDevice.clear();
            this.latestTimeForEachDevice.clear();
        }
        catch (IOException e) {
            logger.error("Cannot delete files in storage group {}", (Object)this.storageGroupName, (Object)e);
        }
        finally {
            this.writeUnlock();
        }
    }

    private void deleteAllSGFolders(List<String> folder) {
        for (String tsfilePath : folder) {
            File storageGroupFolder = this.fsFactory.getFile(tsfilePath, this.storageGroupName);
            if (!storageGroupFolder.exists()) continue;
            try {
                FileUtils.deleteDirectory((File)storageGroupFolder);
            }
            catch (IOException e) {
                logger.error("Delete TsFiles failed", (Throwable)e);
            }
        }
    }

    public synchronized void checkFilesTTL() {
        if (this.dataTTL == Long.MAX_VALUE) {
            logger.debug("{}: TTL not set, ignore the check", (Object)this.storageGroupName);
            return;
        }
        long timeLowerBound = System.currentTimeMillis() - this.dataTTL;
        if (logger.isDebugEnabled()) {
            logger.debug("{}: TTL removing files before {}", (Object)this.storageGroupName, (Object)new Date(timeLowerBound));
        }
        ArrayList<TsFileResource> seqFiles = new ArrayList<TsFileResource>(this.sequenceFileList);
        ArrayList<TsFileResource> unseqFiles = new ArrayList<TsFileResource>(this.unSequenceFileList);
        for (TsFileResource tsFileResource : seqFiles) {
            this.checkFileTTL(tsFileResource, timeLowerBound, true);
        }
        for (TsFileResource tsFileResource : unseqFiles) {
            this.checkFileTTL(tsFileResource, timeLowerBound, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFileTTL(TsFileResource resource, long timeLowerBound, boolean isSeq) {
        block12: {
            if (resource.isMerging() || !resource.isClosed() || !resource.isDeleted() && resource.stillLives(timeLowerBound)) {
                return;
            }
            this.writeLock();
            try {
                resource.setDeleted(true);
                if (resource.isMerging()) {
                    return;
                }
                if (!resource.getWriteQueryLock().writeLock().tryLock()) break block12;
                try {
                    resource.remove();
                    if (logger.isInfoEnabled()) {
                        logger.info("Removed a file {} before {} by ttl ({}ms)", new Object[]{resource.getFile().getPath(), new Date(timeLowerBound), this.dataTTL});
                    }
                    if (isSeq) {
                        this.sequenceFileList.remove(resource);
                    } else {
                        this.unSequenceFileList.remove(resource);
                    }
                }
                finally {
                    resource.getWriteQueryLock().writeLock().unlock();
                }
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAllCurrentTsFileProcessorsClosed() {
        Object object = this.closeStorageGroupCondition;
        synchronized (object) {
            try {
                this.putAllWorkingTsFileProcessorIntoClosingList();
                while (!this.closingSequenceTsFileProcessor.isEmpty() || !this.closingUnSequenceTsFileProcessor.isEmpty()) {
                    this.closeStorageGroupCondition.wait();
                }
            }
            catch (InterruptedException e) {
                logger.error("CloseFileNodeCondition error occurs while waiting for closing the storage group {}", (Object)this.storageGroupName, (Object)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    public void putAllWorkingTsFileProcessorIntoClosingList() {
        this.writeLock();
        try {
            logger.info("async force close all files in storage group: {}", (Object)this.storageGroupName);
            if (this.workSequenceTsFileProcessor != null) {
                this.moveOneWorkProcessorToClosingList(true);
            }
            if (this.workUnSequenceTsFileProcessor != null) {
                this.moveOneWorkProcessorToClosingList(false);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryDataSource query(String deviceId, String measurementId, QueryContext context, JobFileManager filePathsManager) {
        this.insertLock.readLock().lock();
        this.mergeLock.readLock().lock();
        LinkedList<String> linkedList = this.lruForSensorUsedInQuery;
        synchronized (linkedList) {
            if (this.lruForSensorUsedInQuery.size() >= 5000) {
                this.lruForSensorUsedInQuery.removeFirst();
            }
            this.lruForSensorUsedInQuery.add(measurementId);
        }
        try {
            List<TsFileResource> seqResources = this.getFileReSourceListForQuery(this.sequenceFileList, deviceId, measurementId, context);
            List<TsFileResource> unseqResources = this.getFileReSourceListForQuery(this.unSequenceFileList, deviceId, measurementId, context);
            QueryDataSource dataSource = new QueryDataSource(new Path(deviceId, measurementId), seqResources, unseqResources);
            if (filePathsManager != null) {
                filePathsManager.addUsedFilesForGivenJob(context.getJobId(), dataSource);
            }
            dataSource.setDataTTL(this.dataTTL);
            QueryDataSource queryDataSource = dataSource;
            return queryDataSource;
        }
        finally {
            this.insertLock.readLock().unlock();
            this.mergeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set calTopKMeasurement(String sensorId, double k) {
        int num = (int)((double)this.lruForSensorUsedInQuery.size() * k);
        HashSet<String> sensorSet = new HashSet<String>(num + 1);
        LinkedList<String> linkedList = this.lruForSensorUsedInQuery;
        synchronized (linkedList) {
            Iterator<String> iterator = this.lruForSensorUsedInQuery.descendingIterator();
            while (iterator.hasNext() && sensorSet.size() < num) {
                String sensor = iterator.next();
                if (sensorSet.contains(sensor)) {
                    iterator.remove();
                    continue;
                }
                sensorSet.add(sensor);
            }
        }
        sensorSet.add(sensorId);
        return sensorSet;
    }

    private void writeLock() {
        this.insertLock.writeLock().lock();
    }

    private void writeUnlock() {
        this.insertLock.writeLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TsFileResource> getFileReSourceListForQuery(List<TsFileResource> tsFileResources, String deviceId, String measurementId, QueryContext context) {
        MeasurementSchema mSchema = this.schema.getMeasurementSchema(measurementId);
        TSDataType dataType = mSchema.getType();
        ArrayList<TsFileResource> tsfileResourcesForQuery = new ArrayList<TsFileResource>();
        long timeLowerBound = this.dataTTL != Long.MAX_VALUE ? System.currentTimeMillis() - this.dataTTL : Long.MIN_VALUE;
        context.setQueryTimeLowerBound(timeLowerBound);
        for (TsFileResource tsFileResource : tsFileResources) {
            if (!this.testResourceDevice(tsFileResource, deviceId)) continue;
            this.closeQueryLock.readLock().lock();
            try {
                if (tsFileResource.isClosed()) {
                    tsfileResourcesForQuery.add(tsFileResource);
                    continue;
                }
                Pair<ReadOnlyMemChunk, List<ChunkMetaData>> pair = tsFileResource.getUnsealedFileProcessor().query(deviceId, measurementId, dataType, mSchema.getProps(), context);
                tsfileResourcesForQuery.add(new TsFileResource(tsFileResource.getFile(), tsFileResource.getStartTimeMap(), tsFileResource.getEndTimeMap(), (ReadOnlyMemChunk)pair.left, (List)pair.right));
            }
            finally {
                this.closeQueryLock.readLock().unlock();
            }
        }
        return tsfileResourcesForQuery;
    }

    private boolean testResourceDevice(TsFileResource tsFileResource, String deviceId) {
        if (!tsFileResource.containsDevice(deviceId)) {
            return false;
        }
        if (this.dataTTL != Long.MAX_VALUE) {
            Long deviceEndTime = tsFileResource.getEndTimeMap().get(deviceId);
            return deviceEndTime == null || this.checkTTL(deviceEndTime);
        }
        return true;
    }

    public void delete(String deviceId, String measurementId, long timestamp) throws IOException {
        this.writeLock();
        this.mergeLock.writeLock().lock();
        ArrayList<ModificationFile> updatedModFiles = new ArrayList<ModificationFile>();
        try {
            Long lastUpdateTime = this.latestTimeForEachDevice.get(deviceId);
            if (lastUpdateTime == null) {
                logger.debug("No device {} in SG {}, deletion invalid", (Object)deviceId, (Object)this.storageGroupName);
                return;
            }
            if (IoTDBDescriptor.getInstance().getConfig().isEnableWal()) {
                if (this.workSequenceTsFileProcessor != null) {
                    this.workSequenceTsFileProcessor.getLogNode().write(new DeletePlan(timestamp, new Path(deviceId, measurementId)));
                }
                if (this.workUnSequenceTsFileProcessor != null) {
                    this.workUnSequenceTsFileProcessor.getLogNode().write(new DeletePlan(timestamp, new Path(deviceId, measurementId)));
                }
            }
            Path fullPath = new Path(deviceId, measurementId);
            Deletion deletion = new Deletion(fullPath, this.versionController.nextVersion(), timestamp);
            if (this.mergingModification != null) {
                this.mergingModification.write(deletion);
                updatedModFiles.add(this.mergingModification);
            }
            this.deleteDataInFiles(this.sequenceFileList, deletion, updatedModFiles);
            this.deleteDataInFiles(this.unSequenceFileList, deletion, updatedModFiles);
        }
        catch (Exception e) {
            for (ModificationFile modFile : updatedModFiles) {
                modFile.abort();
            }
            throw new IOException(e);
        }
        finally {
            this.writeUnlock();
            this.mergeLock.writeLock().unlock();
        }
    }

    private void deleteDataInFiles(List<TsFileResource> tsFileResourceList, Deletion deletion, List<ModificationFile> updatedModFiles) throws IOException {
        String deviceId = deletion.getDevice();
        for (TsFileResource tsFileResource : tsFileResourceList) {
            if (!tsFileResource.containsDevice(deviceId) || deletion.getTimestamp() < tsFileResource.getStartTimeMap().get(deviceId)) continue;
            tsFileResource.getModFile().write(deletion);
            if (!tsFileResource.isClosed()) {
                TsFileProcessor tsfileProcessor = tsFileResource.getUnsealedFileProcessor();
                tsfileProcessor.deleteDataInMemory(deletion);
            }
            updatedModFiles.add(tsFileResource.getModFile());
        }
    }

    private void updateEndTimeMap(TsFileProcessor tsFileProcessor) {
        TsFileResource resource = tsFileProcessor.getTsFileResource();
        for (Map.Entry<String, Long> startTime : resource.getStartTimeMap().entrySet()) {
            String deviceId = startTime.getKey();
            resource.forceUpdateEndTime(deviceId, this.latestTimeForEachDevice.get(deviceId));
        }
    }

    private boolean updateLatestFlushTimeCallback() {
        for (Map.Entry<String, Long> entry : this.latestTimeForEachDevice.entrySet()) {
            this.latestFlushedTimeForEachDevice.put(entry.getKey(), entry.getValue());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeUnsealedTsFileProcessor(TsFileProcessor tsFileProcessor) throws TsFileProcessorException {
        this.closeQueryLock.writeLock().lock();
        try {
            tsFileProcessor.close();
        }
        finally {
            this.closeQueryLock.writeLock().unlock();
        }
        if (this.closingSequenceTsFileProcessor.contains(tsFileProcessor)) {
            this.closingSequenceTsFileProcessor.remove(tsFileProcessor);
        } else {
            this.closingUnSequenceTsFileProcessor.remove(tsFileProcessor);
        }
        logger.info("signal closing storage group condition in {}", (Object)this.storageGroupName);
        Object object = this.closeStorageGroupCondition;
        synchronized (object) {
            this.closeStorageGroupCondition.notifyAll();
        }
    }

    public int countUpgradeFiles() {
        int cntUpgradeFileNum = 0;
        for (TsFileResource seqTsFileResource : this.sequenceFileList) {
            if (!UpgradeUtils.isNeedUpgrade(seqTsFileResource)) continue;
            ++cntUpgradeFileNum;
        }
        for (TsFileResource unseqTsFileResource : this.unSequenceFileList) {
            if (!UpgradeUtils.isNeedUpgrade(unseqTsFileResource)) continue;
            ++cntUpgradeFileNum;
        }
        return cntUpgradeFileNum;
    }

    public void upgrade() {
        for (TsFileResource seqTsFileResource : this.sequenceFileList) {
            seqTsFileResource.doUpgrade();
        }
        for (TsFileResource unseqTsFileResource : this.unSequenceFileList) {
            unseqTsFileResource.doUpgrade();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(boolean fullMerge) {
        this.writeLock();
        try {
            List[] mergeFiles;
            IMergeFileSelector fileSelector;
            MergeResource mergeResource;
            block15: {
                if (this.isMerging) {
                    if (logger.isInfoEnabled()) {
                        logger.info("{} Last merge is ongoing, currently consumed time: {}ms", (Object)this.storageGroupName, (Object)(System.currentTimeMillis() - this.mergeStartTime));
                    }
                    return;
                }
                if (this.unSequenceFileList.isEmpty() || this.sequenceFileList.isEmpty()) {
                    logger.info("{} no files to be merged", (Object)this.storageGroupName);
                    return;
                }
                long budget = IoTDBDescriptor.getInstance().getConfig().getMergeMemoryBudget();
                long timeLowerBound = System.currentTimeMillis() - this.dataTTL;
                mergeResource = new MergeResource(this.sequenceFileList, this.unSequenceFileList, timeLowerBound);
                fileSelector = this.getMergeFileSelector(budget, mergeResource);
                mergeFiles = fileSelector.select();
                if (mergeFiles.length != 0) break block15;
                logger.info("{} cannot select merge candidates under the budget {}", (Object)this.storageGroupName, (Object)budget);
                return;
            }
            try {
                mergeResource.clear();
                String taskName = this.storageGroupName + "-" + System.currentTimeMillis();
                mergeResource.setCacheDeviceMeta(true);
                for (TsFileResource tsFileResource : mergeResource.getSeqFiles()) {
                    tsFileResource.setMerging(true);
                }
                for (TsFileResource tsFileResource : mergeResource.getUnseqFiles()) {
                    tsFileResource.setMerging(true);
                }
                MergeTask mergeTask = new MergeTask(mergeResource, this.storageGroupSysDir.getPath(), this::mergeEndAction, taskName, fullMerge, fileSelector.getConcurrentMergeNum(), this.storageGroupName);
                this.mergingModification = new ModificationFile(this.storageGroupSysDir + File.separator + MERGING_MODIFICATION_FILE_NAME);
                MergeManager.getINSTANCE().submitMainTask(mergeTask);
                if (logger.isInfoEnabled()) {
                    logger.info("{} submits a merge task {}, merging {} seqFiles, {} unseqFiles", new Object[]{this.storageGroupName, taskName, mergeFiles[0].size(), mergeFiles[1].size()});
                }
                this.isMerging = true;
                this.mergeStartTime = System.currentTimeMillis();
            }
            catch (IOException | MergeException e) {
                logger.error("{} cannot select file for merge", (Object)this.storageGroupName, (Object)e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    private IMergeFileSelector getMergeFileSelector(long budget, MergeResource resource) {
        MergeFileStrategy strategy = IoTDBDescriptor.getInstance().getConfig().getMergeFileStrategy();
        switch (strategy) {
            case MAX_FILE_NUM: {
                return new MaxFileMergeFileSelector(resource, budget);
            }
            case MAX_SERIES_NUM: {
                return new MaxSeriesMergeFileSelector(resource, budget);
            }
        }
        throw new UnsupportedOperationException("Unknown MergeFileStrategy " + (Object)((Object)strategy));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUnseqFiles(List<TsFileResource> unseqFiles) {
        this.mergeLock.writeLock().lock();
        try {
            this.unSequenceFileList.removeAll(unseqFiles);
        }
        finally {
            this.mergeLock.writeLock().unlock();
        }
        for (TsFileResource unseqFile : unseqFiles) {
            unseqFile.getWriteQueryLock().writeLock().lock();
            try {
                unseqFile.remove();
            }
            finally {
                unseqFile.getWriteQueryLock().writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMergeModification(TsFileResource seqFile) {
        seqFile.getWriteQueryLock().writeLock().lock();
        try {
            seqFile.removeModFile();
            if (this.mergingModification != null) {
                for (Modification modification : this.mergingModification.getModifications()) {
                    seqFile.getModFile().write(modification);
                }
            }
        }
        catch (IOException e) {
            logger.error("{} cannot clean the ModificationFile of {} after merge", new Object[]{this.storageGroupName, seqFile.getFile(), e});
        }
        finally {
            seqFile.getWriteQueryLock().writeLock().unlock();
        }
    }

    private void removeMergingModification() {
        try {
            if (this.mergingModification != null) {
                this.mergingModification.remove();
                this.mergingModification = null;
            }
        }
        catch (IOException e) {
            logger.error("{} cannot remove merging modification ", (Object)this.storageGroupName, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeEndAction(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles, File mergeLog) {
        logger.info("{} a merge task is ending...", (Object)this.storageGroupName);
        if (unseqFiles.isEmpty()) {
            this.isMerging = false;
            logger.info("{} a merge task abnormally ends", (Object)this.storageGroupName);
            return;
        }
        this.removeUnseqFiles(unseqFiles);
        for (int i = 0; i < seqFiles.size(); ++i) {
            TsFileResource seqFile = seqFiles.get(i);
            this.mergeLock.writeLock().lock();
            try {
                this.updateMergeModification(seqFile);
                if (i != seqFiles.size() - 1) continue;
                this.removeMergingModification();
                this.isMerging = false;
                mergeLog.delete();
                continue;
            }
            finally {
                this.mergeLock.writeLock().unlock();
            }
        }
        logger.info("{} a merge task ends", (Object)this.storageGroupName);
    }

    public void loadNewTsFile(TsFileResource newTsFileResource) throws TsFileProcessorException {
        File tsfileToBeInserted = newTsFileResource.getFile();
        this.writeLock();
        this.mergeLock.writeLock().lock();
        try {
            this.loadTsFileByType(LoadTsFileType.LOAD_SEQUENCE, tsfileToBeInserted, newTsFileResource, this.getBinarySearchIndex(newTsFileResource));
            this.updateLatestTimeMap(newTsFileResource);
        }
        catch (DiskSpaceInsufficientException | TsFileProcessorException e) {
            logger.error("Failed to append the tsfile {} to storage group processor {}.", (Object)tsfileToBeInserted.getAbsolutePath(), (Object)tsfileToBeInserted.getParentFile().getName());
            IoTDBDescriptor.getInstance().getConfig().setReadOnly(true);
            throw new TsFileProcessorException(e);
        }
        finally {
            this.mergeLock.writeLock().unlock();
            this.writeUnlock();
        }
    }

    private int getBinarySearchIndex(TsFileResource tsFileResource) {
        if (this.sequenceFileList.isEmpty()) {
            return 0;
        }
        long targetTsFileTime = Long.parseLong(tsFileResource.getFile().getName().split("-")[0]);
        int s = 0;
        int e = this.sequenceFileList.size() - 1;
        while (s <= e) {
            int m = s + (e - s >> 1);
            long currentTsFileTime = Long.parseLong(this.sequenceFileList.get(m).getFile().getName().split("-")[0]);
            if (currentTsFileTime >= targetTsFileTime) {
                e = m - 1;
                continue;
            }
            s = m + 1;
        }
        return s;
    }

    private void updateLatestTimeMap(TsFileResource newTsFileResource) {
        for (Map.Entry<String, Long> entry : newTsFileResource.getEndTimeMap().entrySet()) {
            String device = entry.getKey();
            long endTime = newTsFileResource.getEndTimeMap().get(device);
            if (!this.latestTimeForEachDevice.containsKey(device) || this.latestTimeForEachDevice.get(device) < endTime) {
                this.latestTimeForEachDevice.put(device, endTime);
            }
            if (this.latestFlushedTimeForEachDevice.containsKey(device) && this.latestFlushedTimeForEachDevice.get(device) >= endTime) continue;
            this.latestFlushedTimeForEachDevice.put(device, endTime);
        }
    }

    private void loadTsFileByType(LoadTsFileType type, File syncedTsFile, TsFileResource tsFileResource, int index) throws TsFileProcessorException, DiskSpaceInsufficientException {
        File targetFile;
        switch (type) {
            case LOAD_UNSEQUENCE: {
                targetFile = new File(DirectoryManager.getInstance().getNextFolderForUnSequenceFile(), syncedTsFile.getParentFile().getName() + File.separatorChar + syncedTsFile.getName());
                tsFileResource.setFile(targetFile);
                this.unSequenceFileList.add(index, tsFileResource);
                logger.info("Load tsfile in unsequence list, move file from {} to {}", (Object)syncedTsFile.getAbsolutePath(), (Object)targetFile.getAbsolutePath());
                break;
            }
            case LOAD_SEQUENCE: {
                targetFile = new File(DirectoryManager.getInstance().getNextFolderForSequenceFile(), syncedTsFile.getParentFile().getName() + File.separatorChar + syncedTsFile.getName());
                tsFileResource.setFile(targetFile);
                this.sequenceFileList.add(index, tsFileResource);
                logger.info("Load tsfile in sequence list, move file from {} to {}", (Object)syncedTsFile.getAbsolutePath(), (Object)targetFile.getAbsolutePath());
                break;
            }
            default: {
                throw new TsFileProcessorException(String.format("Unsupported type of loading tsfile : %s", new Object[]{type}));
            }
        }
        if (!targetFile.getParentFile().exists()) {
            targetFile.getParentFile().mkdirs();
        }
        if (syncedTsFile.exists() && !targetFile.exists()) {
            try {
                FileUtils.moveFile((File)syncedTsFile, (File)targetFile);
            }
            catch (IOException e) {
                throw new TsFileProcessorException(String.format("File renaming failed when loading tsfile. Origin: %s, Target: %s, because %s", syncedTsFile.getAbsolutePath(), targetFile.getAbsolutePath(), e.getMessage()));
            }
        }
        try {
            FileUtils.moveFile((File)new File(syncedTsFile.getAbsolutePath() + ".resource"), (File)new File(targetFile.getAbsolutePath() + ".resource"));
        }
        catch (IOException e) {
            throw new TsFileProcessorException(String.format("File renaming failed when loading .resource file. Origin: %s, Target: %s, because %s", new File(syncedTsFile + ".resource").getAbsolutePath(), new File(targetFile + ".resource").getAbsolutePath(), e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTsfile(File deletedTsfile) {
        TsFileResource deletedTsFileResource;
        block9: {
            this.writeLock();
            this.mergeLock.writeLock().lock();
            deletedTsFileResource = null;
            try {
                Iterator<TsFileResource> sequenceIterator = this.sequenceFileList.iterator();
                while (sequenceIterator.hasNext()) {
                    TsFileResource sequenceResource = sequenceIterator.next();
                    if (!sequenceResource.getFile().getName().equals(deletedTsfile.getName())) continue;
                    deletedTsFileResource = sequenceResource;
                    sequenceIterator.remove();
                    break;
                }
                if (deletedTsFileResource != null) break block9;
                Iterator<TsFileResource> unsequenceIterator = this.unSequenceFileList.iterator();
                while (unsequenceIterator.hasNext()) {
                    TsFileResource unsequenceResource = unsequenceIterator.next();
                    if (!unsequenceResource.getFile().getName().equals(deletedTsfile.getName())) continue;
                    deletedTsFileResource = unsequenceResource;
                    unsequenceIterator.remove();
                    break;
                }
            }
            finally {
                this.mergeLock.writeLock().unlock();
                this.writeUnlock();
            }
        }
        if (deletedTsFileResource == null) {
            return;
        }
        deletedTsFileResource.getWriteQueryLock().writeLock().lock();
        try {
            logger.info("Delete tsfile {} in sync loading process.", (Object)deletedTsFileResource.getFile());
            deletedTsFileResource.remove();
        }
        finally {
            deletedTsFileResource.getWriteQueryLock().writeLock().unlock();
        }
    }

    public TsFileProcessor getWorkSequenceTsFileProcessor() {
        return this.workSequenceTsFileProcessor;
    }

    public void setDataTTL(long dataTTL) {
        this.dataTTL = dataTTL;
        this.checkFilesTTL();
    }

    public List<TsFileResource> getSequenceFileList() {
        return this.sequenceFileList;
    }

    public List<TsFileResource> getUnSequenceFileList() {
        return this.unSequenceFileList;
    }

    @FunctionalInterface
    public static interface CloseTsFileCallBack {
        public void call(TsFileProcessor var1) throws TsFileProcessorException, IOException;
    }

    private static enum LoadTsFileType {
        LOAD_SEQUENCE,
        LOAD_UNSEQUENCE;

    }
}

