/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.exception.query;

import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.rpc.TSStatusCode;

public class IllegalASTFormatException
extends QueryProcessException {
    private static final long serialVersionUID = -8987915911329315588L;

    public IllegalASTFormatException(String sqlStatement, String message) {
        super(String.format("Parsing error, statement [%s] failed when parsing AST tree to generate logical operator. Detailed information: [%s]", sqlStatement, message));
        this.errorCode = TSStatusCode.AST_FORMAT_ERROR.getStatusCode();
    }

    public IllegalASTFormatException(String authCommand) {
        super(String.format("Parsing error, [%s] command failed when parsing AST tree to generate logical operator. Please check you SQL statement", authCommand));
        this.errorCode = TSStatusCode.AST_FORMAT_ERROR.getStatusCode();
    }

    public IllegalASTFormatException(String command, String message, String detailedMessage) {
        super(String.format("Parsing error, [%s] command failed when parsing AST tree to generate logical operator. Detailed information: [%s]", command, message + detailedMessage));
        this.errorCode = TSStatusCode.AST_FORMAT_ERROR.getStatusCode();
    }
}

