/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.auth.entity.PrivilegeType;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.sys.AuthorOperator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.read.common.Path;

public class AuthorPlan
extends PhysicalPlan {
    private final AuthorOperator.AuthorType authorType;
    private String userName;
    private String roleName;
    private String password;
    private String newPassword;
    private Set<Integer> permissions;
    private Path nodeName;

    public AuthorPlan(AuthorOperator.AuthorType authorType, String userName, String roleName, String password, String newPassword, String[] authorizationList, Path nodeName) throws AuthException {
        super(false, Operator.OperatorType.AUTHOR);
        this.authorType = authorType;
        this.userName = userName;
        this.roleName = roleName;
        this.password = password;
        this.newPassword = newPassword;
        this.permissions = this.strToPermissions(authorizationList);
        this.nodeName = nodeName;
        switch (authorType) {
            case DROP_ROLE: {
                this.setOperatorType(Operator.OperatorType.DELETE_ROLE);
                break;
            }
            case DROP_USER: {
                this.setOperatorType(Operator.OperatorType.DELETE_USER);
                break;
            }
            case GRANT_ROLE: {
                this.setOperatorType(Operator.OperatorType.GRANT_ROLE_PRIVILEGE);
                break;
            }
            case GRANT_USER: {
                this.setOperatorType(Operator.OperatorType.GRANT_USER_PRIVILEGE);
                break;
            }
            case CREATE_ROLE: {
                this.setOperatorType(Operator.OperatorType.CREATE_ROLE);
                break;
            }
            case CREATE_USER: {
                this.setOperatorType(Operator.OperatorType.CREATE_USER);
                break;
            }
            case REVOKE_ROLE: {
                this.setOperatorType(Operator.OperatorType.REVOKE_ROLE_PRIVILEGE);
                break;
            }
            case REVOKE_USER: {
                this.setOperatorType(Operator.OperatorType.REVOKE_USER_PRIVILEGE);
                break;
            }
            case UPDATE_USER: {
                this.setOperatorType(Operator.OperatorType.MODIFY_PASSWORD);
                break;
            }
            case GRANT_ROLE_TO_USER: {
                this.setOperatorType(Operator.OperatorType.GRANT_ROLE_PRIVILEGE);
                break;
            }
            case REVOKE_ROLE_FROM_USER: {
                this.setOperatorType(Operator.OperatorType.REVOKE_USER_ROLE);
                break;
            }
            case LIST_USER_PRIVILEGE: {
                this.setQuery(true);
                this.setOperatorType(Operator.OperatorType.LIST_USER_PRIVILEGE);
                break;
            }
            case LIST_ROLE_PRIVILEGE: {
                this.setQuery(true);
                this.setOperatorType(Operator.OperatorType.LIST_ROLE_PRIVILEGE);
                break;
            }
            case LIST_USER_ROLES: {
                this.setQuery(true);
                this.setOperatorType(Operator.OperatorType.LIST_USER_ROLES);
                break;
            }
            case LIST_ROLE_USERS: {
                this.setQuery(true);
                this.setOperatorType(Operator.OperatorType.LIST_ROLE_USERS);
                break;
            }
            case LIST_USER: {
                this.setQuery(true);
                this.setOperatorType(Operator.OperatorType.LIST_USER);
                break;
            }
            case LIST_ROLE: {
                this.setQuery(true);
                this.setOperatorType(Operator.OperatorType.LIST_ROLE);
                break;
            }
        }
    }

    public AuthorOperator.AuthorType getAuthorType() {
        return this.authorType;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public Set<Integer> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<Integer> permissions) {
        this.permissions = permissions;
    }

    public Path getNodeName() {
        return this.nodeName;
    }

    private Set<Integer> strToPermissions(String[] authorizationList) throws AuthException {
        HashSet<Integer> result = new HashSet<Integer>();
        if (authorizationList == null) {
            return result;
        }
        for (String s : authorizationList) {
            PrivilegeType[] types = PrivilegeType.values();
            boolean legal = false;
            for (PrivilegeType privilegeType : types) {
                if (!s.equalsIgnoreCase(privilegeType.name())) continue;
                result.add(privilegeType.ordinal());
                legal = true;
                break;
            }
            if (legal) continue;
            throw new AuthException("No such privilege " + s);
        }
        return result;
    }

    public String toString() {
        return "userName: " + this.userName + "\nroleName: " + this.roleName + "\npassword: " + this.password + "\nnewPassword: " + this.newPassword + "\npermissions: " + this.permissions + "\nnodeName: " + this.nodeName + "\nauthorType: " + (Object)((Object)this.authorType);
    }

    @Override
    public List<Path> getPaths() {
        ArrayList<Path> ret = new ArrayList<Path>();
        if (this.nodeName != null) {
            ret.add(this.nodeName);
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuthorPlan)) {
            return false;
        }
        AuthorPlan that = (AuthorPlan)o;
        return this.getAuthorType() == that.getAuthorType() && Objects.equals(this.getUserName(), that.getUserName()) && Objects.equals(this.getRoleName(), that.getRoleName()) && Objects.equals(this.getPassword(), that.getPassword()) && Objects.equals(this.getNewPassword(), that.getNewPassword()) && Objects.equals(this.getPermissions(), that.getPermissions()) && Objects.equals(this.getNodeName(), that.getNodeName());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getAuthorType(), this.getUserName(), this.getRoleName(), this.getPassword(), this.getNewPassword(), this.getPermissions(), this.getNodeName()});
    }
}

