/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset.groupby;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.exception.path.PathException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.query.aggregation.AggreResultData;
import org.apache.iotdb.db.query.aggregation.AggregateFunction;
import org.apache.iotdb.db.query.factory.AggreFuncFactory;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Pair;

public abstract class GroupByEngineDataSet
extends QueryDataSet {
    protected long jobId;
    protected List<Path> selectedSeries;
    private long unit;
    private long origin;
    private List<Pair<Long, Long>> mergedIntervals;
    protected long startTime;
    protected long endTime;
    private int usedIndex;
    protected List<AggregateFunction> functions;
    protected boolean hasCachedTimeInterval;

    public GroupByEngineDataSet(long jobId, List<Path> paths, long unit, long origin, List<Pair<Long, Long>> mergedIntervals) {
        super(paths);
        this.jobId = jobId;
        this.selectedSeries = paths;
        this.unit = unit;
        this.origin = origin;
        this.mergedIntervals = mergedIntervals;
        this.functions = new ArrayList<AggregateFunction>();
        this.usedIndex = 0;
        this.hasCachedTimeInterval = false;
        this.endTime = -1L;
    }

    protected void initAggreFuction(List<String> aggres) throws PathException {
        ArrayList<TSDataType> types = new ArrayList<TSDataType>();
        for (int i = 0; i < this.paths.size(); ++i) {
            TSDataType tsDataType = MManager.getInstance().getSeriesType(this.selectedSeries.get(i).getFullPath());
            AggregateFunction function = AggreFuncFactory.getAggrFuncByName(aggres.get(i), tsDataType);
            function.init();
            this.functions.add(function);
            types.add(function.getResultDataType());
        }
        super.setDataTypes(types);
    }

    public boolean hasNext() {
        if (this.hasCachedTimeInterval) {
            return true;
        }
        while (this.usedIndex < this.mergedIntervals.size() && (Long)this.mergedIntervals.get((int)this.usedIndex).right < this.endTime) {
            ++this.usedIndex;
        }
        if (this.usedIndex >= this.mergedIntervals.size()) {
            return false;
        }
        if (this.endTime < (Long)this.mergedIntervals.get((int)this.usedIndex).left) {
            this.startTime = (Long)this.mergedIntervals.get((int)this.usedIndex).left;
            this.endTime = this.origin > this.startTime ? this.origin - (this.origin - this.startTime) / this.unit * this.unit : this.origin + (this.startTime - this.origin) / this.unit * this.unit + this.unit;
            this.hasCachedTimeInterval = true;
            return true;
        }
        if (this.endTime <= (Long)this.mergedIntervals.get((int)this.usedIndex).right) {
            this.startTime = this.endTime;
            this.endTime += this.unit;
            this.hasCachedTimeInterval = true;
            return true;
        }
        return false;
    }

    public Pair<Long, Long> nextTimePartition() {
        this.hasCachedTimeInterval = false;
        return new Pair((Object)this.startTime, (Object)this.endTime);
    }

    protected Field getField(AggreResultData aggreResultData) {
        if (!aggreResultData.isSetValue()) {
            return new Field(null);
        }
        Field field = new Field(aggreResultData.getDataType());
        switch (aggreResultData.getDataType()) {
            case INT32: {
                field.setIntV(aggreResultData.getIntRet());
                break;
            }
            case INT64: {
                field.setLongV(aggreResultData.getLongRet());
                break;
            }
            case FLOAT: {
                field.setFloatV(aggreResultData.getFloatRet());
                break;
            }
            case DOUBLE: {
                field.setDoubleV(aggreResultData.getDoubleRet());
                break;
            }
            case BOOLEAN: {
                field.setBoolV(aggreResultData.isBooleanRet());
                break;
            }
            case TEXT: {
                field.setBinaryV(aggreResultData.getBinaryRet());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException("UnSupported: " + aggreResultData.getDataType());
            }
        }
        return field;
    }
}

