/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset.groupby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.path.PathException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.aggregation.AggreResultData;
import org.apache.iotdb.db.query.aggregation.AggregateFunction;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.dataset.groupby.GroupByEngineDataSet;
import org.apache.iotdb.db.query.reader.IAggregateReader;
import org.apache.iotdb.db.query.reader.IPointReader;
import org.apache.iotdb.db.query.reader.resourceRelated.SeqResourceIterateReader;
import org.apache.iotdb.db.query.reader.resourceRelated.UnseqResourceMergeReader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.Pair;

public class GroupByWithoutValueFilterDataSet
extends GroupByEngineDataSet {
    private List<IPointReader> unSequenceReaderList = new ArrayList<IPointReader>();
    private List<IAggregateReader> sequenceReaderList = new ArrayList<IAggregateReader>();
    private List<BatchData> batchDataList;
    private List<Boolean> hasCachedSequenceDataList = new ArrayList<Boolean>();
    private Filter timeFilter = null;

    public GroupByWithoutValueFilterDataSet(long jobId, List<Path> paths, long unit, long origin, List<Pair<Long, Long>> mergedIntervals) {
        super(jobId, paths, unit, origin, mergedIntervals);
        this.batchDataList = new ArrayList<BatchData>();
        for (int i = 0; i < paths.size(); ++i) {
            this.hasCachedSequenceDataList.add(false);
            this.batchDataList.add(null);
        }
    }

    public void initGroupBy(QueryContext context, List<String> aggres, IExpression expression) throws StorageEngineException, PathException, IOException {
        this.initAggreFuction(aggres);
        if (expression != null) {
            this.timeFilter = ((GlobalTimeExpression)expression).getFilter();
        }
        for (Path path : this.selectedSeries) {
            QueryDataSource queryDataSource = QueryResourceManager.getInstance().getQueryDataSource(path, context);
            this.timeFilter = queryDataSource.updateTimeFilter(this.timeFilter);
            SeqResourceIterateReader seqResourceIterateReader = new SeqResourceIterateReader(queryDataSource.getSeriesPath(), queryDataSource.getSeqResources(), this.timeFilter, context, false);
            UnseqResourceMergeReader unseqResourceMergeReader = new UnseqResourceMergeReader(queryDataSource.getSeriesPath(), queryDataSource.getUnseqResources(), context, this.timeFilter);
            this.sequenceReaderList.add(seqResourceIterateReader);
            this.unSequenceReaderList.add(unseqResourceMergeReader);
        }
    }

    public RowRecord next() throws IOException {
        if (!this.hasCachedTimeInterval) {
            throw new IOException("need to call hasNext() before calling next() in GroupByWithoutValueFilterDataSet.");
        }
        this.hasCachedTimeInterval = false;
        RowRecord record = new RowRecord(this.startTime);
        for (int i = 0; i < this.functions.size(); ++i) {
            AggreResultData res;
            try {
                res = this.nextSeries(i);
            }
            catch (QueryProcessException e) {
                throw new IOException(e);
            }
            if (res == null) {
                record.addField(new Field(null));
                continue;
            }
            record.addField(this.getField(res));
        }
        return record;
    }

    private AggreResultData nextSeries(int idx) throws IOException, QueryProcessException {
        IPointReader unsequenceReader = this.unSequenceReaderList.get(idx);
        IAggregateReader sequenceReader = this.sequenceReaderList.get(idx);
        AggregateFunction function = (AggregateFunction)this.functions.get(idx);
        function.init();
        this.skipBeforeStartTimeData(idx, sequenceReader, unsequenceReader);
        boolean finishCheckSequenceData = this.calGroupByInBatchData(idx, function, unsequenceReader);
        if (finishCheckSequenceData) {
            function.calculateValueFromUnsequenceReader(unsequenceReader, this.endTime);
            return function.getResult().deepCopy();
        }
        while (sequenceReader.hasNext()) {
            PageHeader pageHeader = sequenceReader.nextPageHeader();
            if (pageHeader == null) {
                this.batchDataList.set(idx, sequenceReader.nextBatch());
                this.hasCachedSequenceDataList.set(idx, true);
                finishCheckSequenceData = this.calGroupByInBatchData(idx, function, unsequenceReader);
                continue;
            }
            long minTime = pageHeader.getMinTimestamp();
            long maxTime = pageHeader.getMaxTimestamp();
            if (minTime >= this.endTime) {
                finishCheckSequenceData = true;
            } else if (this.canUseHeader(minTime, maxTime, unsequenceReader, function)) {
                function.calculateValueFromPageHeader(pageHeader);
                sequenceReader.skipPageData();
            } else {
                this.batchDataList.set(idx, sequenceReader.nextBatch());
                this.hasCachedSequenceDataList.set(idx, true);
                finishCheckSequenceData = this.calGroupByInBatchData(idx, function, unsequenceReader);
            }
            if (!finishCheckSequenceData) continue;
            break;
        }
        function.calculateValueFromUnsequenceReader(unsequenceReader, this.endTime);
        return function.getResult().deepCopy();
    }

    private boolean calGroupByInBatchData(int idx, AggregateFunction function, IPointReader unsequenceReader) throws IOException, QueryProcessException {
        BatchData batchData = this.batchDataList.get(idx);
        boolean hasCachedSequenceData = this.hasCachedSequenceDataList.get(idx);
        boolean finishCheckSequenceData = false;
        if (hasCachedSequenceData && batchData.hasNext()) {
            function.calculateValueFromPageData(batchData, unsequenceReader, this.endTime);
        }
        if (hasCachedSequenceData && batchData.hasNext()) {
            finishCheckSequenceData = true;
        } else {
            hasCachedSequenceData = false;
        }
        this.batchDataList.set(idx, batchData);
        this.hasCachedSequenceDataList.set(idx, hasCachedSequenceData);
        return finishCheckSequenceData;
    }

    private void skipBeforeStartTimeData(int idx, IAggregateReader sequenceReader, IPointReader unsequenceReader) throws IOException {
        this.skipPointInUnsequenceData(unsequenceReader);
        if (this.skipPointInBatchData(idx)) {
            return;
        }
        while (sequenceReader.hasNext()) {
            PageHeader pageHeader = sequenceReader.nextPageHeader();
            if (pageHeader == null) {
                this.batchDataList.set(idx, sequenceReader.nextBatch());
                this.hasCachedSequenceDataList.set(idx, true);
                if (!this.skipPointInBatchData(idx)) continue;
                return;
            }
            if (pageHeader.getMaxTimestamp() < this.startTime) {
                sequenceReader.skipPageData();
                continue;
            }
            if (pageHeader.getMinTimestamp() >= this.startTime) {
                return;
            }
            this.batchDataList.set(idx, sequenceReader.nextBatch());
            this.hasCachedSequenceDataList.set(idx, true);
            if (!this.skipPointInBatchData(idx)) continue;
            return;
        }
    }

    private void skipPointInUnsequenceData(IPointReader unsequenceReader) throws IOException {
        while (unsequenceReader.hasNext() && unsequenceReader.current().getTimestamp() < this.startTime) {
            unsequenceReader.next();
        }
    }

    private boolean skipPointInBatchData(int idx) {
        BatchData batchData = this.batchDataList.get(idx);
        boolean hasCachedSequenceData = this.hasCachedSequenceDataList.get(idx);
        if (!hasCachedSequenceData) {
            return false;
        }
        while (batchData.hasNext() && batchData.currentTime() < this.startTime) {
            batchData.next();
        }
        this.batchDataList.set(idx, batchData);
        if (batchData.hasNext()) {
            return true;
        }
        this.hasCachedSequenceDataList.set(idx, false);
        return false;
    }

    private boolean canUseHeader(long minTime, long maxTime, IPointReader unSequenceReader, AggregateFunction function) throws IOException, QueryProcessException {
        if (this.timeFilter != null && !this.timeFilter.containStartEndTime(minTime, maxTime)) {
            return false;
        }
        function.calculateValueFromUnsequenceReader(unSequenceReader, minTime);
        return !unSequenceReader.hasNext() || unSequenceReader.current().getTimestamp() > maxTime;
    }
}

