/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.reader.chunkRelated;

import java.io.IOException;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.query.reader.IPointReader;
import org.apache.iotdb.db.query.reader.IReaderByTimestamp;
import org.apache.iotdb.db.query.reader.chunkRelated.DiskChunkReader;
import org.apache.iotdb.db.query.reader.chunkRelated.DiskChunkReaderByTimestamp;
import org.apache.iotdb.db.query.reader.chunkRelated.MemChunkReader;
import org.apache.iotdb.db.query.reader.chunkRelated.MemChunkReaderByTimestamp;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.controller.IChunkLoader;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReader;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReaderByTimestamp;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReaderWithFilter;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReaderWithoutFilter;

public class ChunkReaderWrap {
    private ChunkReaderType type;
    private Filter filter;
    private ChunkMetaData chunkMetaData;
    private IChunkLoader chunkLoader;
    private ReadOnlyMemChunk readOnlyMemChunk;

    protected ChunkReaderWrap() {
    }

    public ChunkReaderWrap(ChunkMetaData metaData, IChunkLoader chunkLoader, Filter filter) {
        this.type = ChunkReaderType.DISK_CHUNK;
        this.chunkMetaData = metaData;
        this.chunkLoader = chunkLoader;
        this.filter = filter;
    }

    public ChunkReaderWrap(ReadOnlyMemChunk readOnlyMemChunk, Filter filter) {
        this.type = ChunkReaderType.MEM_CHUNK;
        this.readOnlyMemChunk = readOnlyMemChunk;
        this.filter = filter;
    }

    public IPointReader getIPointReader() throws IOException {
        if (this.type.equals((Object)ChunkReaderType.DISK_CHUNK)) {
            Chunk chunk = this.chunkLoader.getChunk(this.chunkMetaData);
            ChunkReaderWithFilter chunkReader = this.filter != null ? new ChunkReaderWithFilter(chunk, this.filter) : new ChunkReaderWithoutFilter(chunk);
            return new DiskChunkReader((ChunkReader)chunkReader);
        }
        return new MemChunkReader(this.readOnlyMemChunk, this.filter);
    }

    public IReaderByTimestamp getIReaderByTimestamp() throws IOException {
        if (this.type.equals((Object)ChunkReaderType.DISK_CHUNK)) {
            Chunk chunk = this.chunkLoader.getChunk(this.chunkMetaData);
            ChunkReaderByTimestamp chunkReader = new ChunkReaderByTimestamp(chunk);
            return new DiskChunkReaderByTimestamp(chunkReader);
        }
        return new MemChunkReaderByTimestamp(this.readOnlyMemChunk);
    }

    public String getMeasurementUid() {
        if (this.chunkMetaData != null) {
            return this.chunkMetaData.getMeasurementUid();
        }
        return null;
    }

    static enum ChunkReaderType {
        DISK_CHUNK,
        MEM_CHUNK;

    }
}

