/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.auth.authorizer.LocalFileAuthorizer;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.adapter.CompressionRatio;
import org.apache.iotdb.db.conf.adapter.IoTDBConfigDynamicAdapter;
import org.apache.iotdb.db.cost.statistic.Measurement;
import org.apache.iotdb.db.cost.statistic.Operation;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.flush.pool.FlushTaskPoolManager;
import org.apache.iotdb.db.exception.QueryInBatchStatementException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.path.PathException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.exception.storageGroup.StorageGroupException;
import org.apache.iotdb.db.metadata.MManager;
import org.apache.iotdb.db.metrics.server.SqlArgument;
import org.apache.iotdb.db.qp.QueryProcessor;
import org.apache.iotdb.db.qp.executor.QueryProcessExecutor;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.BatchInsertPlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.sys.AuthorPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTTLPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.tools.watermark.GroupedLSBWatermarkEncoder;
import org.apache.iotdb.db.utils.QueryDataSetUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.ServerProperties;
import org.apache.iotdb.service.rpc.thrift.TSBatchInsertionReq;
import org.apache.iotdb.service.rpc.thrift.TSCancelOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSCloseOperationReq;
import org.apache.iotdb.service.rpc.thrift.TSCloseSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSCreateTimeseriesReq;
import org.apache.iotdb.service.rpc.thrift.TSDeleteDataReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteBatchStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteBatchStatementResp;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementReq;
import org.apache.iotdb.service.rpc.thrift.TSExecuteStatementResp;
import org.apache.iotdb.service.rpc.thrift.TSFetchMetadataReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchMetadataResp;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsReq;
import org.apache.iotdb.service.rpc.thrift.TSFetchResultsResp;
import org.apache.iotdb.service.rpc.thrift.TSGetTimeZoneResp;
import org.apache.iotdb.service.rpc.thrift.TSHandleIdentifier;
import org.apache.iotdb.service.rpc.thrift.TSIService;
import org.apache.iotdb.service.rpc.thrift.TSInsertReq;
import org.apache.iotdb.service.rpc.thrift.TSInsertionReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionReq;
import org.apache.iotdb.service.rpc.thrift.TSOpenSessionResp;
import org.apache.iotdb.service.rpc.thrift.TSOperationHandle;
import org.apache.iotdb.service.rpc.thrift.TSProtocolVersion;
import org.apache.iotdb.service.rpc.thrift.TSQueryDataSet;
import org.apache.iotdb.service.rpc.thrift.TSSetTimeZoneReq;
import org.apache.iotdb.service.rpc.thrift.TSStatus;
import org.apache.iotdb.service.rpc.thrift.TSStatusType;
import org.apache.iotdb.service.rpc.thrift.TS_SessionHandle;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.thrift.TException;
import org.apache.thrift.server.ServerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSServiceImpl
implements TSIService.Iface,
ServerContext {
    private static final Logger logger = LoggerFactory.getLogger(TSServiceImpl.class);
    private static final String INFO_NOT_LOGIN = "{}: Not login.";
    private static final int MAX_SIZE = 200;
    private static final int DELETE_SIZE = 50;
    public static Vector<SqlArgument> sqlArgumentsList = new Vector();
    protected QueryProcessor processor;
    protected ThreadLocal<String> username = new ThreadLocal();
    private ThreadLocal<Long> statementIdGenerator = new ThreadLocal();
    private ThreadLocal<Long> queryIdGenerator = new ThreadLocal();
    private ThreadLocal<Map<Long, Set<Long>>> statementId2QueryId = new ThreadLocal();
    private ThreadLocal<Map<Long, PhysicalPlan>> operationStatus = new ThreadLocal();
    private ThreadLocal<Map<Long, QueryDataSet>> queryDataSets = new ThreadLocal();
    private ThreadLocal<ZoneId> zoneIds = new ThreadLocal();
    private IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private ThreadLocal<Map<Long, QueryContext>> contextMapLocal = new ThreadLocal();

    public TSServiceImpl() {
        this.processor = new QueryProcessor(new QueryProcessExecutor());
    }

    public TSOpenSessionResp openSession(TSOpenSessionReq req) throws TException {
        TSStatus tsStatus;
        boolean status;
        LocalFileAuthorizer authorizer;
        logger.info("{}: receive open session request from username {}", (Object)"IoTDB", (Object)req.getUsername());
        try {
            authorizer = LocalFileAuthorizer.getInstance();
        }
        catch (AuthException e) {
            throw new TException((Throwable)e);
        }
        try {
            status = authorizer.login(req.getUsername(), req.getPassword());
        }
        catch (AuthException e) {
            logger.error("meet error while logging in.", (Throwable)e);
            status = false;
        }
        if (status) {
            tsStatus = new TSStatus(this.getStatus(TSStatusCode.SUCCESS_STATUS, "Login successfully"));
            this.username.set(req.getUsername());
            this.zoneIds.set(this.config.getZoneID());
            this.initForOneSession();
        } else {
            tsStatus = this.getStatus(TSStatusCode.WRONG_LOGIN_PASSWORD_ERROR);
        }
        TSOpenSessionResp resp = new TSOpenSessionResp(tsStatus, TSProtocolVersion.IOTDB_SERVICE_PROTOCOL_V1);
        resp.setSessionHandle(new TS_SessionHandle(new TSHandleIdentifier(ByteBuffer.wrap(req.getUsername().getBytes()), ByteBuffer.wrap(req.getPassword().getBytes()), -1L)));
        logger.info("{}: Login status: {}. User : {}", new Object[]{"IoTDB", tsStatus.getStatusType().getMessage(), req.getUsername()});
        return resp;
    }

    private void initForOneSession() {
        this.operationStatus.set(new HashMap());
        this.queryDataSets.set(new HashMap());
        this.queryIdGenerator.set(0L);
        this.statementIdGenerator.set(0L);
        this.contextMapLocal.set(new HashMap());
        this.statementId2QueryId.set(new HashMap());
    }

    public TSStatus closeSession(TSCloseSessionReq req) {
        TSStatus tsStatus;
        logger.info("{}: receive close session", (Object)"IoTDB");
        if (this.username.get() == null) {
            tsStatus = this.getStatus(TSStatusCode.NOT_LOGIN_ERROR);
        } else {
            tsStatus = new TSStatus(this.getStatus(TSStatusCode.SUCCESS_STATUS));
            this.username.remove();
        }
        if (this.zoneIds.get() != null) {
            this.zoneIds.remove();
        }
        if (this.statementIdGenerator.get() != null) {
            this.statementIdGenerator.remove();
        }
        if (this.queryIdGenerator.get() != null) {
            this.queryIdGenerator.remove();
        }
        if (this.operationStatus.get() != null) {
            this.operationStatus.remove();
        }
        if (this.queryDataSets.get() != null) {
            this.queryDataSets.remove();
        }
        if (this.contextMapLocal.get() != null) {
            try {
                for (QueryContext context : this.contextMapLocal.get().values()) {
                    QueryResourceManager.getInstance().endQueryForGivenJob(context.getJobId());
                }
                this.contextMapLocal.remove();
            }
            catch (StorageEngineException e) {
                logger.error("Error in closeSession : ", (Throwable)e);
                return new TSStatus(this.getStatus(TSStatusCode.CLOSE_OPERATION_ERROR, "Error in closeOperation"));
            }
        }
        if (this.statementId2QueryId.get() != null) {
            this.statementId2QueryId.remove();
        }
        return new TSStatus(tsStatus);
    }

    public TSStatus cancelOperation(TSCancelOperationReq req) {
        return new TSStatus(this.getStatus(TSStatusCode.SUCCESS_STATUS));
    }

    public TSStatus closeOperation(TSCloseOperationReq req) {
        logger.info("{}: receive close operation", (Object)"IoTDB");
        try {
            if (req.isSetStmtId()) {
                long stmtId = req.getStmtId();
                Set<Long> queryIdSet = this.statementId2QueryId.get().get(stmtId);
                if (queryIdSet != null) {
                    for (long queryId : queryIdSet) {
                        this.releaseQueryResource(queryId);
                    }
                    this.statementId2QueryId.get().remove(stmtId);
                }
            } else {
                this.releaseQueryResource(req.queryId);
            }
        }
        catch (Exception e) {
            logger.error("Error in closeOperation : ", (Throwable)e);
            return new TSStatus(this.getStatus(TSStatusCode.CLOSE_OPERATION_ERROR, "Error in closeOperation"));
        }
        return new TSStatus(this.getStatus(TSStatusCode.SUCCESS_STATUS));
    }

    private void releaseQueryResource(long queryId) throws StorageEngineException {
        if (this.operationStatus.get() != null) {
            this.operationStatus.get().remove(queryId);
        }
        if (this.queryDataSets.get() != null) {
            this.queryDataSets.get().remove(queryId);
        }
        if (this.contextMapLocal.get() != null && this.contextMapLocal.get().containsKey(queryId)) {
            QueryResourceManager.getInstance().endQueryForGivenJob(this.contextMapLocal.get().remove(queryId).getJobId());
        }
    }

    private TSStatus getStatus(TSStatusCode statusType) {
        TSStatusType statusCodeAndMessage = new TSStatusType(statusType.getStatusCode(), "");
        return new TSStatus(statusCodeAndMessage);
    }

    private TSStatus getStatus(TSStatusCode statusType, String appendMessage) {
        TSStatusType statusCodeAndMessage = new TSStatusType(statusType.getStatusCode(), appendMessage);
        return new TSStatus(statusCodeAndMessage);
    }

    public TSFetchMetadataResp fetchMetadata(TSFetchMetadataReq req) {
        TSStatus status;
        if (!this.checkLogin()) {
            logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
            TSStatus status2 = this.getStatus(TSStatusCode.NOT_LOGIN_ERROR);
            return new TSFetchMetadataResp(status2);
        }
        TSFetchMetadataResp resp = new TSFetchMetadataResp();
        try {
            switch (req.getType()) {
                case "SHOW_TIMESERIES": {
                    String path = req.getColumnPath();
                    List<List<String>> timeseriesList = this.getTimeSeriesForPath(path);
                    resp.setTimeseriesList(timeseriesList);
                    status = new TSStatus(this.getStatus(TSStatusCode.SUCCESS_STATUS));
                    break;
                }
                case "SHOW_STORAGE_GROUP": {
                    HashSet<String> storageGroups = new HashSet<String>(this.getAllStorageGroups());
                    resp.setStorageGroups(storageGroups);
                    status = new TSStatus(this.getStatus(TSStatusCode.SUCCESS_STATUS));
                    break;
                }
                case "METADATA_IN_JSON": {
                    String metadataInJson = this.getMetadataInString();
                    resp.setMetadataInJson(metadataInJson);
                    status = new TSStatus(this.getStatus(TSStatusCode.SUCCESS_STATUS));
                    break;
                }
                case "SHOW_DEVICES": {
                    Set<String> devices = this.getAllDevices();
                    resp.setDevices(devices);
                    status = new TSStatus(this.getStatus(TSStatusCode.SUCCESS_STATUS));
                    break;
                }
                case "SHOW_CHILD_PATHS": {
                    String path = req.getColumnPath();
                    Set<String> childPaths = this.getChildPaths(path);
                    resp.setChildPaths(childPaths);
                    status = new TSStatus(this.getStatus(TSStatusCode.SUCCESS_STATUS));
                    break;
                }
                case "COLUMN": {
                    resp.setDataType(TSServiceImpl.getSeriesType(req.getColumnPath()).toString());
                    status = new TSStatus(this.getStatus(TSStatusCode.SUCCESS_STATUS));
                    break;
                }
                case "ALL_COLUMNS": {
                    resp.setColumnsList(this.getPaths(req.getColumnPath()));
                    status = new TSStatus(this.getStatus(TSStatusCode.SUCCESS_STATUS));
                    break;
                }
                case "COUNT_TIMESERIES": {
                    resp.setTimeseriesNum(this.getPaths(req.getColumnPath()).size());
                    status = new TSStatus(this.getStatus(TSStatusCode.SUCCESS_STATUS));
                    break;
                }
                case "COUNT_NODES": {
                    resp.setNodesList(this.getNodesList(req.getColumnPath(), req.getNodeLevel()));
                    status = new TSStatus(this.getStatus(TSStatusCode.SUCCESS_STATUS));
                    break;
                }
                case "COUNT_NODE_TIMESERIES": {
                    resp.setNodeTimeseriesNum(this.getNodeTimeseriesNum(this.getNodesList(req.getColumnPath(), req.getNodeLevel())));
                    status = new TSStatus(this.getStatus(TSStatusCode.SUCCESS_STATUS));
                    break;
                }
                case "VERSION": {
                    resp.setVersion(this.getVersion());
                    status = new TSStatus(this.getStatus(TSStatusCode.SUCCESS_STATUS));
                    break;
                }
                default: {
                    status = this.getStatus(TSStatusCode.METADATA_ERROR, req.getType());
                    break;
                }
            }
        }
        catch (OutOfMemoryError | SQLException | MetadataException | QueryProcessException e) {
            logger.error(String.format("Failed to fetch timeseries %s's metadata", req.getColumnPath()), e);
            Thread.currentThread().interrupt();
            TSStatus status3 = this.getStatus(TSStatusCode.METADATA_ERROR, e.getMessage());
            resp.setStatus(status3);
            return resp;
        }
        resp.setStatus(status);
        return resp;
    }

    private Map<String, String> getNodeTimeseriesNum(List<String> nodes) throws MetadataException {
        HashMap<String, String> nodeColumnsNum = new HashMap<String, String>();
        for (String columnPath : nodes) {
            nodeColumnsNum.put(columnPath, Integer.toString(this.getPaths(columnPath).size()));
        }
        return nodeColumnsNum;
    }

    private List<String> getNodesList(String schemaPattern, int level) throws SQLException {
        return MManager.getInstance().getNodesList(schemaPattern, level);
    }

    private List<String> getAllStorageGroups() {
        return MManager.getInstance().getAllStorageGroupNames();
    }

    private Set<String> getAllDevices() throws SQLException {
        return MManager.getInstance().getAllDevices();
    }

    private Set<String> getChildPaths(String path) throws PathException {
        return MManager.getInstance().getChildNodePathInNextLevel(path);
    }

    private String getVersion() throws SQLException {
        return "0.9.0";
    }

    private List<List<String>> getTimeSeriesForPath(String path) throws PathException {
        return MManager.getInstance().getShowTimeseriesPath(path);
    }

    private String getMetadataInString() {
        return MManager.getInstance().getMetadataInString();
    }

    public static TSDataType getSeriesType(String path) throws QueryProcessException {
        switch (path.toLowerCase()) {
            case "role": 
            case "user": 
            case "privilege": 
            case "storage group": {
                return TSDataType.TEXT;
            }
            case "ttl": {
                return TSDataType.INT64;
            }
        }
        if (path.contains("(") && !path.startsWith("(") && path.endsWith(")")) {
            int leftBracketIndex = path.indexOf(40);
            String aggrType = path.substring(0, leftBracketIndex);
            String innerPath = path.substring(leftBracketIndex + 1, path.length() - 1);
            switch (aggrType.toLowerCase()) {
                case "min_time": 
                case "max_time": 
                case "count": {
                    return TSDataType.INT64;
                }
                case "last": 
                case "first": 
                case "min_value": 
                case "max_value": {
                    return TSServiceImpl.getSeriesType(innerPath);
                }
                case "avg": 
                case "sum": {
                    return TSDataType.DOUBLE;
                }
            }
            throw new QueryProcessException("aggregate does not support " + aggrType + " function.");
        }
        return MManager.getInstance().getSeriesType(path);
    }

    protected List<String> getPaths(String path) throws MetadataException {
        return MManager.getInstance().getPaths(path);
    }

    private boolean execAdminCommand(String statement) throws StorageEngineException {
        if (!"root".equals(this.username.get())) {
            return false;
        }
        if (statement == null) {
            return false;
        }
        switch (statement = statement.toLowerCase()) {
            case "flush": {
                StorageEngine.getInstance().syncCloseAllProcessor();
                return true;
            }
            case "merge": {
                StorageEngine.getInstance().mergeAll(IoTDBDescriptor.getInstance().getConfig().isForceFullMerge());
                return true;
            }
            case "full merge": {
                StorageEngine.getInstance().mergeAll(true);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSExecuteBatchStatementResp executeBatchStatement(TSExecuteBatchStatementReq req) {
        long t1 = System.currentTimeMillis();
        ArrayList<Integer> result = new ArrayList<Integer>();
        try {
            TSExecuteBatchStatementResp tSExecuteBatchStatementResp;
            if (!this.checkLogin()) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                TSExecuteBatchStatementResp tSExecuteBatchStatementResp2 = this.getTSBatchExecuteStatementResp(this.getStatus(TSStatusCode.NOT_LOGIN_ERROR), null);
                return tSExecuteBatchStatementResp2;
            }
            List statements = req.getStatements();
            boolean isAllSuccessful = true;
            StringBuilder batchErrorMessage = new StringBuilder();
            for (String statement : statements) {
                long t2 = System.currentTimeMillis();
                isAllSuccessful = isAllSuccessful && this.executeStatementInBatch(statement, batchErrorMessage, result);
                Measurement.INSTANCE.addOperationLatency(Operation.EXECUTE_ONE_SQL_IN_BATCH, t2);
            }
            if (isAllSuccessful) {
                tSExecuteBatchStatementResp = this.getTSBatchExecuteStatementResp(this.getStatus(TSStatusCode.SUCCESS_STATUS, "Execute batch statements successfully"), result);
                return tSExecuteBatchStatementResp;
            }
            tSExecuteBatchStatementResp = this.getTSBatchExecuteStatementResp(this.getStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR, batchErrorMessage.toString()), result);
            return tSExecuteBatchStatementResp;
        }
        finally {
            Measurement.INSTANCE.addOperationLatency(Operation.EXECUTE_JDBC_BATCH, t1);
        }
    }

    private boolean executeStatementInBatch(String statement, StringBuilder batchErrorMessage, List<Integer> result) {
        try {
            PhysicalPlan physicalPlan = this.processor.parseSQLToPhysicalPlan(statement, this.zoneIds.get());
            if (physicalPlan.isQuery()) {
                throw new QueryInBatchStatementException(statement);
            }
            TSExecuteStatementResp resp = this.executeUpdateStatement(physicalPlan);
            if (resp.getStatus().getStatusType().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                result.add(-3);
                batchErrorMessage.append(resp.getStatus().getStatusType().getCode()).append("\n");
                return false;
            }
            result.add(-2);
        }
        catch (MetadataException e) {
            logger.error("Error occurred when executing {}, check metadata error: ", (Object)statement, (Object)e);
            result.add(-3);
            batchErrorMessage.append(TSStatusCode.METADATA_ERROR.getStatusCode()).append("\n");
            return false;
        }
        catch (QueryProcessException e) {
            logger.error("Error occurred when executing {}, meet error while parsing SQL to physical plan: ", (Object)statement, (Object)e);
            result.add(-3);
            batchErrorMessage.append(TSStatusCode.SQL_PARSE_ERROR.getStatusCode()).append("\n");
            return false;
        }
        catch (QueryInBatchStatementException e) {
            logger.error("Error occurred when executing {}, query statement not allowed: ", (Object)statement, (Object)e);
            result.add(-3);
            batchErrorMessage.append(TSStatusCode.QUERY_NOT_ALLOWED.getStatusCode()).append("\n");
            return false;
        }
        return true;
    }

    public TSExecuteStatementResp executeStatement(TSExecuteStatementReq req) {
        long startTime = System.currentTimeMillis();
        try {
            if (!this.checkLogin()) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                return this.getTSExecuteStatementResp(this.getStatus(TSStatusCode.NOT_LOGIN_ERROR));
            }
            String statement = req.getStatement();
            if (this.execAdminCommand(statement)) {
                return this.getTSExecuteStatementResp(this.getStatus(TSStatusCode.SUCCESS_STATUS, "ADMIN_COMMAND_SUCCESS"));
            }
            if (this.execShowFlushInfo(statement)) {
                String msg = String.format("There are %d flush tasks, %d flush tasks are in execution and %d flush tasks are waiting for execution.", FlushTaskPoolManager.getInstance().getTotalTasks(), FlushTaskPoolManager.getInstance().getWorkingTasksNumber(), FlushTaskPoolManager.getInstance().getWaitingTasksNumber());
                return this.getTSExecuteStatementResp(this.getStatus(TSStatusCode.SUCCESS_STATUS, msg));
            }
            if (this.execShowDynamicParameters(statement)) {
                String msg = String.format("Memtable size threshold: %dB, Memtable number: %d, Tsfile size threshold: %dB, Compression ratio: %f, Storage group number: %d, Timeseries number: %d, Maximal timeseries number among storage groups: %d", IoTDBDescriptor.getInstance().getConfig().getMemtableSizeThreshold(), IoTDBDescriptor.getInstance().getConfig().getMaxMemtableNumber(), IoTDBDescriptor.getInstance().getConfig().getTsFileSizeThreshold(), CompressionRatio.getInstance().getRatio(), MManager.getInstance().getAllStorageGroupNames().size(), IoTDBConfigDynamicAdapter.getInstance().getTotalTimeseries(), MManager.getInstance().getMaximalSeriesNumberAmongStorageGroups());
                return this.getTSExecuteStatementResp(this.getStatus(TSStatusCode.SUCCESS_STATUS, msg));
            }
            if (this.execSetConsistencyLevel(statement)) {
                return this.getTSExecuteStatementResp(this.getStatus(TSStatusCode.SUCCESS_STATUS, "Execute set consistency level successfully"));
            }
            PhysicalPlan physicalPlan = this.processor.parseSQLToPhysicalPlan(statement, this.zoneIds.get());
            if (physicalPlan.isQuery()) {
                TSExecuteStatementResp resp = this.executeQueryStatement(req.statementId, physicalPlan);
                long endTime = System.currentTimeMillis();
                SqlArgument sqlArgument = new SqlArgument(resp, physicalPlan, statement, startTime, endTime);
                sqlArgumentsList.add(sqlArgument);
                if (sqlArgumentsList.size() > 200) {
                    for (int i = 0; i < 50; ++i) {
                        sqlArgumentsList.remove(0);
                    }
                }
                return resp;
            }
            return this.executeUpdateStatement(physicalPlan);
        }
        catch (MetadataException e) {
            logger.error("check metadata error: ", (Throwable)e);
            return this.getTSExecuteStatementResp(this.getStatus(TSStatusCode.METADATA_ERROR, "Check metadata error: " + e.getMessage()));
        }
        catch (SQLException | QueryProcessException e) {
            logger.error("meet error while parsing SQL to physical plan: ", (Throwable)e);
            return this.getTSExecuteStatementResp(this.getStatus(TSStatusCode.SQL_PARSE_ERROR, "Statement format is not right: " + e.getMessage()));
        }
        catch (StorageEngineException e) {
            logger.error("meet error while parsing SQL to physical plan: ", (Throwable)e);
            return this.getTSExecuteStatementResp(this.getStatus(TSStatusCode.READ_ONLY_SYSTEM_ERROR, e.getMessage()));
        }
    }

    private boolean execShowFlushInfo(String statement) {
        if (statement == null) {
            return false;
        }
        statement = statement.toLowerCase().trim();
        return Pattern.matches("show\\s+flush\\s+task\\s+info", statement);
    }

    private boolean execShowDynamicParameters(String statement) {
        if (statement == null) {
            return false;
        }
        statement = statement.toLowerCase().trim();
        return Pattern.matches("show\\s+dynamic\\s+parameters", statement);
    }

    private boolean execSetConsistencyLevel(String statement) throws SQLException {
        if (statement == null) {
            return false;
        }
        if (Pattern.matches("set\\s+read.*level.*", statement = statement.toLowerCase().trim())) {
            throw new SQLException("IoTDB Stand-alone version does not support setting read-insert consistency level");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TSExecuteStatementResp executeQueryStatement(long statementId, PhysicalPlan plan) {
        long t1 = System.currentTimeMillis();
        try {
            TSExecuteStatementResp resp = plan instanceof AuthorPlan ? this.executeAuthQuery(plan) : (plan instanceof ShowTTLPlan ? this.executeShowTTL() : this.executeDataQuery(plan));
            if (plan.getOperatorType() == Operator.OperatorType.AGGREGATION) {
                resp.setIgnoreTimeStamp(true);
            }
            resp.setOperationType(plan.getOperatorType().toString());
            long queryId = this.generateQueryId();
            Set queryIdSet = this.statementId2QueryId.get().computeIfAbsent(statementId, k -> new HashSet());
            queryIdSet.add(queryId);
            TSHandleIdentifier operationId = new TSHandleIdentifier(ByteBuffer.wrap(this.username.get().getBytes()), ByteBuffer.wrap("PASS".getBytes()), queryId);
            TSOperationHandle operationHandle = new TSOperationHandle(operationId, true);
            resp.setOperationHandle(operationHandle);
            this.recordANewQuery(operationId.queryId, plan);
            TSExecuteStatementResp tSExecuteStatementResp = resp;
            return tSExecuteStatementResp;
        }
        catch (Exception e) {
            logger.error("{}: Internal server error: ", (Object)"IoTDB", (Object)e);
            TSExecuteStatementResp tSExecuteStatementResp = this.getTSExecuteStatementResp(this.getStatus(TSStatusCode.INTERNAL_SERVER_ERROR, e.getMessage()));
            return tSExecuteStatementResp;
        }
        finally {
            Measurement.INSTANCE.addOperationLatency(Operation.EXECUTE_QUERY, t1);
        }
    }

    public TSExecuteStatementResp executeQueryStatement(TSExecuteStatementReq req) {
        PhysicalPlan physicalPlan;
        if (!this.checkLogin()) {
            logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
            return this.getTSExecuteStatementResp(this.getStatus(TSStatusCode.NOT_LOGIN_ERROR));
        }
        String statement = req.getStatement();
        try {
            physicalPlan = this.processor.parseSQLToPhysicalPlan(statement, this.zoneIds.get());
        }
        catch (MetadataException | QueryProcessException e) {
            logger.error("meet error while parsing SQL to physical plan!", (Throwable)e);
            return this.getTSExecuteStatementResp(this.getStatus(TSStatusCode.SQL_PARSE_ERROR, e.getMessage()));
        }
        if (!physicalPlan.isQuery()) {
            return this.getTSExecuteStatementResp(this.getStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR, "Statement is not a query statement."));
        }
        return this.executeQueryStatement(req.statementId, physicalPlan);
    }

    private List<String> queryColumnsType(List<String> columns) throws QueryProcessException {
        ArrayList<String> columnTypes = new ArrayList<String>();
        for (String column : columns) {
            columnTypes.add(TSServiceImpl.getSeriesType(column).toString());
        }
        return columnTypes;
    }

    private TSExecuteStatementResp executeShowTTL() {
        TSExecuteStatementResp resp = this.getTSExecuteStatementResp(this.getStatus(TSStatusCode.SUCCESS_STATUS));
        resp.setIgnoreTimeStamp(true);
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<String> columnTypes = new ArrayList<String>();
        columns.add("storage group");
        columns.add("ttl");
        columnTypes.add(TSDataType.TEXT.toString());
        columnTypes.add(TSDataType.INT64.toString());
        resp.setColumns(columns);
        resp.setDataTypeList(columnTypes);
        return resp;
    }

    private TSExecuteStatementResp executeAuthQuery(PhysicalPlan plan) {
        TSExecuteStatementResp resp = this.getTSExecuteStatementResp(this.getStatus(TSStatusCode.SUCCESS_STATUS));
        resp.setIgnoreTimeStamp(true);
        AuthorPlan authorPlan = (AuthorPlan)plan;
        ArrayList<String> columnsName = new ArrayList<String>();
        ArrayList<String> columnsType = new ArrayList<String>();
        switch (authorPlan.getAuthorType()) {
            case LIST_ROLE: 
            case LIST_USER_ROLES: {
                columnsName.add("role");
                columnsType.add(TSDataType.TEXT.toString());
                break;
            }
            case LIST_USER: 
            case LIST_ROLE_USERS: {
                columnsName.add("user");
                columnsType.add(TSDataType.TEXT.toString());
                break;
            }
            case LIST_ROLE_PRIVILEGE: {
                columnsName.add("privilege");
                columnsType.add(TSDataType.TEXT.toString());
                break;
            }
            case LIST_USER_PRIVILEGE: {
                columnsName.add("role");
                columnsName.add("privilege");
                columnsType.add(TSDataType.TEXT.toString());
                columnsType.add(TSDataType.TEXT.toString());
                break;
            }
            default: {
                return this.getTSExecuteStatementResp(this.getStatus(TSStatusCode.SQL_PARSE_ERROR, String.format("%s is not an auth query", new Object[]{authorPlan.getAuthorType()})));
            }
        }
        resp.setColumns(columnsName);
        resp.setDataTypeList(columnsType);
        return resp;
    }

    private TSExecuteStatementResp executeDataQuery(PhysicalPlan plan) throws AuthException, TException, QueryProcessException {
        List<Path> paths = plan.getPaths();
        ArrayList<String> respColumns = new ArrayList<String>();
        if (paths.isEmpty()) {
            return this.getTSExecuteStatementResp(this.getStatus(TSStatusCode.TIMESERIES_NOT_EXIST_ERROR));
        }
        try {
            this.checkFileLevelSet(paths);
        }
        catch (StorageGroupException e) {
            logger.error("meet error while checking file level.", (Throwable)e);
            return this.getTSExecuteStatementResp(this.getStatus(TSStatusCode.CHECK_FILE_LEVEL_ERROR, e.getMessage()));
        }
        if (!this.checkAuthorization(paths, plan)) {
            return this.getTSExecuteStatementResp(this.getStatus(TSStatusCode.NO_PERMISSION_ERROR));
        }
        TSExecuteStatementResp resp = this.getTSExecuteStatementResp(this.getStatus(TSStatusCode.SUCCESS_STATUS));
        if (((QueryPlan)plan).isGroupByDevice()) {
            List<String> measurementColumns = ((QueryPlan)plan).getMeasurementColumnList();
            respColumns.add("Device");
            respColumns.addAll(measurementColumns);
            resp.setColumns(respColumns);
            ArrayList<String> columnsType = new ArrayList<String>();
            columnsType.add(TSDataType.TEXT.toString());
            ArrayList<TSDataType> deduplicatedColumnsType = new ArrayList<TSDataType>();
            deduplicatedColumnsType.add(TSDataType.TEXT);
            ArrayList<String> deduplicatedMeasurementColumns = new ArrayList<String>();
            HashSet<String> tmpColumnSet = new HashSet<String>();
            Map<String, TSDataType> checker = ((QueryPlan)plan).getDataTypeConsistencyChecker();
            for (String column : measurementColumns) {
                TSDataType dataType = checker.get(column);
                columnsType.add(dataType.toString());
                if (tmpColumnSet.contains(column)) continue;
                tmpColumnSet.add(column);
                deduplicatedMeasurementColumns.add(column);
                deduplicatedColumnsType.add(dataType);
            }
            resp.setDataTypeList(columnsType);
            ((QueryPlan)plan).setMeasurementColumnList(deduplicatedMeasurementColumns);
            ((QueryPlan)plan).setDataTypes(deduplicatedColumnsType);
            ((QueryPlan)plan).setPaths(null);
            ((QueryPlan)plan).setDataTypeConsistencyChecker(null);
        } else {
            switch (plan.getOperatorType()) {
                case QUERY: 
                case FILL: {
                    for (Path p : paths) {
                        respColumns.add(p.getFullPath());
                    }
                    break;
                }
                case AGGREGATION: 
                case GROUPBY: {
                    int i;
                    List<String> aggregations = plan.getAggregations();
                    if (aggregations.size() != paths.size()) {
                        for (i = 1; i < paths.size(); ++i) {
                            aggregations.add(aggregations.get(0));
                        }
                    }
                    for (i = 0; i < paths.size(); ++i) {
                        respColumns.add(aggregations.get(i) + "(" + paths.get(i).getFullPath() + ")");
                    }
                    break;
                }
                default: {
                    throw new TException("unsupported query type: " + (Object)((Object)plan.getOperatorType()));
                }
            }
            resp.setColumns(respColumns);
            resp.setDataTypeList(this.queryColumnsType(respColumns));
        }
        return resp;
    }

    private void checkFileLevelSet(List<Path> paths) throws StorageGroupException {
        MManager.getInstance().checkFileLevel(paths);
    }

    public TSFetchResultsResp fetchResults(TSFetchResultsReq req) {
        try {
            boolean hasResultSet;
            TSQueryDataSet result;
            LocalFileAuthorizer authorizer;
            if (!this.checkLogin()) {
                return this.getTSFetchResultsResp(this.getStatus(TSStatusCode.NOT_LOGIN_ERROR));
            }
            long queryId = req.queryId;
            if (!this.operationStatus.get().containsKey(queryId)) {
                return this.getTSFetchResultsResp(this.getStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR, "Has not executed statement"));
            }
            QueryDataSet queryDataSet = !this.queryDataSets.get().containsKey(queryId) ? this.createNewDataSet(queryId, req) : this.queryDataSets.get().get(queryId);
            int fetchSize = req.getFetch_size();
            try {
                authorizer = LocalFileAuthorizer.getInstance();
            }
            catch (AuthException e) {
                throw new TException((Throwable)e);
            }
            if (this.config.isEnableWatermark() && authorizer.isUserUseWaterMark(this.username.get())) {
                if (!this.config.getWatermarkMethodName().equals("GroupBasedLSBMethod")) {
                    throw new UnSupportedDataTypeException(String.format("Watermark method is not supported yet: %s", this.config.getWatermarkMethodName()));
                }
                GroupedLSBWatermarkEncoder encoder = new GroupedLSBWatermarkEncoder(this.config);
                result = QueryDataSetUtils.convertQueryDataSetByFetchSize(queryDataSet, fetchSize, encoder);
            } else {
                result = QueryDataSetUtils.convertQueryDataSetByFetchSize(queryDataSet, fetchSize);
            }
            boolean bl = hasResultSet = result.getRowCount() != 0;
            if (!hasResultSet && this.queryDataSets.get() != null) {
                this.queryDataSets.get().remove(queryId);
            }
            TSFetchResultsResp resp = this.getTSFetchResultsResp(this.getStatus(TSStatusCode.SUCCESS_STATUS, "FetchResult successfully. Has more result: " + hasResultSet));
            resp.setHasResultSet(hasResultSet);
            resp.setQueryDataSet(result);
            return resp;
        }
        catch (Exception e) {
            logger.error("{}: Internal server error: ", (Object)"IoTDB", (Object)e);
            return this.getTSFetchResultsResp(this.getStatus(TSStatusCode.INTERNAL_SERVER_ERROR, e.getMessage()));
        }
    }

    private QueryDataSet createNewDataSet(long queryId, TSFetchResultsReq req) throws QueryProcessException, QueryFilterOptimizationException, StorageEngineException, IOException {
        PhysicalPlan physicalPlan = this.operationStatus.get().get(queryId);
        QueryContext context = new QueryContext(QueryResourceManager.getInstance().assignJobId());
        this.initContextMap();
        this.contextMapLocal.get().put(req.queryId, context);
        QueryDataSet queryDataSet = this.processor.getExecutor().processQuery(physicalPlan, context);
        this.queryDataSets.get().put(req.queryId, queryDataSet);
        return queryDataSet;
    }

    private void initContextMap() {
        Map<Long, QueryContext> contextMap = this.contextMapLocal.get();
        if (contextMap == null) {
            contextMap = new HashMap<Long, QueryContext>();
            this.contextMapLocal.set(contextMap);
        }
    }

    public TSExecuteStatementResp executeUpdateStatement(TSExecuteStatementReq req) {
        try {
            if (!this.checkLogin()) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                return this.getTSExecuteStatementResp(this.getStatus(TSStatusCode.NOT_LOGIN_ERROR));
            }
            String statement = req.getStatement();
            return this.executeUpdateStatement(statement);
        }
        catch (Exception e) {
            logger.error("{}: server Internal Error: ", (Object)"IoTDB", (Object)e);
            return this.getTSExecuteStatementResp(this.getStatus(TSStatusCode.INTERNAL_SERVER_ERROR, e.getMessage()));
        }
    }

    private TSExecuteStatementResp executeUpdateStatement(PhysicalPlan plan) {
        TSStatus status = this.checkAuthority(plan);
        if (status != null) {
            return new TSExecuteStatementResp(status);
        }
        status = this.executePlan(plan);
        TSExecuteStatementResp resp = this.getTSExecuteStatementResp(status);
        long queryId = this.generateQueryId();
        TSHandleIdentifier operationId = new TSHandleIdentifier(ByteBuffer.wrap(this.username.get().getBytes()), ByteBuffer.wrap("PASS".getBytes()), queryId);
        TSOperationHandle operationHandle = new TSOperationHandle(operationId, false);
        resp.setOperationHandle(operationHandle);
        return resp;
    }

    private boolean executeNonQuery(PhysicalPlan plan) throws QueryProcessException {
        if (IoTDBDescriptor.getInstance().getConfig().isReadOnly()) {
            throw new QueryProcessException("Current system mode is read-only, does not support non-query operation");
        }
        return this.processor.getExecutor().processNonQuery(plan);
    }

    private TSExecuteStatementResp executeUpdateStatement(String statement) {
        PhysicalPlan physicalPlan;
        try {
            physicalPlan = this.processor.parseSQLToPhysicalPlan(statement, this.zoneIds.get());
        }
        catch (MetadataException | QueryProcessException e) {
            logger.error("meet error while parsing SQL to physical plan!", (Throwable)e);
            return this.getTSExecuteStatementResp(this.getStatus(TSStatusCode.SQL_PARSE_ERROR, e.getMessage()));
        }
        if (physicalPlan.isQuery()) {
            return this.getTSExecuteStatementResp(this.getStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR, "Statement is a query statement."));
        }
        return this.executeUpdateStatement(physicalPlan);
    }

    private void recordANewQuery(long queryId, PhysicalPlan physicalPlan) {
        this.operationStatus.get().put(queryId, physicalPlan);
    }

    private boolean checkLogin() {
        return this.username.get() != null;
    }

    private boolean checkAuthorization(List<Path> paths, PhysicalPlan plan) throws AuthException {
        String targetUser = null;
        if (plan instanceof AuthorPlan) {
            targetUser = ((AuthorPlan)plan).getUserName();
        }
        return AuthorityChecker.check(this.username.get(), paths, plan.getOperatorType(), targetUser);
    }

    private TSExecuteStatementResp getTSExecuteStatementResp(TSStatus status) {
        TSExecuteStatementResp resp = new TSExecuteStatementResp();
        TSStatus tsStatus = new TSStatus(status);
        resp.setStatus(tsStatus);
        TSHandleIdentifier operationId = new TSHandleIdentifier(ByteBuffer.wrap(this.username.get().getBytes()), ByteBuffer.wrap("PASS".getBytes()), this.generateQueryId());
        TSOperationHandle operationHandle = new TSOperationHandle(operationId, false);
        resp.setOperationHandle(operationHandle);
        return resp;
    }

    private TSExecuteBatchStatementResp getTSBatchExecuteStatementResp(TSStatus status, List<Integer> result) {
        TSExecuteBatchStatementResp resp = new TSExecuteBatchStatementResp();
        TSStatus tsStatus = new TSStatus(status);
        resp.setStatus(tsStatus);
        resp.setResult(result);
        return resp;
    }

    private TSFetchResultsResp getTSFetchResultsResp(TSStatus status) {
        TSFetchResultsResp resp = new TSFetchResultsResp();
        TSStatus tsStatus = new TSStatus(status);
        resp.setStatus(tsStatus);
        return resp;
    }

    void handleClientExit() {
        this.closeSession(null);
    }

    public TSGetTimeZoneResp getTimeZone() {
        TSGetTimeZoneResp resp;
        try {
            TSStatus tsStatus = new TSStatus(this.getStatus(TSStatusCode.SUCCESS_STATUS));
            resp = new TSGetTimeZoneResp(tsStatus, this.zoneIds.get().toString());
        }
        catch (Exception e) {
            logger.error("meet error while generating time zone.", (Throwable)e);
            TSStatus tsStatus = this.getStatus(TSStatusCode.GENERATE_TIME_ZONE_ERROR);
            resp = new TSGetTimeZoneResp(tsStatus, "Unknown time zone");
        }
        return resp;
    }

    public TSStatus setTimeZone(TSSetTimeZoneReq req) {
        TSStatus tsStatus;
        try {
            String timeZoneID = req.getTimeZone();
            this.zoneIds.set(ZoneId.of(timeZoneID));
            tsStatus = new TSStatus(this.getStatus(TSStatusCode.SUCCESS_STATUS));
        }
        catch (Exception e) {
            logger.error("meet error while setting time zone.", (Throwable)e);
            tsStatus = this.getStatus(TSStatusCode.SET_TIME_ZONE_ERROR);
        }
        return new TSStatus(tsStatus);
    }

    public ServerProperties getProperties() {
        ServerProperties properties = new ServerProperties();
        properties.setVersion("0.9.0");
        properties.setSupportedTimeAggregationOperations(new ArrayList());
        properties.getSupportedTimeAggregationOperations().add("max_time");
        properties.getSupportedTimeAggregationOperations().add("min_time");
        properties.setTimestampPrecision(IoTDBDescriptor.getInstance().getConfig().getTimestampPrecision());
        return properties;
    }

    public TSExecuteStatementResp insert(TSInsertionReq req) {
        if (!this.checkLogin()) {
            logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
            return this.getTSExecuteStatementResp(this.getStatus(TSStatusCode.NOT_LOGIN_ERROR));
        }
        long stmtId = req.getStmtId();
        InsertPlan plan = (InsertPlan)this.operationStatus.get().computeIfAbsent(stmtId, k -> new InsertPlan());
        if (req.isSetDeviceId()) {
            plan.setDeviceId(req.getDeviceId());
        }
        if (req.isSetTimestamp()) {
            plan.setTime(req.getTimestamp());
        }
        if (req.isSetMeasurements()) {
            plan.setMeasurements(req.getMeasurements().toArray(new String[0]));
        }
        if (req.isSetValues()) {
            plan.setValues(req.getValues().toArray(new String[0]));
        }
        try {
            return this.executeUpdateStatement(plan);
        }
        catch (Exception e) {
            logger.info("meet error while executing an insertion into {}", (Object)req.getDeviceId(), (Object)e);
            return this.getTSExecuteStatementResp(this.getStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR, e.getMessage()));
        }
    }

    public TSStatus insertRow(TSInsertReq req) {
        if (!this.checkLogin()) {
            logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
            return new TSStatus(this.getStatus(TSStatusCode.NOT_LOGIN_ERROR));
        }
        InsertPlan plan = new InsertPlan();
        plan.setDeviceId(req.getDeviceId());
        plan.setTime(req.getTimestamp());
        plan.setMeasurements(req.getMeasurements().toArray(new String[0]));
        plan.setValues(req.getValues().toArray(new String[0]));
        TSStatus status = this.checkAuthority(plan);
        if (status != null) {
            return new TSStatus(status);
        }
        return new TSStatus(this.executePlan(plan));
    }

    public TSStatus deleteData(TSDeleteDataReq req) {
        if (!this.checkLogin()) {
            logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
            return new TSStatus(this.getStatus(TSStatusCode.NOT_LOGIN_ERROR));
        }
        DeletePlan plan = new DeletePlan();
        plan.setDeleteTime(req.getTimestamp());
        ArrayList<Path> paths = new ArrayList<Path>();
        for (String path : req.getPaths()) {
            paths.add(new Path(path));
        }
        plan.addPaths(paths);
        TSStatus status = this.checkAuthority(plan);
        if (status != null) {
            return new TSStatus(status);
        }
        return new TSStatus(this.executePlan(plan));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TSExecuteBatchStatementResp insertBatch(TSBatchInsertionReq req) {
        long t1 = System.currentTimeMillis();
        try {
            TSExecuteBatchStatementResp tSExecuteBatchStatementResp;
            TSExecuteBatchStatementResp results;
            if (!this.checkLogin()) {
                logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
                TSExecuteBatchStatementResp tSExecuteBatchStatementResp2 = this.getTSBatchExecuteStatementResp(this.getStatus(TSStatusCode.NOT_LOGIN_ERROR), null);
                return tSExecuteBatchStatementResp2;
            }
            BatchInsertPlan batchInsertPlan = new BatchInsertPlan(req.deviceId, req.measurements);
            batchInsertPlan.setTimes(QueryDataSetUtils.readTimesFromBuffer(req.timestamps, req.size));
            batchInsertPlan.setColumns(QueryDataSetUtils.readValuesFromBuffer(req.values, req.types, req.measurements.size(), req.size));
            batchInsertPlan.setRowCount(req.size);
            batchInsertPlan.setTimeBuffer(req.timestamps);
            batchInsertPlan.setValueBuffer(req.values);
            batchInsertPlan.setDataTypes(req.types);
            boolean isAllSuccessful = true;
            TSStatus status = this.checkAuthority(batchInsertPlan);
            if (status != null) {
                TSExecuteBatchStatementResp tSExecuteBatchStatementResp3 = new TSExecuteBatchStatementResp(status);
                return tSExecuteBatchStatementResp3;
            }
            for (Integer result : results = this.processor.getExecutor().insertBatch(batchInsertPlan)) {
                if (result.intValue() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) continue;
                isAllSuccessful = false;
                break;
            }
            if (isAllSuccessful) {
                logger.debug("Insert one RowBatch successfully");
                tSExecuteBatchStatementResp = this.getTSBatchExecuteStatementResp(this.getStatus(TSStatusCode.SUCCESS_STATUS), Arrays.asList(results));
                return tSExecuteBatchStatementResp;
            }
            logger.debug("Insert one RowBatch failed!");
            tSExecuteBatchStatementResp = this.getTSBatchExecuteStatementResp(this.getStatus(TSStatusCode.INTERNAL_SERVER_ERROR), Arrays.asList(results));
            return tSExecuteBatchStatementResp;
        }
        catch (Exception e) {
            logger.error("{}: error occurs when executing statements", (Object)"IoTDB", (Object)e);
            TSExecuteBatchStatementResp tSExecuteBatchStatementResp = this.getTSBatchExecuteStatementResp(this.getStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR, e.getMessage()), null);
            return tSExecuteBatchStatementResp;
        }
        finally {
            Measurement.INSTANCE.addOperationLatency(Operation.EXECUTE_RPC_BATCH_INSERT, t1);
        }
    }

    public TSStatus setStorageGroup(String storageGroup) {
        if (!this.checkLogin()) {
            logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
            return new TSStatus(this.getStatus(TSStatusCode.NOT_LOGIN_ERROR));
        }
        SetStorageGroupPlan plan = new SetStorageGroupPlan(new Path(storageGroup));
        TSStatus status = this.checkAuthority(plan);
        if (status != null) {
            return new TSStatus(status);
        }
        return new TSStatus(this.executePlan(plan));
    }

    public TSStatus deleteStorageGroups(List<String> storageGroups) {
        if (!this.checkLogin()) {
            logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
            return new TSStatus(this.getStatus(TSStatusCode.NOT_LOGIN_ERROR));
        }
        ArrayList<Path> storageGroupList = new ArrayList<Path>();
        for (String storageGroup : storageGroups) {
            storageGroupList.add(new Path(storageGroup));
        }
        DeleteStorageGroupPlan plan = new DeleteStorageGroupPlan(storageGroupList);
        TSStatus status = this.checkAuthority(plan);
        if (status != null) {
            return new TSStatus(status);
        }
        return new TSStatus(this.executePlan(plan));
    }

    public TSStatus createTimeseries(TSCreateTimeseriesReq req) {
        if (!this.checkLogin()) {
            logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
            return new TSStatus(this.getStatus(TSStatusCode.NOT_LOGIN_ERROR));
        }
        CreateTimeSeriesPlan plan = new CreateTimeSeriesPlan(new Path(req.getPath()), TSDataType.values()[req.getDataType()], TSEncoding.values()[req.getEncoding()], CompressionType.values()[req.compressor], new HashMap<String, String>());
        TSStatus status = this.checkAuthority(plan);
        if (status != null) {
            return new TSStatus(status);
        }
        return new TSStatus(this.executePlan(plan));
    }

    public TSStatus deleteTimeseries(List<String> paths) {
        if (!this.checkLogin()) {
            logger.info(INFO_NOT_LOGIN, (Object)"IoTDB");
            return new TSStatus(this.getStatus(TSStatusCode.NOT_LOGIN_ERROR));
        }
        ArrayList<Path> pathList = new ArrayList<Path>();
        for (String path : paths) {
            pathList.add(new Path(path));
        }
        DeleteTimeSeriesPlan plan = new DeleteTimeSeriesPlan(pathList);
        TSStatus status = this.checkAuthority(plan);
        if (status != null) {
            return new TSStatus(status);
        }
        return new TSStatus(this.executePlan(plan));
    }

    public long requestStatementId() {
        long statementId = this.statementIdGenerator.get();
        this.statementIdGenerator.set(statementId + 1L);
        return statementId;
    }

    private TSStatus checkAuthority(PhysicalPlan plan) {
        List<Path> paths = plan.getPaths();
        try {
            if (!this.checkAuthorization(paths, plan)) {
                return this.getStatus(TSStatusCode.NO_PERMISSION_ERROR, plan.getOperatorType().toString());
            }
        }
        catch (AuthException e) {
            logger.error("meet error while checking authorization.", (Throwable)e);
            return this.getStatus(TSStatusCode.UNINITIALIZED_AUTH_ERROR, e.getMessage());
        }
        return null;
    }

    private TSStatus executePlan(PhysicalPlan plan) {
        boolean execRet;
        try {
            execRet = this.executeNonQuery(plan);
        }
        catch (QueryProcessException e) {
            logger.debug("meet error while processing non-query. ", (Throwable)e);
            return new TSStatus(new TSStatusType(e.getErrorCode(), e.getMessage()));
        }
        return execRet ? this.getStatus(TSStatusCode.SUCCESS_STATUS, "Execute successfully") : this.getStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR);
    }

    private long generateQueryId() {
        long queryId = this.queryIdGenerator.get();
        this.queryIdGenerator.set(queryId + 1L);
        return queryId;
    }
}

