/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.tsfile.exception.filter.UnSupportFilterDataTypeException;
import org.apache.iotdb.tsfile.file.footer.ChunkGroupFooter;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetaData;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadataIndex;
import org.apache.iotdb.tsfile.file.metadata.TsDigest;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetaData;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.utils.BloomFilter;
import org.apache.iotdb.tsfile.utils.BytesUtils;

public class TsFileSketchTool {
    public static void main(String[] args) throws IOException {
        String filename = "test.tsfile";
        String outFile = "TsFile_sketch_view.txt";
        if (args.length == 1) {
            filename = args[0];
        } else if (args.length == 2) {
            filename = args[0];
            outFile = args[1];
        }
        System.out.println("TsFile path:" + filename);
        System.out.println("Sketch save path:" + outFile);
        PrintWriter pw = new PrintWriter(new FileWriter(outFile));
        long length = FSFactoryProducer.getFSFactory().getFile(filename).length();
        TsFileSketchTool.printlnBoth(pw, "-------------------------------- TsFile Sketch --------------------------------");
        TsFileSketchTool.printlnBoth(pw, "file path: " + filename);
        TsFileSketchTool.printlnBoth(pw, "file length: " + length);
        TsFileSequenceReader reader = new TsFileSequenceReader(filename);
        TsFileMetaData tsFileMetaData = reader.readFileMetadata();
        List tsDeviceMetadataIndexSortedList = tsFileMetaData.getDeviceMap().values().stream().sorted((x, y) -> (int)(x.getOffset() - y.getOffset())).collect(Collectors.toList());
        ArrayList chunkGroupMetaDataTmpList = new ArrayList();
        ArrayList<TsDeviceMetadata> tsDeviceMetadataSortedList = new ArrayList<TsDeviceMetadata>();
        for (TsDeviceMetadataIndex index : tsDeviceMetadataIndexSortedList) {
            TsDeviceMetadata deviceMetadata = reader.readTsDeviceMetaData(index);
            tsDeviceMetadataSortedList.add(deviceMetadata);
            chunkGroupMetaDataTmpList.addAll(deviceMetadata.getChunkGroupMetaDataList());
        }
        List chunkGroupMetaDataSortedList = chunkGroupMetaDataTmpList.stream().sorted((x, y) -> (int)(x.getStartOffsetOfChunkGroup() - y.getStartOffsetOfChunkGroup())).collect(Collectors.toList());
        StringBuilder str1 = new StringBuilder();
        for (int i = 0; i < 21; ++i) {
            str1.append("|");
        }
        TsFileSketchTool.printlnBoth(pw, "");
        TsFileSketchTool.printlnBoth(pw, String.format("%20s", "POSITION") + "|\tCONTENT");
        TsFileSketchTool.printlnBoth(pw, String.format("%20s", "--------") + " \t-------");
        TsFileSketchTool.printlnBoth(pw, String.format("%20d", 0) + "|\t[magic head] " + reader.readHeadMagic());
        TsFileSketchTool.printlnBoth(pw, String.format("%20d", "TsFile".getBytes().length) + "|\t[version number] " + reader.readVersionNumber());
        for (ChunkGroupMetaData chunkGroupMetaData : chunkGroupMetaDataSortedList) {
            TsFileSketchTool.printlnBoth(pw, str1.toString() + "\t[Chunk Group] of " + chunkGroupMetaData.getDeviceID() + " begins at pos " + chunkGroupMetaData.getStartOffsetOfChunkGroup() + ", ends at pos " + chunkGroupMetaData.getEndOffsetOfChunkGroup() + ", version:" + chunkGroupMetaData.getVersion() + ", num of Chunks:" + chunkGroupMetaData.getChunkMetaDataList().size());
            long chunkEndPos = 0L;
            for (ChunkMetaData chunkMetaData : chunkGroupMetaData.getChunkMetaDataList()) {
                TsFileSketchTool.printlnBoth(pw, String.format("%20d", chunkMetaData.getOffsetOfChunkHeader()) + "|\t[Chunk] of " + chunkMetaData.getMeasurementUid() + ", numOfPoints:" + chunkMetaData.getNumOfPoints() + ", time range:[" + chunkMetaData.getStartTime() + "," + chunkMetaData.getEndTime() + "], tsDataType:" + chunkMetaData.getTsDataType() + ", \n" + String.format("%20s", "") + " \t" + TsFileSketchTool.statisticByteBufferToString(chunkMetaData.getTsDataType(), chunkMetaData.getDigest()));
                TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t[marker] 1");
                TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t[ChunkHeader]");
                Chunk chunk = reader.readMemChunk(chunkMetaData);
                TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t" + chunk.getHeader().getNumOfPages() + " pages");
                chunkEndPos = chunkMetaData.getOffsetOfChunkHeader() + (long)chunk.getHeader().getSerializedSize() + (long)chunk.getHeader().getDataSize();
            }
            TsFileSketchTool.printlnBoth(pw, String.format("%20s", chunkEndPos) + "|\t[Chunk Group Footer]");
            ChunkGroupFooter chunkGroupFooter = reader.readChunkGroupFooter(chunkEndPos, false);
            TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t[marker] 0");
            TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t[deviceID] " + chunkGroupFooter.getDeviceID());
            TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t[dataSize] " + chunkGroupFooter.getDataSize());
            TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t[num of chunks] " + chunkGroupFooter.getNumberOfChunks());
            TsFileSketchTool.printlnBoth(pw, str1.toString() + "\t[Chunk Group] of " + chunkGroupMetaData.getDeviceID() + " ends");
        }
        TsFileSketchTool.printlnBoth(pw, String.format("%20s", ((TsDeviceMetadataIndex)tsDeviceMetadataIndexSortedList.get(0)).getOffset() - 1L) + "|\t[marker] 2");
        for (int i = 0; i < tsDeviceMetadataSortedList.size(); ++i) {
            TsDeviceMetadata tsDeviceMetadata = (TsDeviceMetadata)tsDeviceMetadataSortedList.get(i);
            TsDeviceMetadataIndex tsDeviceMetadataIndex = (TsDeviceMetadataIndex)tsDeviceMetadataIndexSortedList.get(i);
            TsFileSketchTool.printlnBoth(pw, String.format("%20s", tsDeviceMetadataIndex.getOffset()) + "|\t[TsDeviceMetadata] of " + ((ChunkGroupMetaData)tsDeviceMetadata.getChunkGroupMetaDataList().get(0)).getDeviceID() + ", startTime:" + tsDeviceMetadataIndex.getStartTime() + ", endTime:" + tsDeviceMetadataIndex.getEndTime());
            TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t[startTime] " + tsDeviceMetadata.getStartTime());
            TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t[endTime] " + tsDeviceMetadata.getEndTime());
            TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t[num of ChunkGroupMetaData] " + tsDeviceMetadata.getChunkGroupMetaDataList().size());
            TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t" + tsDeviceMetadata.getChunkGroupMetaDataList().size() + " ChunkGroupMetaData");
        }
        TsFileSketchTool.printlnBoth(pw, String.format("%20s", reader.getFileMetadataPos()) + "|\t[TsFileMetaData]");
        TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t[num of devices] " + tsFileMetaData.getDeviceMap().size());
        TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t" + tsFileMetaData.getDeviceMap().size() + " key&TsDeviceMetadataIndex");
        TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t[num of measurements] " + tsFileMetaData.getMeasurementSchema().size());
        TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t" + tsFileMetaData.getMeasurementSchema().size() + " key&measurementSchema");
        boolean createByIsNotNull = tsFileMetaData.getCreatedBy() != null;
        TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t[createBy isNotNull] " + createByIsNotNull);
        if (createByIsNotNull) {
            TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t[createBy] " + tsFileMetaData.getCreatedBy());
        }
        TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t[totalChunkNum] " + tsFileMetaData.getTotalChunkNum());
        TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t[invalidChunkNum] " + tsFileMetaData.getInvalidChunkNum());
        BloomFilter bloomFilter = tsFileMetaData.getBloomFilter();
        TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t[bloom filter bit vector byte array length] " + bloomFilter.serialize().length);
        TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t[bloom filter bit vector byte array] ");
        TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t[bloom filter number of bits] " + bloomFilter.getSize());
        TsFileSketchTool.printlnBoth(pw, String.format("%20s", "") + "|\t\t[bloom filter number of hash functions] " + bloomFilter.getHashFunctionSize());
        TsFileSketchTool.printlnBoth(pw, String.format("%20s", reader.getFileMetadataPos() + (long)reader.getFileMetadataSize()) + "|\t[TsFileMetaDataSize] " + reader.getFileMetadataSize());
        TsFileSketchTool.printlnBoth(pw, String.format("%20s", reader.getFileMetadataPos() + (long)reader.getFileMetadataSize() + 4L) + "|\t[magic tail] " + reader.readTailMagic());
        TsFileSketchTool.printlnBoth(pw, String.format("%20s", length) + "|\tEND of TsFile");
        TsFileSketchTool.printlnBoth(pw, "");
        TsFileSketchTool.printlnBoth(pw, "---------------------------------- TsFile Sketch End ----------------------------------");
        pw.close();
    }

    private static void printlnBoth(PrintWriter pw, String str) {
        System.out.println(str);
        pw.println(str);
    }

    private static String statisticByteBufferToString(TSDataType tsDataType, TsDigest tsDigest) {
        ByteBuffer[] statistics = tsDigest.getStatistics();
        if (statistics == null) {
            return "TsDigest:[]";
        }
        StringBuilder str = new StringBuilder();
        str.append("TsDigest:[");
        for (int i = 0; i < statistics.length - 1; ++i) {
            ByteBuffer value = statistics[i];
            str.append(TsDigest.StatisticType.values()[i]);
            str.append(":");
            if (value == null) {
                str.append("null");
            } else {
                switch (tsDataType) {
                    case INT32: {
                        str.append(BytesUtils.bytesToInt((byte[])value.array()));
                        break;
                    }
                    case INT64: {
                        str.append(BytesUtils.bytesToLong((byte[])value.array()));
                        break;
                    }
                    case FLOAT: {
                        str.append(BytesUtils.bytesToFloat((byte[])value.array()));
                        break;
                    }
                    case DOUBLE: {
                        str.append(BytesUtils.bytesToDouble((byte[])value.array()));
                        break;
                    }
                    case TEXT: {
                        str.append(BytesUtils.bytesToString((byte[])value.array()));
                        break;
                    }
                    case BOOLEAN: {
                        str.append(BytesUtils.bytesToBool((byte[])value.array()));
                        break;
                    }
                    default: {
                        throw new UnSupportFilterDataTypeException("DigestForFilter unsupported datatype : " + tsDataType.toString());
                    }
                }
            }
            str.append(",");
        }
        str.append(TsDigest.StatisticType.values()[statistics.length - 1]);
        str.append(":");
        ByteBuffer value = statistics[statistics.length - 1];
        if (value == null) {
            str.append("null");
        } else {
            str.append(BytesUtils.bytesToDouble((byte[])value.array()));
        }
        str.append("]");
        return str.toString();
    }
}

