/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.logvisual;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.iotdb.db.tools.logvisual.LogEntry;
import org.apache.iotdb.db.tools.logvisual.LogFilter;
import org.apache.iotdb.db.tools.logvisual.LogParser;
import org.apache.iotdb.db.tools.logvisual.PatternLogParser;
import org.apache.iotdb.db.tools.logvisual.TimeSeriesStatistics;
import org.apache.iotdb.db.tools.logvisual.VisualizationPlan;
import org.apache.iotdb.db.tools.logvisual.exceptions.NoLogFileLoadedException;
import org.apache.iotdb.db.tools.logvisual.exceptions.UnmatchedContentException;
import org.apache.iotdb.db.tools.logvisual.exceptions.VisualizationException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogVisualizer {
    private static final Logger logger = LoggerFactory.getLogger(LogVisualizer.class);
    private LogParser logParser;
    private Map<String, VisualizationPlan> plans = new HashMap<String, VisualizationPlan>();
    private Map<String, JFreeChart> charts;
    private Map<String, List<TimeSeriesStatistics>> statisticsMap;
    private int groupNum = 0;
    private File parserPropertyFile;
    private File logFile;

    public static void main(String[] args) throws IOException, VisualizationException {
        if (args.length != 4) {
            System.out.println("Wrong number of parameters:  params: <LogFilePath> <ParserPropertyFilePath> <PlanFilePath> <OutputDirectory>");
            return;
        }
        File logFile = new File(args[0]);
        if (!logFile.exists()) {
            System.out.println("Log file does not exist");
            return;
        }
        File parserPropertyFile = new File(args[1]);
        if (!parserPropertyFile.exists() || !parserPropertyFile.isFile()) {
            System.out.println("Parser property file does not exist");
            return;
        }
        File planFile = new File(args[2]);
        if (!planFile.exists()) {
            System.out.println("Plan file does not exist");
            return;
        }
        File destDir = new File(args[3]);
        if (destDir.exists() && !destDir.isDirectory()) {
            System.out.println("The output path is not a directory");
            return;
        }
        destDir.mkdirs();
        LogVisualizer visualizer = new LogVisualizer();
        visualizer.setLogFile(logFile);
        visualizer.setParserPropertyFile(parserPropertyFile);
        visualizer.loadLogParser();
        visualizer.loadPlan(planFile);
        Collection<VisualizationPlan> plans = visualizer.listPlans();
        for (VisualizationPlan plan : plans) {
            visualizer.executePlan(plan);
            visualizer.saveResults(destDir.getPath() + File.separator + plan.getName());
            System.out.println("Executed and saved results of plan " + plan.getName());
        }
        System.out.println("Visualization completed");
    }

    public void loadLogParser() throws IOException {
        if (this.parserPropertyFile == null) {
            throw new IOException("Parser property file unset!");
        }
        if (this.logFile == null) {
            throw new IOException("Log file unset!");
        }
        this.close();
        ArrayList<String> logFilePaths = new ArrayList<String>();
        this.getLogFilePaths(this.logFile, logFilePaths);
        String propertyFilePath = this.parserPropertyFile.getPath();
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(propertyFilePath);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);){
            properties.load(bufferedInputStream);
        }
        this.logParser = new PatternLogParser(properties, logFilePaths.toArray(new String[logFilePaths.size()]));
    }

    private void getLogFilePaths(File currLogFile, List<String> logFilePaths) {
        if (!currLogFile.exists()) {
            return;
        }
        if (!currLogFile.isDirectory()) {
            logFilePaths.add(currLogFile.getPath());
        } else {
            File[] subFiles = currLogFile.listFiles();
            if (subFiles != null) {
                for (File subFile : subFiles) {
                    this.getLogFilePaths(subFile, logFilePaths);
                }
            }
        }
    }

    public void close() throws IOException {
        if (this.logParser != null) {
            this.logParser.close();
            this.logParser = null;
        }
    }

    public void loadPlans(File[] planFiles) throws IOException {
        for (File file : planFiles) {
            this.loadPlan(file);
        }
    }

    private void loadPlan(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            this.loadPlans(file.listFiles());
        } else {
            this.loadPlan(file.getPath());
        }
    }

    private void loadPlan(String planFilePath) throws IOException {
        VisualizationPlan plan = new VisualizationPlan(planFilePath);
        this.plans.put(plan.getName(), plan);
    }

    public Collection<VisualizationPlan> listPlans() {
        return this.plans.values();
    }

    public void executePlan(VisualizationPlan plan) throws VisualizationException {
        if (this.logParser == null) {
            throw new NoLogFileLoadedException();
        }
        List<LogEntry> logCache = this.collectLogs(plan);
        Map<List<String>, List<LogEntry>> logGroups = this.groupLogs(logCache);
        Map<String, Map<String, TimeSeries>> taggedTimeSeries = this.createTimeSeries(plan, logGroups);
        this.charts = this.drawCharts(taggedTimeSeries, plan);
        this.statisticsMap = this.genStatisticMap(taggedTimeSeries);
    }

    private List<LogEntry> collectLogs(VisualizationPlan plan) throws VisualizationException {
        ArrayList<LogEntry> logCache;
        block12: {
            try {
                this.logParser.reset();
            }
            catch (IOException e) {
                throw new VisualizationException(e);
            }
            logCache = new ArrayList<LogEntry>();
            LogFilter logFilter = plan.getLogFilter();
            try {
                LogEntry logEntry;
                while ((logEntry = this.logParser.next()) != null) {
                    try {
                        plan.parseContents(logEntry);
                    }
                    catch (UnmatchedContentException e) {
                        continue;
                    }
                    switch (logFilter.filter(logEntry)) {
                        case BEYOND_END_TIME: {
                            break block12;
                        }
                        case REJECT: {
                            break;
                        }
                        case OK: {
                            logCache.add(logEntry);
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new VisualizationException(e);
            }
        }
        logger.info("Collected {} logs from {}", (Object)logCache.size(), (Object)this.logFile.getPath());
        return logCache;
    }

    private Map<List<String>, List<LogEntry>> groupLogs(List<LogEntry> logCache) {
        HashMap<List<String>, List<LogEntry>> logGroups = new HashMap<List<String>, List<LogEntry>>();
        for (LogEntry logEntry : logCache) {
            logGroups.computeIfAbsent(logEntry.getTags(), tag -> new ArrayList()).add(logEntry);
        }
        logCache.clear();
        this.groupNum = logGroups.size();
        logger.info("Found {} different tags", (Object)this.groupNum);
        return logGroups;
    }

    private Map<String, Map<String, TimeSeries>> createTimeSeries(VisualizationPlan plan, Map<List<String>, List<LogEntry>> logGroups) {
        HashMap<String, Map<String, TimeSeries>> ret = new HashMap<String, Map<String, TimeSeries>>();
        for (Map.Entry<List<String>, List<LogEntry>> entry : logGroups.entrySet()) {
            String concatenatedTag;
            List<String> tags = entry.getKey();
            List<LogEntry> logs = entry.getValue();
            if (tags.isEmpty()) {
                concatenatedTag = plan.getName() + " ";
            } else {
                StringBuilder builder = new StringBuilder(plan.getName() + "-" + tags.get(0));
                for (int i = 1; i < tags.size(); ++i) {
                    builder.append(",").append(tags.get(i));
                }
                builder.append(" ");
                concatenatedTag = builder.toString();
            }
            if (plan.getMeasurementPositions() != null) {
                String[] legends = plan.getLegends();
                for (LogEntry logEntry : logs) {
                    List<Double> values = logEntry.getMeasurements();
                    for (int i = 0; i < values.size(); ++i) {
                        String legend = legends[i];
                        TimeSeries timeSeries = ret.computeIfAbsent(legend, leg -> new HashMap()).computeIfAbsent(concatenatedTag, tag -> new TimeSeries((Comparable)((Object)(tag + legend))));
                        timeSeries.addOrUpdate((RegularTimePeriod)new Millisecond(logEntry.getDate()), (Number)values.get(i));
                    }
                }
                continue;
            }
            String legend = "TimeOfOccurrence";
            TimeSeries timeOfOccurrence = ret.computeIfAbsent(legend, tag -> new HashMap()).computeIfAbsent(concatenatedTag, tag -> new TimeSeries((Comparable)((Object)(tag + legend))));
            for (LogEntry logEntry : logs) {
                timeOfOccurrence.addOrUpdate((RegularTimePeriod)new Millisecond(logEntry.getDate()), 1.0);
            }
        }
        return ret;
    }

    private Map<String, JFreeChart> drawCharts(Map<String, Map<String, TimeSeries>> taggedTimeSeries, VisualizationPlan plan) {
        HashMap<String, JFreeChart> charts = new HashMap<String, JFreeChart>();
        for (Map.Entry<String, Map<String, TimeSeries>> entry : taggedTimeSeries.entrySet()) {
            String measurementName = entry.getKey();
            TimeSeriesCollection timeSeriesList = new TimeSeriesCollection();
            for (TimeSeries timeSeries : entry.getValue().values()) {
                timeSeriesList.addSeries(timeSeries);
            }
            Date startDate = new Date((long)timeSeriesList.getDomainBounds(true).getLowerBound());
            JFreeChart chart = ChartFactory.createTimeSeriesChart((String)measurementName, (String)("time-" + startDate), (String)measurementName, (XYDataset)timeSeriesList);
            XYPlot xyPlot = chart.getXYPlot();
            XYLineAndShapeRenderer xyLineAndShapeRenderer = (XYLineAndShapeRenderer)xyPlot.getRenderer();
            xyLineAndShapeRenderer.setDefaultShapesVisible(true);
            xyLineAndShapeRenderer.setDefaultShapesFilled(true);
            if (plan.getMeasurementPositions() == null) {
                xyLineAndShapeRenderer.setDefaultLinesVisible(false);
            }
            charts.put(measurementName, chart);
        }
        return charts;
    }

    public Map<String, JFreeChart> getCharts() {
        return this.charts;
    }

    public void setParserPropertyFile(File parserPropertyFile) {
        this.parserPropertyFile = parserPropertyFile;
    }

    public void setLogFile(File logFile) {
        this.logFile = logFile;
    }

    private Map<String, List<TimeSeriesStatistics>> genStatisticMap(Map<String, Map<String, TimeSeries>> taggedTimeSeries) {
        HashMap<String, List<TimeSeriesStatistics>> ret = new HashMap<String, List<TimeSeriesStatistics>>();
        for (Map.Entry<String, Map<String, TimeSeries>> timeSeriesEntry : taggedTimeSeries.entrySet()) {
            String measurementName = timeSeriesEntry.getKey();
            ArrayList<TimeSeriesStatistics> seriesStatistics = new ArrayList<TimeSeriesStatistics>();
            Map<String, TimeSeries> seriesMap = timeSeriesEntry.getValue();
            for (TimeSeries timeSeries : seriesMap.values()) {
                seriesStatistics.add(new TimeSeriesStatistics(timeSeries));
            }
            ret.put(measurementName, seriesStatistics);
        }
        return ret;
    }

    public void saveResults(String destDirPath) throws VisualizationException {
        if (this.charts == null || this.statisticsMap == null) {
            throw new VisualizationException("No results to be saved");
        }
        File destDir = new File(destDirPath);
        if (destDir.exists() && !destDir.isDirectory()) {
            throw new VisualizationException(String.format("%s exists and is not a directory", destDirPath));
        }
        if (!destDir.exists() && !destDir.mkdirs()) {
            throw new VisualizationException(String.format("Cannot create directory %s", destDirPath));
        }
        for (Map.Entry<String, JFreeChart> chartEntry : this.charts.entrySet()) {
            File chartFile = new File(destDir, chartEntry.getKey() + ".png");
            JFreeChart chart = chartEntry.getValue();
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(chartFile);
                Object object = null;
                try {
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    Object object2 = null;
                    try {
                        ChartUtils.writeChartAsPNG((OutputStream)bufferedOutputStream, (JFreeChart)chart, (int)800, (int)600);
                    }
                    catch (Throwable throwable) {
                        object2 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (bufferedOutputStream == null) continue;
                        if (object2 != null) {
                            try {
                                bufferedOutputStream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object2).addSuppressed(throwable);
                            }
                            continue;
                        }
                        bufferedOutputStream.close();
                    }
                }
                catch (Throwable bufferedOutputStream) {
                    object = bufferedOutputStream;
                    throw bufferedOutputStream;
                }
                finally {
                    if (fileOutputStream == null) continue;
                    if (object != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Throwable bufferedOutputStream) {
                            ((Throwable)object).addSuppressed(bufferedOutputStream);
                        }
                        continue;
                    }
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                throw new VisualizationException(String.format("Cannot save chart of %s", chartEntry.getKey()), e);
            }
        }
        File statisticFile = new File(destDir, "statistic.csv");
        try (FileWriter fileWriter = new FileWriter(statisticFile);
             BufferedWriter writer = new BufferedWriter(fileWriter);){
            TimeSeriesStatistics.serializeHeader(writer);
            for (Map.Entry<String, List<TimeSeriesStatistics>> statisticEntry : this.statisticsMap.entrySet()) {
                for (TimeSeriesStatistics timeSeriesStatistics : statisticEntry.getValue()) {
                    timeSeriesStatistics.serialize(writer);
                }
            }
        }
        catch (IOException e) {
            throw new VisualizationException(String.format("Cannot save statistics to %s", destDirPath), e);
        }
    }

    public Map<String, List<TimeSeriesStatistics>> getStatisticsMap() {
        return this.statisticsMap;
    }

    public int getGroupNum() {
        return this.groupNum;
    }
}

