/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class TypeInferenceUtils {
    private TypeInferenceUtils() {
    }

    static boolean isNumber(String s) {
        try {
            Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static boolean isBoolean(String s) {
        return s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false");
    }

    public static TSDataType getPredictedDataType(Object value) {
        if (value instanceof Boolean || value instanceof String && TypeInferenceUtils.isBoolean((String)value)) {
            return TSDataType.BOOLEAN;
        }
        if (value instanceof Number || value instanceof String && TypeInferenceUtils.isNumber((String)value)) {
            String v = String.valueOf(value);
            if (!v.contains(".")) {
                return TSDataType.INT64;
            }
            return TSDataType.DOUBLE;
        }
        return TSDataType.TEXT;
    }
}

