/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.rescon.PrimitiveArrayPool;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class BooleanTVList
extends TVList {
    private List<boolean[]> values = new ArrayList<boolean[]>();
    private boolean[][] sortedValues;
    private boolean pivotValue;

    BooleanTVList() {
    }

    @Override
    public void putBoolean(long timestamp, boolean value) {
        this.checkExpansion();
        int arrayIndex = this.size / 128;
        int elementIndex = this.size % 128;
        this.minTime = this.minTime <= timestamp ? this.minTime : timestamp;
        ((long[])this.timestamps.get((int)arrayIndex))[elementIndex] = timestamp;
        this.values.get((int)arrayIndex)[elementIndex] = value;
        ++this.size;
        if (this.sorted && this.size > 1 && timestamp < this.getTime(this.size - 2)) {
            this.sorted = false;
        }
    }

    @Override
    public boolean getBoolean(int index) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int arrayIndex = index / 128;
        int elementIndex = index % 128;
        return this.values.get(arrayIndex)[elementIndex];
    }

    protected void set(int index, long timestamp, boolean value) {
        if (index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        int arrayIndex = index / 128;
        int elementIndex = index % 128;
        ((long[])this.timestamps.get((int)arrayIndex))[elementIndex] = timestamp;
        this.values.get((int)arrayIndex)[elementIndex] = value;
    }

    @Override
    public BooleanTVList clone() {
        BooleanTVList cloneList = new BooleanTVList();
        this.cloneAs(cloneList);
        for (boolean[] valueArray : this.values) {
            cloneList.values.add(this.cloneValue(valueArray));
        }
        return cloneList;
    }

    private boolean[] cloneValue(boolean[] array) {
        boolean[] cloneArray = new boolean[array.length];
        System.arraycopy(array, 0, cloneArray, 0, array.length);
        return cloneArray;
    }

    @Override
    public void sort() {
        if (this.sortedTimestamps == null || this.sortedTimestamps.length < this.size) {
            this.sortedTimestamps = (long[][])PrimitiveArrayPool.getInstance().getDataListsByType(TSDataType.INT64, this.size);
        }
        if (this.sortedValues == null || this.sortedValues.length < this.size) {
            this.sortedValues = (boolean[][])PrimitiveArrayPool.getInstance().getDataListsByType(TSDataType.BOOLEAN, this.size);
        }
        this.sort(0, this.size);
        this.clearSortedValue();
        this.clearSortedTime();
        this.sorted = true;
    }

    @Override
    void clearValue() {
        if (this.values != null) {
            for (boolean[] dataArray : this.values) {
                PrimitiveArrayPool.getInstance().release(dataArray);
            }
            this.values.clear();
        }
    }

    @Override
    void clearSortedValue() {
        if (this.sortedValues != null) {
            for (boolean[] dataArray : this.sortedValues) {
                PrimitiveArrayPool.getInstance().release(dataArray);
            }
            this.sortedValues = null;
        }
    }

    @Override
    protected void setFromSorted(int src, int dest) {
        this.set(dest, this.sortedTimestamps[src / 128][src % 128], this.sortedValues[src / 128][src % 128]);
    }

    @Override
    protected void set(int src, int dest) {
        long srcT = this.getTime(src);
        boolean srcV = this.getBoolean(src);
        this.set(dest, srcT, srcV);
    }

    @Override
    protected void setToSorted(int src, int dest) {
        this.sortedTimestamps[dest / 128][dest % 128] = this.getTime(src);
        this.sortedValues[dest / 128][dest % 128] = this.getBoolean(src);
    }

    @Override
    protected void reverseRange(int lo, int hi) {
        --hi;
        while (lo < hi) {
            long loT = this.getTime(lo);
            boolean loV = this.getBoolean(lo);
            long hiT = this.getTime(hi);
            boolean hiV = this.getBoolean(hi);
            this.set(lo++, hiT, hiV);
            this.set(hi--, loT, loV);
        }
    }

    @Override
    protected void expandValues() {
        this.values.add((boolean[])PrimitiveArrayPool.getInstance().getPrimitiveDataListByType(TSDataType.BOOLEAN));
    }

    @Override
    protected void saveAsPivot(int pos) {
        this.pivotTime = this.getTime(pos);
        this.pivotValue = this.getBoolean(pos);
    }

    @Override
    protected void setPivotTo(int pos) {
        this.set(pos, this.pivotTime, this.pivotValue);
    }

    @Override
    protected void releaseLastValueArray() {
        PrimitiveArrayPool.getInstance().release(this.values.remove(this.values.size() - 1));
    }

    @Override
    public void putBooleans(long[] time, boolean[] value) {
        this.checkExpansion();
        int idx = 0;
        int length = time.length;
        this.updateMinTimeAndSorted(time);
        while (idx < length) {
            int inputRemaining = length - idx;
            int arrayIdx = this.size / 128;
            int elementIdx = this.size % 128;
            int internalRemaining = 128 - elementIdx;
            if (internalRemaining >= inputRemaining) {
                System.arraycopy(time, idx, this.timestamps.get(arrayIdx), elementIdx, inputRemaining);
                System.arraycopy(value, idx, this.values.get(arrayIdx), elementIdx, inputRemaining);
                this.size += inputRemaining;
                break;
            }
            System.arraycopy(time, idx, this.timestamps.get(arrayIdx), elementIdx, internalRemaining);
            System.arraycopy(value, idx, this.values.get(arrayIdx), elementIdx, internalRemaining);
            idx += internalRemaining;
            this.size += internalRemaining;
            this.checkExpansion();
        }
    }
}

