/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf;

import java.io.File;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iotdb.db.engine.merge.selector.MergeFileStrategy;
import org.apache.iotdb.db.service.TSServiceImpl;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBConfig {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBConfig.class);
    static final String CONFIG_NAME = "iotdb-engine.properties";
    private static final String MULTI_DIR_STRATEGY_PREFIX = "org.apache.iotdb.db.conf.directories.strategy.";
    private static final String DEFAULT_MULTI_DIR_STRATEGY = "MaxDiskUsableSpaceFirstStrategy";
    private int metricsPort = 8181;
    public static final String WATERMARK_GROUPED_LSB = "GroupBasedLSBMethod";
    private String rpcAddress = "0.0.0.0";
    private boolean rpcThriftCompressionEnable = false;
    private int rpcPort = 6667;
    private int rpcMaxConcurrentClientNum = 65535;
    private long allocateMemoryForWrite = Runtime.getRuntime().maxMemory() * 6L / 10L;
    private long allocateMemoryForRead = Runtime.getRuntime().maxMemory() * 3L / 10L;
    private boolean enableParameterAdapter = true;
    private boolean enableWal = true;
    private volatile boolean readOnly = false;
    private int flushWalThreshold = 10000;
    private String timestampPrecision = "ms";
    private long forceWalPeriodInMs = 10L;
    private int walBufferSize = 0x1000000;
    private String baseDir = "data";
    private String systemDir = "data/system";
    private String schemaDir = "data/system/schema";
    private String queryDir = "data/query";
    private String[] dataDirs = new String[]{"data/data"};
    private String multiDirStrategyClassName = null;
    private String walFolder = "data/wal";
    private String indexFileDir = "data/index";
    private int maxMemtableNumber = 20;
    private int fetchSize = 10000;
    private int concurrentFlushThread = Runtime.getRuntime().availableProcessors();
    private ZoneId zoneID = ZoneId.systemDefault();
    private long tsFileSizeThreshold = 0x20000000L;
    private long memtableSizeThreshold = 0x8000000L;
    private boolean metaDataCacheEnable = true;
    private long allocateMemoryForFileMetaDataCache = this.allocateMemoryForRead * 3L / 19L;
    private long allocateMemoryForChumkMetaDataCache = this.allocateMemoryForRead * 6L / 19L;
    private int backLoopPeriodSec = 5;
    private boolean enableStatMonitor = false;
    private int statMonitorDetectFreqSec = 600;
    private int statMonitorRetainIntervalSec = 600;
    private int mManagerCacheSize = 400000;
    private boolean enableExternalSort = true;
    private int externalSortThreshold = 60;
    private boolean isSyncEnable = true;
    private int syncServerPort = 5555;
    private String languageVersion = "EN";
    private String ipWhiteList = "0.0.0.0/0";
    private long cacheFileReaderClearPeriod = 100000L;
    private String rpcImplClassName = TSServiceImpl.class.getName();
    private boolean enablePerformanceStat = false;
    private long performanceStatDisplayInterval = 60000L;
    private int performanceStatMemoryInKB = 20;
    private boolean chunkBufferPoolEnable = false;
    private boolean enableWatermark = false;
    private String watermarkSecretKey = "QWERTYUIOP*&=";
    private String watermarkBitString = "11001010010101";
    private String watermarkMethod = "GroupBasedLSBMethod(embed_row_cycle=5,embed_lsb_num=5)";
    private boolean enableAutoCreateSchema = false;
    private int defaultStorageGroupLevel = 2;
    private TSEncoding defaultBooleanEncoding = TSEncoding.RLE;
    private TSEncoding defaultInt32Encoding = TSEncoding.RLE;
    private TSEncoding defaultInt64Encoding = TSEncoding.RLE;
    private TSEncoding defaultFloatEncoding = TSEncoding.GORILLA;
    private TSEncoding defaultDoubleEncoding = TSEncoding.GORILLA;
    private TSEncoding defaultTextEncoding = TSEncoding.PLAIN;
    private long mergeMemoryBudget = (long)((double)Runtime.getRuntime().maxMemory() * 0.2);
    private int upgradeThreadNum = 1;
    private int mergeThreadNum = 1;
    private int mergeChunkSubThreadNum = 4;
    private long mergeFileSelectionTimeBudget = 30000L;
    private boolean continueMergeAfterReboot = true;
    private long mergeIntervalSec = 7200L;
    private boolean forceFullMerge = false;
    private int chunkMergePointThreshold = 20480;
    private MergeFileStrategy mergeFileStrategy = MergeFileStrategy.MAX_SERIES_NUM;
    private FSType systemFileStorageFs = FSType.LOCAL;
    private FSType tsFileStorageFs = FSType.LOCAL;
    private String coreSitePath = "/etc/hadoop/conf/core-site.xml";
    private String hdfsSitePath = "/etc/hadoop/conf/hdfs-site.xml";
    private String hdfsIp = "localhost";
    private String hdfsPort = "9000";
    private String dfsNameServices = "hdfsnamespace";
    private String dfsHaNamenodes = "nn1,nn2";
    private boolean dfsHaAutomaticFailoverEnabled = true;
    private String dfsClientFailoverProxyProvider = "org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider";
    private boolean useKerberos = false;
    private String kerberosKeytabFilePath = "/path";
    private String kerberosPrincipal = "principal";
    private long defaultTTL = Long.MAX_VALUE;

    public ZoneId getZoneID() {
        return this.zoneID;
    }

    void updatePath() {
        this.formulateFolders();
        this.confirmMultiDirStrategy();
    }

    private void formulateFolders() {
        int i;
        ArrayList<String> dirs = new ArrayList<String>();
        dirs.add(this.baseDir);
        dirs.add(this.systemDir);
        dirs.add(this.schemaDir);
        dirs.add(this.walFolder);
        dirs.add(this.indexFileDir);
        dirs.add(this.queryDir);
        dirs.addAll(Arrays.asList(this.dataDirs));
        for (i = 0; i < 4; ++i) {
            this.addHomeDir(dirs, i);
        }
        if (TSFileDescriptor.getInstance().getConfig().getTSFileStorageFs().equals((Object)FSType.HDFS)) {
            String[] hdfsIps = TSFileDescriptor.getInstance().getConfig().getHdfsIp();
            String hdfsDir = "hdfs://";
            hdfsDir = hdfsIps.length > 1 ? hdfsDir + TSFileDescriptor.getInstance().getConfig().getDfsNameServices() : hdfsDir + hdfsIps[0] + ":" + TSFileDescriptor.getInstance().getConfig().getHdfsPort();
            for (int i2 = 5; i2 < dirs.size(); ++i2) {
                String dir = (String)dirs.get(i2);
                dir = hdfsDir + File.separatorChar + dir;
                dirs.set(i2, dir);
            }
        } else {
            for (i = 5; i < dirs.size(); ++i) {
                this.addHomeDir(dirs, i);
            }
        }
        this.baseDir = (String)dirs.get(0);
        this.systemDir = (String)dirs.get(1);
        this.schemaDir = (String)dirs.get(2);
        this.walFolder = (String)dirs.get(3);
        this.indexFileDir = (String)dirs.get(4);
        this.queryDir = (String)dirs.get(5);
        for (int i3 = 0; i3 < this.dataDirs.length; ++i3) {
            this.dataDirs[i3] = (String)dirs.get(i3 + 6);
        }
    }

    private void addHomeDir(List<String> dirs, int i) {
        String dir = dirs.get(i);
        String homeDir = System.getProperty("IOTDB_HOME", null);
        if (!new File(dir).isAbsolute() && homeDir != null && homeDir.length() > 0) {
            dir = !homeDir.endsWith(File.separator) ? homeDir + File.separatorChar + dir : homeDir + dir;
            dirs.set(i, dir);
        }
    }

    private void confirmMultiDirStrategy() {
        if (this.getMultiDirStrategyClassName() == null) {
            this.multiDirStrategyClassName = DEFAULT_MULTI_DIR_STRATEGY;
        }
        if (!this.getMultiDirStrategyClassName().contains(".")) {
            this.multiDirStrategyClassName = MULTI_DIR_STRATEGY_PREFIX + this.multiDirStrategyClassName;
        }
        try {
            Class.forName(this.multiDirStrategyClassName);
        }
        catch (ClassNotFoundException e) {
            logger.warn("Cannot find given directory strategy {}, using the default value", (Object)this.getMultiDirStrategyClassName(), (Object)e);
            this.setMultiDirStrategyClassName("org.apache.iotdb.db.conf.directories.strategy.MaxDiskUsableSpaceFirstStrategy");
        }
    }

    public String[] getDataDirs() {
        return this.dataDirs;
    }

    public int getMetricsPort() {
        return this.metricsPort;
    }

    public void setMetricsPort(int metricsPort) {
        this.metricsPort = metricsPort;
    }

    public String getRpcAddress() {
        return this.rpcAddress;
    }

    void setRpcAddress(String rpcAddress) {
        this.rpcAddress = rpcAddress;
    }

    public int getRpcPort() {
        return this.rpcPort;
    }

    void setRpcPort(int rpcPort) {
        this.rpcPort = rpcPort;
    }

    public void setTimestampPrecision(String timestampPrecision) {
        this.timestampPrecision = timestampPrecision;
    }

    public String getTimestampPrecision() {
        return this.timestampPrecision;
    }

    public boolean isEnableWal() {
        return this.enableWal;
    }

    public void setEnableWal(boolean enableWal) {
        this.enableWal = enableWal;
    }

    public int getFlushWalThreshold() {
        return this.flushWalThreshold;
    }

    public void setFlushWalThreshold(int flushWalThreshold) {
        this.flushWalThreshold = flushWalThreshold;
    }

    public long getForceWalPeriodInMs() {
        return this.forceWalPeriodInMs;
    }

    public void setForceWalPeriodInMs(long forceWalPeriodInMs) {
        this.forceWalPeriodInMs = forceWalPeriodInMs;
    }

    public String getSystemDir() {
        return this.systemDir;
    }

    void setSystemDir(String systemDir) {
        this.systemDir = systemDir;
    }

    public String getSchemaDir() {
        return this.schemaDir;
    }

    void setSchemaDir(String schemaDir) {
        this.schemaDir = schemaDir;
    }

    public String getQueryDir() {
        return this.queryDir;
    }

    public void setQueryDir(String queryDir) {
        this.queryDir = queryDir;
    }

    public String getWalFolder() {
        return this.walFolder;
    }

    void setWalFolder(String walFolder) {
        this.walFolder = walFolder;
    }

    void setDataDirs(String[] dataDirs) {
        this.dataDirs = dataDirs;
    }

    public String getMultiDirStrategyClassName() {
        return this.multiDirStrategyClassName;
    }

    void setMultiDirStrategyClassName(String multiDirStrategyClassName) {
        this.multiDirStrategyClassName = multiDirStrategyClassName;
    }

    public String getIndexFileDir() {
        return this.indexFileDir;
    }

    private void setIndexFileDir(String indexFileDir) {
        this.indexFileDir = indexFileDir;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getMaxMemtableNumber() {
        return this.maxMemtableNumber;
    }

    public void setMaxMemtableNumber(int maxMemtableNumber) {
        this.maxMemtableNumber = maxMemtableNumber;
    }

    public int getConcurrentFlushThread() {
        return this.concurrentFlushThread;
    }

    void setConcurrentFlushThread(int concurrentFlushThread) {
        this.concurrentFlushThread = concurrentFlushThread;
    }

    void setZoneID(ZoneId zoneID) {
        this.zoneID = zoneID;
    }

    public long getTsFileSizeThreshold() {
        return this.tsFileSizeThreshold;
    }

    public void setTsFileSizeThreshold(long tsFileSizeThreshold) {
        this.tsFileSizeThreshold = tsFileSizeThreshold;
    }

    public int getBackLoopPeriodSec() {
        return this.backLoopPeriodSec;
    }

    void setBackLoopPeriodSec(int backLoopPeriodSec) {
        this.backLoopPeriodSec = backLoopPeriodSec;
    }

    public boolean isEnableStatMonitor() {
        return this.enableStatMonitor;
    }

    public void setEnableStatMonitor(boolean enableStatMonitor) {
        this.enableStatMonitor = enableStatMonitor;
    }

    public int getRpcMaxConcurrentClientNum() {
        return this.rpcMaxConcurrentClientNum;
    }

    public void setRpcMaxConcurrentClientNum(int rpcMaxConcurrentClientNum) {
        this.rpcMaxConcurrentClientNum = rpcMaxConcurrentClientNum;
    }

    public int getStatMonitorDetectFreqSec() {
        return this.statMonitorDetectFreqSec;
    }

    void setStatMonitorDetectFreqSec(int statMonitorDetectFreqSec) {
        this.statMonitorDetectFreqSec = statMonitorDetectFreqSec;
    }

    public int getStatMonitorRetainIntervalSec() {
        return this.statMonitorRetainIntervalSec;
    }

    void setStatMonitorRetainIntervalSec(int statMonitorRetainIntervalSec) {
        this.statMonitorRetainIntervalSec = statMonitorRetainIntervalSec;
    }

    public int getmManagerCacheSize() {
        return this.mManagerCacheSize;
    }

    void setmManagerCacheSize(int mManagerCacheSize) {
        this.mManagerCacheSize = mManagerCacheSize;
    }

    public boolean isSyncEnable() {
        return this.isSyncEnable;
    }

    void setSyncEnable(boolean syncEnable) {
        this.isSyncEnable = syncEnable;
    }

    public int getSyncServerPort() {
        return this.syncServerPort;
    }

    void setSyncServerPort(int syncServerPort) {
        this.syncServerPort = syncServerPort;
    }

    public String getLanguageVersion() {
        return this.languageVersion;
    }

    void setLanguageVersion(String languageVersion) {
        this.languageVersion = languageVersion;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public String getIpWhiteList() {
        return this.ipWhiteList;
    }

    public void setIpWhiteList(String ipWhiteList) {
        this.ipWhiteList = ipWhiteList;
    }

    public long getCacheFileReaderClearPeriod() {
        return this.cacheFileReaderClearPeriod;
    }

    public void setCacheFileReaderClearPeriod(long cacheFileReaderClearPeriod) {
        this.cacheFileReaderClearPeriod = cacheFileReaderClearPeriod;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getRpcImplClassName() {
        return this.rpcImplClassName;
    }

    public void setRpcImplClassName(String rpcImplClassName) {
        this.rpcImplClassName = rpcImplClassName;
    }

    public int getWalBufferSize() {
        return this.walBufferSize;
    }

    void setWalBufferSize(int walBufferSize) {
        this.walBufferSize = walBufferSize;
    }

    public boolean isChunkBufferPoolEnable() {
        return this.chunkBufferPoolEnable;
    }

    void setChunkBufferPoolEnable(boolean chunkBufferPoolEnable) {
        this.chunkBufferPoolEnable = chunkBufferPoolEnable;
    }

    public long getMergeMemoryBudget() {
        return this.mergeMemoryBudget;
    }

    public void setMergeMemoryBudget(long mergeMemoryBudget) {
        this.mergeMemoryBudget = mergeMemoryBudget;
    }

    public int getMergeThreadNum() {
        return this.mergeThreadNum;
    }

    public void setMergeThreadNum(int mergeThreadNum) {
        this.mergeThreadNum = mergeThreadNum;
    }

    public boolean isContinueMergeAfterReboot() {
        return this.continueMergeAfterReboot;
    }

    public void setContinueMergeAfterReboot(boolean continueMergeAfterReboot) {
        this.continueMergeAfterReboot = continueMergeAfterReboot;
    }

    public long getMergeIntervalSec() {
        return this.mergeIntervalSec;
    }

    public void setMergeIntervalSec(long mergeIntervalSec) {
        this.mergeIntervalSec = mergeIntervalSec;
    }

    public boolean isEnableParameterAdapter() {
        return this.enableParameterAdapter;
    }

    public void setEnableParameterAdapter(boolean enableParameterAdapter) {
        this.enableParameterAdapter = enableParameterAdapter;
    }

    public long getAllocateMemoryForWrite() {
        return this.allocateMemoryForWrite;
    }

    public void setAllocateMemoryForWrite(long allocateMemoryForWrite) {
        this.allocateMemoryForWrite = allocateMemoryForWrite;
    }

    public long getAllocateMemoryForRead() {
        return this.allocateMemoryForRead;
    }

    public void setAllocateMemoryForRead(long allocateMemoryForRead) {
        this.allocateMemoryForRead = allocateMemoryForRead;
    }

    public boolean isEnableExternalSort() {
        return this.enableExternalSort;
    }

    public void setEnableExternalSort(boolean enableExternalSort) {
        this.enableExternalSort = enableExternalSort;
    }

    public int getExternalSortThreshold() {
        return this.externalSortThreshold;
    }

    public void setExternalSortThreshold(int externalSortThreshold) {
        this.externalSortThreshold = externalSortThreshold;
    }

    public boolean isEnablePerformanceStat() {
        return this.enablePerformanceStat;
    }

    public void setEnablePerformanceStat(boolean enablePerformanceStat) {
        this.enablePerformanceStat = enablePerformanceStat;
    }

    public long getPerformanceStatDisplayInterval() {
        return this.performanceStatDisplayInterval;
    }

    public void setPerformanceStatDisplayInterval(long performanceStatDisplayInterval) {
        this.performanceStatDisplayInterval = performanceStatDisplayInterval;
    }

    public int getPerformanceStatMemoryInKB() {
        return this.performanceStatMemoryInKB;
    }

    public void setPerformanceStatMemoryInKB(int performanceStatMemoryInKB) {
        this.performanceStatMemoryInKB = performanceStatMemoryInKB;
    }

    public boolean isForceFullMerge() {
        return this.forceFullMerge;
    }

    public void setForceFullMerge(boolean forceFullMerge) {
        this.forceFullMerge = forceFullMerge;
    }

    public int getChunkMergePointThreshold() {
        return this.chunkMergePointThreshold;
    }

    public void setChunkMergePointThreshold(int chunkMergePointThreshold) {
        this.chunkMergePointThreshold = chunkMergePointThreshold;
    }

    public long getMemtableSizeThreshold() {
        return this.memtableSizeThreshold;
    }

    public void setMemtableSizeThreshold(long memtableSizeThreshold) {
        this.memtableSizeThreshold = memtableSizeThreshold;
    }

    public MergeFileStrategy getMergeFileStrategy() {
        return this.mergeFileStrategy;
    }

    public void setMergeFileStrategy(MergeFileStrategy mergeFileStrategy) {
        this.mergeFileStrategy = mergeFileStrategy;
    }

    public int getMergeChunkSubThreadNum() {
        return this.mergeChunkSubThreadNum;
    }

    public void setMergeChunkSubThreadNum(int mergeChunkSubThreadNum) {
        this.mergeChunkSubThreadNum = mergeChunkSubThreadNum;
    }

    public long getMergeFileSelectionTimeBudget() {
        return this.mergeFileSelectionTimeBudget;
    }

    public void setMergeFileSelectionTimeBudget(long mergeFileSelectionTimeBudget) {
        this.mergeFileSelectionTimeBudget = mergeFileSelectionTimeBudget;
    }

    public boolean isRpcThriftCompressionEnable() {
        return this.rpcThriftCompressionEnable;
    }

    public void setRpcThriftCompressionEnable(boolean rpcThriftCompressionEnable) {
        this.rpcThriftCompressionEnable = rpcThriftCompressionEnable;
    }

    public boolean isMetaDataCacheEnable() {
        return this.metaDataCacheEnable;
    }

    public void setMetaDataCacheEnable(boolean metaDataCacheEnable) {
        this.metaDataCacheEnable = metaDataCacheEnable;
    }

    public long getAllocateMemoryForFileMetaDataCache() {
        return this.allocateMemoryForFileMetaDataCache;
    }

    public void setAllocateMemoryForFileMetaDataCache(long allocateMemoryForFileMetaDataCache) {
        this.allocateMemoryForFileMetaDataCache = allocateMemoryForFileMetaDataCache;
    }

    public long getAllocateMemoryForChumkMetaDataCache() {
        return this.allocateMemoryForChumkMetaDataCache;
    }

    public void setAllocateMemoryForChumkMetaDataCache(long allocateMemoryForChumkMetaDataCache) {
        this.allocateMemoryForChumkMetaDataCache = allocateMemoryForChumkMetaDataCache;
    }

    public boolean isEnableWatermark() {
        return this.enableWatermark;
    }

    public void setEnableWatermark(boolean enableWatermark) {
        this.enableWatermark = enableWatermark;
    }

    public String getWatermarkSecretKey() {
        return this.watermarkSecretKey;
    }

    public void setWatermarkSecretKey(String watermarkSecretKey) {
        this.watermarkSecretKey = watermarkSecretKey;
    }

    public String getWatermarkBitString() {
        return this.watermarkBitString;
    }

    public void setWatermarkBitString(String watermarkBitString) {
        this.watermarkBitString = watermarkBitString;
    }

    public void setWatermarkMethod(String watermarkMethod) {
        this.watermarkMethod = watermarkMethod;
    }

    public String getWatermarkMethod() {
        return this.watermarkMethod;
    }

    public String getWatermarkMethodName() {
        return this.watermarkMethod.split("\\(")[0];
    }

    public int getWatermarkParamMarkRate() {
        return Integer.parseInt(this.getWatermarkParamValue("embed_row_cycle", "5"));
    }

    public int getWatermarkParamMaxRightBit() {
        return Integer.parseInt(this.getWatermarkParamValue("embed_lsb_num", "5"));
    }

    public String getWatermarkParamValue(String key, String defaultValue) {
        String res = this.getWatermarkParamValue(key);
        if (res != null) {
            return res;
        }
        return defaultValue;
    }

    public String getWatermarkParamValue(String key) {
        String pattern = key + "=(\\w*)";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(this.watermarkMethod);
        if (m.find() && m.groupCount() > 0) {
            return m.group(1);
        }
        return null;
    }

    public boolean isAutoCreateSchemaEnabled() {
        return this.enableAutoCreateSchema;
    }

    public void setAutoCreateSchemaEnabled(boolean enableAutoCreateSchema) {
        this.enableAutoCreateSchema = enableAutoCreateSchema;
    }

    public int getDefaultStorageGroupLevel() {
        return this.defaultStorageGroupLevel;
    }

    public void setDefaultStorageGroupLevel(int defaultStorageGroupLevel) {
        this.defaultStorageGroupLevel = defaultStorageGroupLevel;
    }

    public TSEncoding getDefaultBooleanEncoding() {
        return this.defaultBooleanEncoding;
    }

    public void setDefaultBooleanEncoding(TSEncoding defaultBooleanEncoding) {
        this.defaultBooleanEncoding = defaultBooleanEncoding;
    }

    public void setDefaultBooleanEncoding(String defaultBooleanEncoding) {
        this.defaultBooleanEncoding = TSEncoding.valueOf((String)defaultBooleanEncoding);
    }

    public TSEncoding getDefaultInt32Encoding() {
        return this.defaultInt32Encoding;
    }

    public void setDefaultInt32Encoding(TSEncoding defaultInt32Encoding) {
        this.defaultInt32Encoding = defaultInt32Encoding;
    }

    public void setDefaultInt32Encoding(String defaultInt32Encoding) {
        this.defaultInt32Encoding = TSEncoding.valueOf((String)defaultInt32Encoding);
    }

    public TSEncoding getDefaultInt64Encoding() {
        return this.defaultInt64Encoding;
    }

    public void setDefaultInt64Encoding(TSEncoding defaultInt64Encoding) {
        this.defaultInt64Encoding = defaultInt64Encoding;
    }

    public void setDefaultInt64Encoding(String defaultInt64Encoding) {
        this.defaultInt64Encoding = TSEncoding.valueOf((String)defaultInt64Encoding);
    }

    public TSEncoding getDefaultFloatEncoding() {
        return this.defaultFloatEncoding;
    }

    public void setDefaultFloatEncoding(TSEncoding defaultFloatEncoding) {
        this.defaultFloatEncoding = defaultFloatEncoding;
    }

    public void setDefaultFloatEncoding(String defaultFloatEncoding) {
        this.defaultFloatEncoding = TSEncoding.valueOf((String)defaultFloatEncoding);
    }

    public TSEncoding getDefaultDoubleEncoding() {
        return this.defaultDoubleEncoding;
    }

    public void setDefaultDoubleEncoding(TSEncoding defaultDoubleEncoding) {
        this.defaultDoubleEncoding = defaultDoubleEncoding;
    }

    public void setDefaultDoubleEncoding(String defaultDoubleEncoding) {
        this.defaultDoubleEncoding = TSEncoding.valueOf((String)defaultDoubleEncoding);
    }

    public TSEncoding getDefaultTextEncoding() {
        return this.defaultTextEncoding;
    }

    public void setDefaultTextEncoding(TSEncoding defaultTextEncoding) {
        this.defaultTextEncoding = defaultTextEncoding;
    }

    public void setDefaultTextEncoding(String defaultTextEncoding) {
        this.defaultTextEncoding = TSEncoding.valueOf((String)defaultTextEncoding);
    }

    public FSType getSystemFileStorageFs() {
        return this.systemFileStorageFs;
    }

    public void setSystemFileStorageFs(String systemFileStorageFs) {
        this.systemFileStorageFs = FSType.valueOf((String)systemFileStorageFs);
    }

    public FSType getTsFileStorageFs() {
        return this.tsFileStorageFs;
    }

    public void setTsFileStorageFs(String tsFileStorageFs) {
        this.tsFileStorageFs = FSType.valueOf((String)tsFileStorageFs);
    }

    public String getCoreSitePath() {
        return this.coreSitePath;
    }

    public void setCoreSitePath(String coreSitePath) {
        this.coreSitePath = coreSitePath;
    }

    public String getHdfsSitePath() {
        return this.hdfsSitePath;
    }

    public void setHdfsSitePath(String hdfsSitePath) {
        this.hdfsSitePath = hdfsSitePath;
    }

    public String[] getHdfsIp() {
        return this.hdfsIp.split(",");
    }

    public void setHdfsIp(String[] hdfsIp) {
        this.hdfsIp = String.join((CharSequence)",", hdfsIp);
    }

    public String getHdfsPort() {
        return this.hdfsPort;
    }

    public void setHdfsPort(String hdfsPort) {
        this.hdfsPort = hdfsPort;
    }

    public int getUpgradeThreadNum() {
        return this.upgradeThreadNum;
    }

    public void setUpgradeThreadNum(int upgradeThreadNum) {
        this.upgradeThreadNum = upgradeThreadNum;
    }

    public String getDfsNameServices() {
        return this.dfsNameServices;
    }

    public void setDfsNameServices(String dfsNameServices) {
        this.dfsNameServices = dfsNameServices;
    }

    public String[] getDfsHaNamenodes() {
        return this.dfsHaNamenodes.split(",");
    }

    public void setDfsHaNamenodes(String[] dfsHaNamenodes) {
        this.dfsHaNamenodes = String.join((CharSequence)",", dfsHaNamenodes);
    }

    public boolean isDfsHaAutomaticFailoverEnabled() {
        return this.dfsHaAutomaticFailoverEnabled;
    }

    public void setDfsHaAutomaticFailoverEnabled(boolean dfsHaAutomaticFailoverEnabled) {
        this.dfsHaAutomaticFailoverEnabled = dfsHaAutomaticFailoverEnabled;
    }

    public String getDfsClientFailoverProxyProvider() {
        return this.dfsClientFailoverProxyProvider;
    }

    public void setDfsClientFailoverProxyProvider(String dfsClientFailoverProxyProvider) {
        this.dfsClientFailoverProxyProvider = dfsClientFailoverProxyProvider;
    }

    public boolean isUseKerberos() {
        return this.useKerberos;
    }

    public void setUseKerberos(boolean useKerberos) {
        this.useKerberos = useKerberos;
    }

    public String getKerberosKeytabFilePath() {
        return this.kerberosKeytabFilePath;
    }

    public void setKerberosKeytabFilePath(String kerberosKeytabFilePath) {
        this.kerberosKeytabFilePath = kerberosKeytabFilePath;
    }

    public String getKerberosPrincipal() {
        return this.kerberosPrincipal;
    }

    public void setKerberosPrincipal(String kerberosPrincipal) {
        this.kerberosPrincipal = kerberosPrincipal;
    }

    public long getDefaultTTL() {
        return this.defaultTTL;
    }

    public void setDefaultTTL(long defaultTTL) {
        this.defaultTTL = defaultTTL;
    }
}

