/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.groupby.GroupByEngineDataSet;
import org.apache.iotdb.db.query.dataset.groupby.GroupByWithValueFilterDataSet;
import org.apache.iotdb.db.query.dataset.groupby.GroupByWithoutValueFilterDataSet;
import org.apache.iotdb.db.query.executor.AggregateEngineExecutor;
import org.apache.iotdb.db.query.executor.EngineExecutor;
import org.apache.iotdb.db.query.executor.FillEngineExecutor;
import org.apache.iotdb.db.query.executor.IEngineQueryRouter;
import org.apache.iotdb.db.query.fill.IFill;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.ExpressionType;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.QueryExpression;
import org.apache.iotdb.tsfile.read.expression.impl.BinaryExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.expression.util.ExpressionOptimizer;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Pair;

public class EngineQueryRouter
implements IEngineQueryRouter {
    @Override
    public QueryDataSet query(QueryExpression queryExpression, QueryContext context) throws StorageEngineException {
        if (queryExpression.hasQueryFilter()) {
            try {
                IExpression optimizedExpression = ExpressionOptimizer.getInstance().optimize(queryExpression.getExpression(), queryExpression.getSelectedSeries());
                queryExpression.setExpression(optimizedExpression);
                EngineExecutor engineExecutor = new EngineExecutor(queryExpression);
                if (optimizedExpression.getType() == ExpressionType.GLOBAL_TIME) {
                    return engineExecutor.executeWithoutValueFilter(context);
                }
                return engineExecutor.executeWithValueFilter(context);
            }
            catch (IOException | QueryFilterOptimizationException e) {
                throw new StorageEngineException(e.getMessage());
            }
        }
        EngineExecutor engineExecutor = new EngineExecutor(queryExpression);
        try {
            return engineExecutor.executeWithoutValueFilter(context);
        }
        catch (IOException e) {
            throw new StorageEngineException(e.getMessage());
        }
    }

    @Override
    public QueryDataSet aggregate(List<Path> selectedSeries, List<String> aggres, IExpression expression, QueryContext context) throws QueryFilterOptimizationException, StorageEngineException, QueryProcessException, IOException {
        if (expression != null) {
            IExpression optimizedExpression = ExpressionOptimizer.getInstance().optimize(expression, selectedSeries);
            AggregateEngineExecutor engineExecutor = new AggregateEngineExecutor(selectedSeries, aggres, optimizedExpression);
            if (optimizedExpression.getType() == ExpressionType.GLOBAL_TIME) {
                return engineExecutor.executeWithoutValueFilter(context);
            }
            return engineExecutor.executeWithValueFilter(context);
        }
        AggregateEngineExecutor engineExecutor = new AggregateEngineExecutor(selectedSeries, aggres, null);
        return engineExecutor.executeWithoutValueFilter(context);
    }

    @Override
    public QueryDataSet groupBy(List<Path> selectedSeries, List<String> aggres, IExpression expression, long unit, long origin, List<Pair<Long, Long>> intervals, QueryContext context) throws QueryFilterOptimizationException, StorageEngineException, QueryProcessException, IOException {
        GroupByEngineDataSet groupByEngine;
        long nextJobId = context.getJobId();
        for (Pair<Long, Long> pair : intervals) {
            if ((Long)pair.right >= (Long)pair.left) continue;
            throw new QueryProcessException(String.format("Interval starting time must be greater than the interval ending time, found error interval<%d, %d>", pair.left, pair.right));
        }
        List<Pair<Long, Long>> mergedIntervalList = this.mergeInterval(intervals);
        BinaryExpression.AndExpression intervalFilter = null;
        for (Pair<Long, Long> pair : mergedIntervalList) {
            BinaryExpression.AndExpression pairFilter = BinaryExpression.and((IExpression)new GlobalTimeExpression((Filter)TimeFilter.gtEq((long)((Long)pair.left))), (IExpression)new GlobalTimeExpression((Filter)TimeFilter.ltEq((long)((Long)pair.right))));
            if (intervalFilter != null) {
                intervalFilter = BinaryExpression.or((IExpression)intervalFilter, (IExpression)pairFilter);
                continue;
            }
            intervalFilter = pairFilter;
        }
        expression = expression == null ? intervalFilter : BinaryExpression.and((IExpression)expression, intervalFilter);
        IExpression optimizedExpression = ExpressionOptimizer.getInstance().optimize(expression, selectedSeries);
        if (optimizedExpression.getType() == ExpressionType.GLOBAL_TIME) {
            groupByEngine = new GroupByWithoutValueFilterDataSet(nextJobId, selectedSeries, unit, origin, mergedIntervalList);
            ((GroupByWithoutValueFilterDataSet)groupByEngine).initGroupBy(context, aggres, optimizedExpression);
            return groupByEngine;
        }
        groupByEngine = new GroupByWithValueFilterDataSet(nextJobId, selectedSeries, unit, origin, mergedIntervalList);
        ((GroupByWithValueFilterDataSet)groupByEngine).initGroupBy(context, aggres, optimizedExpression);
        return groupByEngine;
    }

    @Override
    public QueryDataSet fill(List<Path> fillPaths, long queryTime, Map<TSDataType, IFill> fillType, QueryContext context) throws StorageEngineException, QueryProcessException, IOException {
        long nextJobId = context.getJobId();
        FillEngineExecutor fillEngineExecutor = new FillEngineExecutor(nextJobId, fillPaths, queryTime, fillType);
        return fillEngineExecutor.execute(context);
    }

    private List<Pair<Long, Long>> mergeInterval(List<Pair<Long, Long>> intervals) {
        intervals.sort((o1, o2) -> (int)((Long)o1.left - (Long)o2.left));
        LinkedList<Pair<Long, Long>> merged = new LinkedList<Pair<Long, Long>>();
        for (Pair<Long, Long> interval : intervals) {
            if (merged.isEmpty() || (Long)merged.getLast().right < (Long)interval.left) {
                merged.add(interval);
                continue;
            }
            merged.getLast().right = Math.max((Long)merged.getLast().right, (Long)interval.right);
        }
        return merged;
    }
}

