/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.cache;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.tsfile.file.metadata.ChunkGroupMetaData;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetaData;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadata;
import org.apache.iotdb.tsfile.file.metadata.TsDeviceMetadataIndex;
import org.apache.iotdb.tsfile.file.metadata.TsFileMetaData;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Path;

public class TsFileMetadataUtils {
    private TsFileMetadataUtils() {
    }

    public static TsFileMetaData getTsFileMetaData(TsFileResource resource) throws IOException {
        TsFileSequenceReader reader = FileReaderManager.getInstance().get(resource, true);
        return reader.readFileMetadata();
    }

    public static TsDeviceMetadata getTsDeviceMetaData(TsFileResource resource, Path seriesPath, TsFileMetaData fileMetaData) throws IOException {
        if (!fileMetaData.getMeasurementSchema().containsKey(seriesPath.getMeasurement())) {
            return null;
        }
        TsDeviceMetadataIndex index = fileMetaData.getDeviceMetadataIndex(seriesPath.getDevice());
        TsFileSequenceReader tsFileReader = FileReaderManager.getInstance().get(resource, true);
        return tsFileReader.readTsDeviceMetaData(index);
    }

    public static Map<Path, List<ChunkMetaData>> getChunkMetaDataList(Set<String> sensorSet, TsDeviceMetadata tsDeviceMetadata) {
        ConcurrentHashMap<Path, List<ChunkMetaData>> pathToChunkMetaDataList = new ConcurrentHashMap<Path, List<ChunkMetaData>>();
        for (ChunkGroupMetaData chunkGroupMetaData : tsDeviceMetadata.getChunkGroupMetaDataList()) {
            List chunkMetaDataListInOneChunkGroup = chunkGroupMetaData.getChunkMetaDataList();
            String deviceId = chunkGroupMetaData.getDeviceID();
            for (ChunkMetaData chunkMetaData : chunkMetaDataListInOneChunkGroup) {
                if (!sensorSet.isEmpty() && !sensorSet.contains(chunkMetaData.getMeasurementUid())) continue;
                Path path = new Path(deviceId, chunkMetaData.getMeasurementUid());
                pathToChunkMetaDataList.putIfAbsent(path, new ArrayList());
                chunkMetaData.setVersion(chunkGroupMetaData.getVersion());
                ((List)pathToChunkMetaDataList.get(path)).add(chunkMetaData);
            }
        }
        for (List chunkMetaDataList : pathToChunkMetaDataList.values()) {
            chunkMetaDataList.sort(Comparator.comparingLong(ChunkMetaData::getStartTime));
        }
        return pathToChunkMetaDataList;
    }

    public static List<ChunkMetaData> getChunkMetaDataList(String sensor, TsDeviceMetadata tsDeviceMetadata) {
        ArrayList<ChunkMetaData> chunkMetaDataList = new ArrayList<ChunkMetaData>();
        for (ChunkGroupMetaData chunkGroupMetaData : tsDeviceMetadata.getChunkGroupMetaDataList()) {
            List chunkMetaDataListInOneChunkGroup = chunkGroupMetaData.getChunkMetaDataList();
            for (ChunkMetaData chunkMetaData : chunkMetaDataListInOneChunkGroup) {
                if (!sensor.equals(chunkMetaData.getMeasurementUid())) continue;
                chunkMetaData.setVersion(chunkGroupMetaData.getVersion());
                chunkMetaDataList.add(chunkMetaData);
            }
        }
        return chunkMetaDataList;
    }
}

