/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.memtable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.memtable.IWritableMemChunk;
import org.apache.iotdb.db.engine.memtable.WritableMemChunk;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.physical.crud.BatchInsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.rescon.TVListAllocator;
import org.apache.iotdb.db.utils.MemUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;

public abstract class AbstractMemTable
implements IMemTable {
    private long version;
    private List<Modification> modifications = new ArrayList<Modification>();
    private final Map<String, Map<String, IWritableMemChunk>> memTableMap;
    private long memSize = 0L;

    public AbstractMemTable() {
        this.memTableMap = new HashMap<String, Map<String, IWritableMemChunk>>();
    }

    public AbstractMemTable(Map<String, Map<String, IWritableMemChunk>> memTableMap) {
        this.memTableMap = memTableMap;
    }

    @Override
    public Map<String, Map<String, IWritableMemChunk>> getMemTableMap() {
        return this.memTableMap;
    }

    private boolean checkPath(String deviceId, String measurement) {
        return this.memTableMap.containsKey(deviceId) && this.memTableMap.get(deviceId).containsKey(measurement);
    }

    private IWritableMemChunk createIfNotExistAndGet(String deviceId, String measurement, TSDataType dataType) {
        Map<String, IWritableMemChunk> memSeries;
        if (!this.memTableMap.containsKey(deviceId)) {
            this.memTableMap.put(deviceId, new HashMap());
        }
        if (!(memSeries = this.memTableMap.get(deviceId)).containsKey(measurement)) {
            memSeries.put(measurement, this.genMemSeries(dataType));
        }
        return memSeries.get(measurement);
    }

    protected abstract IWritableMemChunk genMemSeries(TSDataType var1);

    @Override
    public void insert(InsertPlan insertPlan) throws QueryProcessException {
        try {
            for (int i = 0; i < insertPlan.getValues().length; ++i) {
                Object value = AbstractMemTable.parseValue(insertPlan.getDataTypes()[i], insertPlan.getValues()[i]);
                this.write(insertPlan.getDeviceId(), insertPlan.getMeasurements()[i], insertPlan.getDataTypes()[i], insertPlan.getTime(), value);
            }
            long recordSizeInByte = MemUtils.getRecordSize(insertPlan);
            this.memSize += recordSizeInByte;
        }
        catch (RuntimeException e) {
            throw new QueryProcessException(e.getMessage());
        }
    }

    private static Object parseValue(TSDataType dataType, String value) throws QueryProcessException {
        try {
            switch (dataType) {
                case BOOLEAN: {
                    value = value.toLowerCase();
                    if ("0".equals(value) || "false".equals(value)) {
                        return false;
                    }
                    if ("1".equals(value) || "true".equals(value)) {
                        return true;
                    }
                    throw new QueryProcessException("The BOOLEAN data type should be true/TRUE, false/FALSE or 0/1");
                }
                case INT32: {
                    return Integer.parseInt(value);
                }
                case INT64: {
                    return Long.parseLong(value);
                }
                case FLOAT: {
                    return Float.valueOf(Float.parseFloat(value));
                }
                case DOUBLE: {
                    return Double.parseDouble(value);
                }
                case TEXT: {
                    if (value.startsWith("'") && value.endsWith("'") || value.startsWith("\"") && value.endsWith("\"")) {
                        if (value.length() == 1) {
                            return new Binary(value);
                        }
                        return new Binary(value.substring(1, value.length() - 1));
                    }
                    throw new QueryProcessException("The TEXT data type should be covered by \" or '");
                }
            }
            throw new QueryProcessException("Unsupported data type:" + dataType);
        }
        catch (NumberFormatException e) {
            throw new QueryProcessException(e.getMessage());
        }
    }

    @Override
    public void insertBatch(BatchInsertPlan batchInsertPlan, List<Integer> indexes) throws QueryProcessException {
        try {
            this.write(batchInsertPlan, indexes);
            long recordSizeInByte = MemUtils.getRecordSize(batchInsertPlan);
            this.memSize += recordSizeInByte;
        }
        catch (RuntimeException e) {
            throw new QueryProcessException(e.getMessage());
        }
    }

    @Override
    public void write(String deviceId, String measurement, TSDataType dataType, long insertTime, Object objectValue) {
        IWritableMemChunk memSeries = this.createIfNotExistAndGet(deviceId, measurement, dataType);
        memSeries.write(insertTime, objectValue);
    }

    @Override
    public void write(BatchInsertPlan batchInsertPlan, List<Integer> indexes) {
        for (int i = 0; i < batchInsertPlan.getMeasurements().length; ++i) {
            IWritableMemChunk memSeries = this.createIfNotExistAndGet(batchInsertPlan.getDeviceId(), batchInsertPlan.getMeasurements()[i], batchInsertPlan.getDataTypes()[i]);
            memSeries.write(batchInsertPlan.getTimes(), batchInsertPlan.getColumns()[i], batchInsertPlan.getDataTypes()[i], indexes);
        }
    }

    @Override
    public long size() {
        long sum = 0L;
        for (Map<String, IWritableMemChunk> seriesMap : this.memTableMap.values()) {
            for (IWritableMemChunk writableMemChunk : seriesMap.values()) {
                sum += writableMemChunk.count();
            }
        }
        return sum;
    }

    @Override
    public long memSize() {
        return this.memSize;
    }

    @Override
    public void clear() {
        this.memTableMap.clear();
        this.modifications.clear();
        this.memSize = 0L;
    }

    @Override
    public boolean isEmpty() {
        return this.memTableMap.isEmpty();
    }

    @Override
    public ReadOnlyMemChunk query(String deviceId, String measurement, TSDataType dataType, Map<String, String> props, long timeLowerBound) {
        if (!this.checkPath(deviceId, measurement)) {
            return null;
        }
        long undeletedTime = this.findUndeletedTime(deviceId, measurement, timeLowerBound);
        IWritableMemChunk memChunk = this.memTableMap.get(deviceId).get(measurement);
        WritableMemChunk chunkCopy = new WritableMemChunk(dataType, memChunk.getTVList().clone());
        chunkCopy.setTimeOffset(undeletedTime);
        WritableMemChunk sorter = chunkCopy;
        return new ReadOnlyMemChunk(dataType, sorter, props);
    }

    private long findUndeletedTime(String deviceId, String measurement, long timeLowerBound) {
        long undeletedTime = Long.MIN_VALUE;
        for (Modification modification : this.modifications) {
            Deletion deletion;
            if (!(modification instanceof Deletion) || !(deletion = (Deletion)modification).getDevice().equals(deviceId) || !deletion.getMeasurement().equals(measurement) || deletion.getTimestamp() <= undeletedTime) continue;
            undeletedTime = deletion.getTimestamp();
        }
        return Math.max(undeletedTime + 1L, timeLowerBound);
    }

    @Override
    public void delete(String deviceId, String measurementId, long timestamp) {
        Map<String, IWritableMemChunk> deviceMap = this.memTableMap.get(deviceId);
        if (deviceMap != null) {
            IWritableMemChunk chunk = deviceMap.get(measurementId);
            if (chunk == null) {
                return;
            }
            chunk.delete(timestamp);
        }
    }

    @Override
    public void delete(Deletion deletion) {
        this.modifications.add(deletion);
    }

    @Override
    public void setVersion(long version) {
        this.version = version;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void release() {
        for (Map.Entry<String, Map<String, IWritableMemChunk>> entry : this.memTableMap.entrySet()) {
            for (Map.Entry<String, IWritableMemChunk> subEntry : entry.getValue().entrySet()) {
                TVListAllocator.getInstance().release(subEntry.getValue().getTVList());
            }
        }
    }
}

