/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.factory;

import org.apache.iotdb.db.exception.path.PathException;
import org.apache.iotdb.db.query.aggregation.AggregateFunction;
import org.apache.iotdb.db.query.aggregation.impl.AvgAggrFunc;
import org.apache.iotdb.db.query.aggregation.impl.CountAggrFunc;
import org.apache.iotdb.db.query.aggregation.impl.FirstAggrFunc;
import org.apache.iotdb.db.query.aggregation.impl.LastAggrFunc;
import org.apache.iotdb.db.query.aggregation.impl.MaxTimeAggrFunc;
import org.apache.iotdb.db.query.aggregation.impl.MaxValueAggrFunc;
import org.apache.iotdb.db.query.aggregation.impl.MinTimeAggrFunc;
import org.apache.iotdb.db.query.aggregation.impl.MinValueAggrFunc;
import org.apache.iotdb.db.query.aggregation.impl.SumAggrFunc;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class AggreFuncFactory {
    private AggreFuncFactory() {
    }

    public static AggregateFunction getAggrFuncByName(String aggrFuncName, TSDataType dataType) throws PathException {
        if (aggrFuncName == null) {
            throw new PathException("AggregateFunction Name must not be null");
        }
        switch (aggrFuncName.toLowerCase()) {
            case "min_time": {
                return new MinTimeAggrFunc();
            }
            case "max_time": {
                return new MaxTimeAggrFunc();
            }
            case "min_value": {
                return new MinValueAggrFunc(dataType);
            }
            case "max_value": {
                return new MaxValueAggrFunc(dataType);
            }
            case "count": {
                return new CountAggrFunc();
            }
            case "avg": {
                return new AvgAggrFunc(dataType);
            }
            case "first": {
                return new FirstAggrFunc(dataType);
            }
            case "sum": {
                return new SumAggrFunc(dataType);
            }
            case "last": {
                return new LastAggrFunc(dataType);
            }
        }
        throw new PathException("aggregate does not support " + aggrFuncName + " function.");
    }
}

