/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.sql.parse;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.db.sql.parse.AstNodeOrigin;
import org.apache.iotdb.db.sql.parse.Node;

public class AstNode
extends CommonTree
implements Node,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient StringBuilder astStr;
    private transient AstNodeOrigin origin;
    private transient int startIndx = -1;
    private transient int endIndx = -1;
    private transient AstNode rootNode;
    private transient boolean isValidAstStr;
    private transient boolean visited = false;

    public AstNode() {
    }

    public AstNode(Token t) {
        super(t);
    }

    public AstNode(AstNode node) {
        super((CommonTree)node);
        this.origin = node.origin;
    }

    public Tree dupNode() {
        return new AstNode(this);
    }

    @Override
    public List<Node> getChildren() {
        if (super.getChildCount() == 0) {
            return new ArrayList<Node>();
        }
        ArrayList<Node> retVec = new ArrayList<Node>();
        for (int i = 0; i < super.getChildCount(); ++i) {
            retVec.add((Node)super.getChild(i));
        }
        return retVec;
    }

    @Override
    public String getName() {
        return String.valueOf(super.getToken().getType());
    }

    public void setUnknownTokenBoundaries() {
        AstNode next;
        ArrayDeque<AstNode> stack1 = new ArrayDeque<AstNode>();
        ArrayDeque<AstNode> stack2 = new ArrayDeque<AstNode>();
        stack1.push(this);
        while (!stack1.isEmpty()) {
            next = (AstNode)stack1.pop();
            stack2.push(next);
            if (next.children == null) continue;
            for (int i = next.children.size() - 1; i >= 0; --i) {
                stack1.push((AstNode)next.children.get(i));
            }
        }
        while (!stack2.isEmpty()) {
            next = (AstNode)stack2.pop();
            if (next.children == null && (next.startIndex < 0 || next.stopIndex < 0)) {
                next.startIndex = next.stopIndex = next.token.getTokenIndex();
                continue;
            }
            if (next.startIndex >= 0 && next.stopIndex >= 0 || next.children.isEmpty()) continue;
            AstNode firstChild = (AstNode)next.children.get(0);
            AstNode lastChild = (AstNode)next.children.get(next.children.size() - 1);
            next.startIndex = firstChild.getTokenStartIndex();
            next.stopIndex = lastChild.getTokenStopIndex();
        }
    }

    public AstNodeOrigin getOrigin() {
        return this.origin;
    }

    public void setOrigin(AstNodeOrigin origin) {
        this.origin = origin;
    }

    public String dump() {
        StringBuilder sb = new StringBuilder("\n");
        this.dump(sb);
        return sb.toString();
    }

    private StringBuilder dump(StringBuilder sb) {
        ArrayDeque<AstNode> stack = new ArrayDeque<AstNode>();
        stack.push(this);
        int tabLength = 0;
        while (!stack.isEmpty()) {
            AstNode next = (AstNode)stack.peek();
            if (!next.visited) {
                sb.append(StringUtils.repeat((String)" ", (int)(tabLength * 3)));
                sb.append(next.toString());
                sb.append("\n");
                if (next.children != null) {
                    for (int i = next.children.size() - 1; i >= 0; --i) {
                        stack.push((AstNode)next.children.get(i));
                    }
                }
                ++tabLength;
                next.visited = true;
                continue;
            }
            --tabLength;
            next.visited = false;
            stack.pop();
        }
        return sb;
    }

    private void getRootNodeWithValidAstStr() {
        if (this.rootNode != null && this.rootNode.parent == null && this.rootNode.hasValidMemoizedString()) {
            return;
        }
        AstNode retNode = this;
        while (retNode.parent != null) {
            retNode = (AstNode)retNode.parent;
        }
        this.rootNode = retNode;
        if (!this.rootNode.isValidAstStr) {
            this.rootNode.astStr = new StringBuilder();
            this.rootNode.toStringTree(this.rootNode);
            this.rootNode.isValidAstStr = true;
        }
    }

    private boolean hasValidMemoizedString() {
        return this.isValidAstStr && this.astStr != null;
    }

    private void resetRootInformation() {
        if (this.rootNode != null) {
            this.rootNode.astStr = null;
            this.rootNode.isValidAstStr = false;
        }
    }

    private int getMemoizedStringLen() {
        return this.astStr == null ? 0 : this.astStr.length();
    }

    private boolean checkStringBuilder(StringBuilder builder, int start, int end) {
        return builder == null || start < 0 || end > builder.length() || start >= end;
    }

    private String getMemoizedSubString(int start, int end) {
        return this.checkStringBuilder(this.astStr, start, end) ? null : this.astStr.subSequence(start, end).toString();
    }

    private void addtoMemoizedString(String string) {
        if (this.astStr == null) {
            this.astStr = new StringBuilder();
        }
        this.astStr.append(string);
    }

    public void setParent(Tree t) {
        super.setParent(t);
        this.resetRootInformation();
    }

    public void addChild(Tree t) {
        super.addChild(t);
        this.resetRootInformation();
    }

    public void addChildren(List kids) {
        super.addChildren(kids);
        this.resetRootInformation();
    }

    public void setChild(int i, Tree t) {
        super.setChild(i, t);
        this.resetRootInformation();
    }

    public void insertChild(int i, Object t) {
        super.insertChild(i, t);
        this.resetRootInformation();
    }

    public Object deleteChild(int i) {
        Object ret = super.deleteChild(i);
        this.resetRootInformation();
        return ret;
    }

    public void replaceChildren(int startChildIndex, int stopChildIndex, Object t) {
        super.replaceChildren(startChildIndex, stopChildIndex, t);
        this.resetRootInformation();
    }

    public String toStringTree() {
        this.getRootNodeWithValidAstStr();
        if (this.startIndx >= 0 && this.endIndx <= this.rootNode.getMemoizedStringLen()) {
            return this.rootNode.getMemoizedSubString(this.startIndx, this.endIndx);
        }
        return this.toStringTree(this.rootNode);
    }

    private String toStringTree(AstNode rootNode) {
        ArrayDeque<AstNode> stack = new ArrayDeque<AstNode>();
        stack.push(this);
        while (!stack.isEmpty()) {
            AstNode next = (AstNode)stack.peek();
            if (!next.visited) {
                this.toStringVisit(next, stack);
                continue;
            }
            if (!next.isNil()) {
                rootNode.addtoMemoizedString(")");
            }
            next.endIndx = rootNode.getMemoizedStringLen();
            next.visited = false;
            stack.pop();
        }
        return rootNode.getMemoizedSubString(this.startIndx, this.endIndx);
    }

    private void toStringVisit(AstNode next, Deque<AstNode> stack) {
        if (next.parent != null && next.parent.getChildCount() > 1 && next != next.parent.getChild(0)) {
            this.rootNode.addtoMemoizedString(" ");
        }
        next.rootNode = this.rootNode;
        next.startIndx = this.rootNode.getMemoizedStringLen();
        if (next.children == null || next.children.isEmpty()) {
            String str = next.toString();
            this.rootNode.addtoMemoizedString(next.getType() != 123 ? str.toLowerCase() : str);
            next.endIndx = this.rootNode.getMemoizedStringLen();
            stack.pop();
            return;
        }
        if (!next.isNil()) {
            this.rootNode.addtoMemoizedString("(");
            String str = next.toString();
            this.rootNode.addtoMemoizedString(next.getType() == 123 || null == str ? str : str.toLowerCase());
            this.rootNode.addtoMemoizedString(" ");
        }
        if (next.children != null) {
            for (int i = next.children.size() - 1; i >= 0; --i) {
                stack.push((AstNode)next.children.get(i));
            }
        }
        next.visited = true;
    }

    public AstNode getChild(int i) {
        if (this.children == null || i >= this.children.size()) {
            return null;
        }
        return (AstNode)this.children.get(i);
    }
}

