/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.logvisual.gui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import org.apache.iotdb.db.tools.logvisual.LogVisualizer;
import org.apache.iotdb.db.tools.logvisual.TimeSeriesStatistics;
import org.apache.iotdb.db.tools.logvisual.VisualizationPlan;
import org.apache.iotdb.db.tools.logvisual.conf.GuiPropertyKeys;
import org.apache.iotdb.db.tools.logvisual.exceptions.VisualizationException;
import org.apache.iotdb.db.tools.logvisual.gui.LogVisualizationGui;
import org.apache.iotdb.db.tools.logvisual.gui.PlanDetailPanel;
import org.jfree.chart.JFreeChart;

class PlanBox
extends Box {
    private JLabel panelName;
    private JButton loadPlanButton;
    private JButton executePlanButton;
    private JButton savePlanButton;
    private JButton createPlanButton;
    private JButton deletePlanButton;
    private JButton exportResultButton;
    private JScrollPane scrollPane;
    private DefaultListModel<VisualizationPlan> planListModel;
    private JList planList;
    private PlanDetailPanel planDetailPanel;
    private LogVisualizer visualizer;
    private ExecutePlanCallback executePlanCallback;
    private LogVisualizationGui.PropertyChangeCallback propertyChangeCallback;

    PlanBox(LogVisualizer visualizer, ExecutePlanCallback executePlanCallback, String defaultPlanPath, LogVisualizationGui.PropertyChangeCallback propertyChangeCallback) {
        super(0);
        this.visualizer = visualizer;
        this.executePlanCallback = executePlanCallback;
        this.propertyChangeCallback = propertyChangeCallback;
        this.panelName = new JLabel("Visualization plans");
        this.loadPlanButton = new JButton("Load plan");
        this.executePlanButton = new JButton("Execute plan");
        this.savePlanButton = new JButton("Save plan");
        this.createPlanButton = new JButton("Create plan");
        this.deletePlanButton = new JButton("Delete plan");
        this.exportResultButton = new JButton("Export result");
        this.panelName.setAlignmentX(0.5f);
        this.loadPlanButton.setAlignmentX(0.5f);
        this.executePlanButton.setAlignmentX(0.5f);
        this.savePlanButton.setAlignmentX(0.5f);
        this.createPlanButton.setAlignmentX(0.5f);
        this.deletePlanButton.setAlignmentX(0.5f);
        this.exportResultButton.setAlignmentX(0.5f);
        this.planListModel = new DefaultListModel();
        this.planList = new JList<VisualizationPlan>(this.planListModel);
        this.planList.setSelectionMode(0);
        this.scrollPane = new JScrollPane(this.planList);
        this.add(this.scrollPane);
        this.add(Box.createHorizontalStrut(10));
        Box vBox = Box.createVerticalBox();
        vBox.add(this.panelName);
        vBox.add(this.loadPlanButton);
        vBox.add(Box.createVerticalStrut(5));
        vBox.add(this.savePlanButton);
        vBox.add(Box.createVerticalStrut(5));
        vBox.add(this.createPlanButton);
        vBox.add(Box.createVerticalStrut(5));
        vBox.add(this.deletePlanButton);
        vBox.add(Box.createVerticalStrut(5));
        vBox.add(this.executePlanButton);
        vBox.add(Box.createVerticalStrut(5));
        vBox.add(this.exportResultButton);
        vBox.add(Box.createGlue());
        this.add(vBox);
        this.planDetailPanel = new PlanDetailPanel();
        this.planDetailPanel.setPreferredSize(new Dimension(400, 300));
        this.add(this.planDetailPanel);
        this.planList.addListSelectionListener(this::onPlanSelectionChanged);
        this.loadPlanButton.addActionListener(this::onLoadPlan);
        this.executePlanButton.addActionListener(this::onExecutePlan);
        this.savePlanButton.addActionListener(this::onPlanSave);
        this.createPlanButton.addActionListener(this::onCreatePlan);
        this.deletePlanButton.addActionListener(this::onDeletePlan);
        this.exportResultButton.addActionListener(this::onExportResult);
        this.exportResultButton.setEnabled(false);
        if (defaultPlanPath != null) {
            String[] defaultPaths = defaultPlanPath.split(";");
            File[] defaultPlanFiles = new File[defaultPaths.length];
            for (int i = 0; i < defaultPaths.length; ++i) {
                defaultPlanFiles[i] = new File(defaultPaths[i]);
            }
            try {
                visualizer.loadPlans(defaultPlanFiles);
                Collection<VisualizationPlan> planList = visualizer.listPlans();
                this.updatePlan(planList);
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(this, "Cannot load plan: " + e1.getMessage());
            }
        }
    }

    private void onLoadPlan(ActionEvent e) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setFileSelectionMode(2);
        int status = fileChooser.showOpenDialog(this);
        if (status == 0) {
            File[] chosenFiles = fileChooser.getSelectedFiles();
            try {
                this.visualizer.loadPlans(chosenFiles);
                Collection<VisualizationPlan> planList = this.visualizer.listPlans();
                this.updatePlan(planList);
                if (chosenFiles.length > 0) {
                    StringBuilder builder = new StringBuilder(chosenFiles[0].getPath());
                    for (int i = 1; i < chosenFiles.length; ++i) {
                        builder.append(";").append(chosenFiles[i].getPath());
                    }
                    this.propertyChangeCallback.call(GuiPropertyKeys.DEFAULT_PLAN_PATH.getKey(), builder.toString());
                }
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(this, "Cannot load plan: " + e1.getMessage());
            }
        }
    }

    private void updatePlan(Collection<VisualizationPlan> plans) {
        this.planListModel.clear();
        for (VisualizationPlan plan : plans) {
            this.planListModel.addElement(plan);
        }
    }

    private void onExecutePlan(ActionEvent e) {
        VisualizationPlan plan = (VisualizationPlan)this.planList.getSelectedValue();
        if (plan == null) {
            return;
        }
        try {
            this.visualizer.executePlan(plan);
        }
        catch (VisualizationException e1) {
            JOptionPane.showMessageDialog(this, "Cannot execute plan: " + e1.getMessage());
            return;
        }
        Map<String, JFreeChart> charts = this.visualizer.getCharts();
        Map<String, List<TimeSeriesStatistics>> statisticMap = this.visualizer.getStatisticsMap();
        this.executePlanCallback.call(plan.getName(), charts, statisticMap);
        this.exportResultButton.setEnabled(true);
        JOptionPane.showMessageDialog(this, String.format("Plan is successfully executed, found %d log groups", this.visualizer.getGroupNum()));
    }

    private void onPlanSelectionChanged(ListSelectionEvent e) {
        VisualizationPlan plan = (VisualizationPlan)this.planList.getSelectedValue();
        if (plan == null) {
            return;
        }
        this.planDetailPanel.setPlan(plan);
    }

    private void onPlanSave(ActionEvent e) {
        this.planDetailPanel.updatePlan();
    }

    private void onCreatePlan(ActionEvent e) {
        JFileChooser fileChooser = new JFileChooser();
        int status = fileChooser.showOpenDialog(this);
        if (status == 0) {
            File chosenFile = fileChooser.getSelectedFile();
            VisualizationPlan plan = new VisualizationPlan();
            String planName = chosenFile.getName();
            if (!this.validateNewPlanName(planName)) {
                JOptionPane.showMessageDialog(this, String.format("A plan named %s alread exists", planName));
                return;
            }
            plan.setName(planName);
            plan.setPlanFilePath(chosenFile.getPath());
            plan.setContentPattern(Pattern.compile(".*"));
            this.planListModel.addElement(plan);
            this.planList.setSelectedIndex(this.planListModel.getSize() - 1);
            this.planDetailPanel.setPlan(plan);
        }
    }

    private boolean validateNewPlanName(String planName) {
        for (int i = 0; i < this.planListModel.getSize(); ++i) {
            if (!this.planListModel.get(i).getName().equals(planName)) continue;
            return false;
        }
        return true;
    }

    private void onDeletePlan(ActionEvent e) {
        VisualizationPlan plan = (VisualizationPlan)this.planList.getSelectedValue();
        if (plan == null) {
            return;
        }
        int status = JOptionPane.showConfirmDialog(this, "Do you really want to delete this plan? (Cannot be undone)", "confirm", 0);
        if (status == 0) {
            File file = new File(plan.getPlanFilePath());
            file.delete();
            this.planListModel.removeElement(plan);
            this.planDetailPanel.setPlan(null);
        }
    }

    private void onExportResult(ActionEvent e) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        int status = fileChooser.showOpenDialog(this);
        if (status == 0) {
            File distDir = fileChooser.getSelectedFile();
            try {
                this.visualizer.saveResults(distDir.getPath());
                JOptionPane.showMessageDialog(this, "Export successfully");
            }
            catch (VisualizationException e1) {
                JOptionPane.showMessageDialog(this, "Cannot export results:" + e1.getMessage());
            }
        }
    }

    public static interface ExecutePlanCallback {
        public void call(String var1, Map<String, JFreeChart> var2, Map<String, List<TimeSeriesStatistics>> var3);
    }
}

