/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import org.apache.iotdb.db.query.aggregation.AggreResultData;
import org.apache.iotdb.db.utils.TimeValuePair;
import org.apache.iotdb.db.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.utils.Binary;

public class TimeValuePairUtils {
    private TimeValuePairUtils() {
    }

    public static TimeValuePair getCurrentTimeValuePair(BatchData data) {
        switch (data.getDataType()) {
            case INT32: {
                return new TimeValuePair(data.currentTime(), new TsPrimitiveType.TsInt(data.getInt()));
            }
            case INT64: {
                return new TimeValuePair(data.currentTime(), new TsPrimitiveType.TsLong(data.getLong()));
            }
            case FLOAT: {
                return new TimeValuePair(data.currentTime(), new TsPrimitiveType.TsFloat(data.getFloat()));
            }
            case DOUBLE: {
                return new TimeValuePair(data.currentTime(), new TsPrimitiveType.TsDouble(data.getDouble()));
            }
            case TEXT: {
                return new TimeValuePair(data.currentTime(), new TsPrimitiveType.TsBinary(data.getBinary()));
            }
            case BOOLEAN: {
                return new TimeValuePair(data.currentTime(), new TsPrimitiveType.TsBoolean(data.getBoolean()));
            }
        }
        throw new UnSupportedDataTypeException(String.valueOf(data.getDataType()));
    }

    public static TimeValuePair getCurrentTimeValuePair(AggreResultData data) {
        switch (data.getDataType()) {
            case INT32: {
                return new TimeValuePair(data.getTimestamp(), new TsPrimitiveType.TsInt(data.getIntRet()));
            }
            case INT64: {
                return new TimeValuePair(data.getTimestamp(), new TsPrimitiveType.TsLong(data.getLongRet()));
            }
            case FLOAT: {
                return new TimeValuePair(data.getTimestamp(), new TsPrimitiveType.TsFloat(data.getFloatRet()));
            }
            case DOUBLE: {
                return new TimeValuePair(data.getTimestamp(), new TsPrimitiveType.TsDouble(data.getDoubleRet()));
            }
            case TEXT: {
                return new TimeValuePair(data.getTimestamp(), new TsPrimitiveType.TsBinary(data.getBinaryRet()));
            }
            case BOOLEAN: {
                return new TimeValuePair(data.getTimestamp(), new TsPrimitiveType.TsBoolean(data.isBooleanRet()));
            }
        }
        throw new UnSupportedDataTypeException(String.valueOf(data.getDataType()));
    }

    public static void setCurrentTimeValuePair(BatchData data, TimeValuePair current) {
        current.setTimestamp(data.currentTime());
        switch (data.getDataType()) {
            case INT32: {
                current.getValue().setInt(data.getInt());
                break;
            }
            case INT64: {
                current.getValue().setLong(data.getLong());
                break;
            }
            case FLOAT: {
                current.getValue().setFloat(data.getFloat());
                break;
            }
            case DOUBLE: {
                current.getValue().setDouble(data.getDouble());
                break;
            }
            case TEXT: {
                current.getValue().setBinary(data.getBinary());
                break;
            }
            case BOOLEAN: {
                current.getValue().setBoolean(data.getBoolean());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.valueOf(data.getDataType()));
            }
        }
    }

    public static void setTimeValuePair(TimeValuePair from, TimeValuePair to) {
        to.setTimestamp(from.getTimestamp());
        switch (from.getValue().getDataType()) {
            case INT32: {
                to.getValue().setInt(from.getValue().getInt());
                break;
            }
            case INT64: {
                to.getValue().setLong(from.getValue().getLong());
                break;
            }
            case FLOAT: {
                to.getValue().setFloat(from.getValue().getFloat());
                break;
            }
            case DOUBLE: {
                to.getValue().setDouble(from.getValue().getDouble());
                break;
            }
            case TEXT: {
                to.getValue().setBinary(from.getValue().getBinary());
                break;
            }
            case BOOLEAN: {
                to.getValue().setBoolean(from.getValue().getBoolean());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.valueOf(from.getValue().getDataType()));
            }
        }
    }

    public static TimeValuePair getEmptyTimeValuePair(TSDataType dataType) {
        switch (dataType) {
            case FLOAT: {
                return new TimeValuePair(0L, new TsPrimitiveType.TsFloat(0.0f));
            }
            case INT32: {
                return new TimeValuePair(0L, new TsPrimitiveType.TsInt(0));
            }
            case INT64: {
                return new TimeValuePair(0L, new TsPrimitiveType.TsLong(0L));
            }
            case BOOLEAN: {
                return new TimeValuePair(0L, new TsPrimitiveType.TsBoolean(false));
            }
            case DOUBLE: {
                return new TimeValuePair(0L, new TsPrimitiveType.TsDouble(0.0));
            }
            case TEXT: {
                return new TimeValuePair(0L, new TsPrimitiveType.TsBinary(new Binary("")));
            }
        }
        throw new UnsupportedOperationException("Unrecognized datatype: " + dataType);
    }
}

