/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.fileSystem;

import java.io.File;
import java.net.URI;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.tsfile.fileSystem.FSType;

public enum SystemFileFactory {
    INSTANCE;

    private static FSType fsType;

    public File getFile(String pathname) {
        if (fsType.equals((Object)FSType.HDFS)) {
            throw new UnsupportedOperationException("Unsupported file system: " + fsType.name());
        }
        return new File(pathname);
    }

    public File getFile(String parent, String child) {
        if (fsType.equals((Object)FSType.HDFS)) {
            throw new UnsupportedOperationException("Unsupported file system: " + fsType.name());
        }
        return new File(parent, child);
    }

    public File getFile(File parent, String child) {
        if (fsType.equals((Object)FSType.HDFS)) {
            throw new UnsupportedOperationException("Unsupported file system: " + fsType.name());
        }
        return new File(parent, child);
    }

    public File getFile(URI uri) {
        if (fsType.equals((Object)FSType.HDFS)) {
            throw new UnsupportedOperationException("Unsupported file system: " + fsType.name());
        }
        return new File(uri);
    }

    static {
        fsType = IoTDBDescriptor.getInstance().getConfig().getSystemFileStorageFs();
    }
}

