/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.strategy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.iotdb.db.auth.AuthException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.LogicalOperatorException;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.executor.IQueryProcessExecutor;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.logical.crud.BasicFunctionOperator;
import org.apache.iotdb.db.qp.logical.crud.DeleteDataOperator;
import org.apache.iotdb.db.qp.logical.crud.FilterOperator;
import org.apache.iotdb.db.qp.logical.crud.InsertOperator;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.logical.sys.AuthorOperator;
import org.apache.iotdb.db.qp.logical.sys.CreateTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.DataAuthOperator;
import org.apache.iotdb.db.qp.logical.sys.DeleteStorageGroupOperator;
import org.apache.iotdb.db.qp.logical.sys.DeleteTimeSeriesOperator;
import org.apache.iotdb.db.qp.logical.sys.LoadDataOperator;
import org.apache.iotdb.db.qp.logical.sys.PropertyOperator;
import org.apache.iotdb.db.qp.logical.sys.SetStorageGroupOperator;
import org.apache.iotdb.db.qp.logical.sys.SetTTLOperator;
import org.apache.iotdb.db.qp.logical.sys.ShowTTLOperator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.FillQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.GroupByPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.sys.AuthorPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DataAuthPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.LoadDataPlan;
import org.apache.iotdb.db.qp.physical.sys.PropertyPlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTTLPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTTLPlan;
import org.apache.iotdb.db.service.TSServiceImpl;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.IExpression;

public class PhysicalGenerator {
    private IQueryProcessExecutor executor;

    public PhysicalGenerator(IQueryProcessExecutor executor) {
        this.executor = executor;
    }

    public PhysicalPlan transformToPhysicalPlan(Operator operator) throws QueryProcessException {
        switch (operator.getType()) {
            case AUTHOR: {
                AuthorOperator author = (AuthorOperator)operator;
                try {
                    return new AuthorPlan(author.getAuthorType(), author.getUserName(), author.getRoleName(), author.getPassWord(), author.getNewPassword(), author.getPrivilegeList(), author.getNodeName());
                }
                catch (AuthException e) {
                    throw new QueryProcessException(e.getMessage());
                }
            }
            case GRANT_WATERMARK_EMBEDDING: 
            case REVOKE_WATERMARK_EMBEDDING: {
                DataAuthOperator dataAuthOperator = (DataAuthOperator)operator;
                return new DataAuthPlan(dataAuthOperator.getType(), dataAuthOperator.getUsers());
            }
            case LOADDATA: {
                LoadDataOperator loadData = (LoadDataOperator)operator;
                return new LoadDataPlan(loadData.getInputFilePath(), loadData.getMeasureType());
            }
            case METADATA: 
            case SET_STORAGE_GROUP: {
                SetStorageGroupOperator setStorageGroup = (SetStorageGroupOperator)operator;
                return new SetStorageGroupPlan(setStorageGroup.getPath());
            }
            case DELETE_STORAGE_GROUP: {
                DeleteStorageGroupOperator deleteStorageGroup = (DeleteStorageGroupOperator)operator;
                return new DeleteStorageGroupPlan(deleteStorageGroup.getDeletePathList());
            }
            case CREATE_TIMESERIES: {
                CreateTimeSeriesOperator addPath = (CreateTimeSeriesOperator)operator;
                return new CreateTimeSeriesPlan(addPath.getPath(), addPath.getDataType(), addPath.getEncoding(), addPath.getCompressor(), addPath.getProps());
            }
            case DELETE_TIMESERIES: {
                DeleteTimeSeriesOperator deletePath = (DeleteTimeSeriesOperator)operator;
                return new DeleteTimeSeriesPlan(deletePath.getDeletePathList());
            }
            case PROPERTY: {
                PropertyOperator property = (PropertyOperator)operator;
                return new PropertyPlan(property.getPropertyType(), property.getPropertyPath(), property.getMetadataPath());
            }
            case DELETE: {
                DeleteDataOperator delete = (DeleteDataOperator)operator;
                List<Path> paths = delete.getSelectedPaths();
                return new DeletePlan(delete.getTime(), paths);
            }
            case INSERT: {
                InsertOperator insert = (InsertOperator)operator;
                List<Path> paths = insert.getSelectedPaths();
                if (paths.size() != 1) {
                    throw new LogicalOperatorException("For Insert command, cannot specified more than one seriesPath: " + paths);
                }
                return new InsertPlan(paths.get(0).getFullPath(), insert.getTime(), insert.getMeasurementList(), insert.getValueList());
            }
            case QUERY: {
                QueryOperator query = (QueryOperator)operator;
                return this.transformQuery(query);
            }
            case TTL: {
                switch (operator.getTokenIntType()) {
                    case 63: {
                        SetTTLOperator setTTLOperator = (SetTTLOperator)operator;
                        return new SetTTLPlan(setTTLOperator.getStorageGroup(), setTTLOperator.getDataTTL());
                    }
                    case 64: {
                        SetTTLOperator unsetTTLOperator = (SetTTLOperator)operator;
                        return new SetTTLPlan(unsetTTLOperator.getStorageGroup());
                    }
                    case 65: {
                        ShowTTLOperator showTTLOperator = (ShowTTLOperator)operator;
                        return new ShowTTLPlan(showTTLOperator.getStorageGroups());
                    }
                }
            }
        }
        throw new LogicalOperatorException(operator.getType().toString(), "");
    }

    private PhysicalPlan transformQuery(QueryOperator queryOperator) throws QueryProcessException {
        QueryPlan queryPlan;
        if (queryOperator.isGroupBy()) {
            queryPlan = new GroupByPlan();
            ((GroupByPlan)queryPlan).setUnit(queryOperator.getUnit());
            ((GroupByPlan)queryPlan).setOrigin(queryOperator.getOrigin());
            ((GroupByPlan)queryPlan).setIntervals(queryOperator.getIntervals());
            ((GroupByPlan)queryPlan).setAggregations(queryOperator.getSelectOperator().getAggregations());
        } else if (queryOperator.isFill()) {
            queryPlan = new FillQueryPlan();
            FilterOperator timeFilter = queryOperator.getFilterOperator();
            if (!timeFilter.isSingle()) {
                throw new QueryProcessException("Slice query must select a single time point");
            }
            long time = Long.parseLong(((BasicFunctionOperator)timeFilter).getValue());
            ((FillQueryPlan)queryPlan).setQueryTime(time);
            ((FillQueryPlan)queryPlan).setFillType(queryOperator.getFillTypes());
        } else if (queryOperator.hasAggregation()) {
            queryPlan = new AggregationPlan();
            ((AggregationPlan)queryPlan).setAggregations(queryOperator.getSelectOperator().getAggregations());
        } else {
            queryPlan = new QueryPlan();
        }
        if (!queryOperator.isGroupByDevice()) {
            List<Path> paths = queryOperator.getSelectedPaths();
            queryPlan.setPaths(paths);
        } else {
            List<Path> prefixPaths = queryOperator.getFromOperator().getPrefixPaths();
            List<Path> suffixPaths = queryOperator.getSelectOperator().getSuffixPaths();
            List<String> originAggregations = queryOperator.getSelectOperator().getAggregations();
            List<String> measurementColumnList = new ArrayList<String>();
            LinkedHashMap<String, Set<String>> measurementColumnsGroupByDevice = new LinkedHashMap<String, Set<String>>();
            HashMap<String, TSDataType> dataTypeConsistencyChecker = new HashMap<String, TSDataType>();
            HashSet<Path> allSelectPaths = new HashSet<Path>();
            for (int i = 0; i < suffixPaths.size(); ++i) {
                Path suffixPath = suffixPaths.get(i);
                HashSet deviceSetOfGivenSuffix = new HashSet();
                TreeSet<String> measurementSetOfGivenSuffix = new TreeSet<String>();
                for (Path prefixPath : prefixPaths) {
                    Path fullPath = Path.addPrefixPath((Path)suffixPath, (Path)prefixPath);
                    HashSet<String> tmpDeviceSet = new HashSet<String>();
                    try {
                        List<String> actualPaths = this.executor.getAllPaths(fullPath.getFullPath());
                        for (String pathStr : actualPaths) {
                            String measurementColumn;
                            String pathForDataType;
                            Path path = new Path(pathStr);
                            String device = path.getDevice();
                            tmpDeviceSet.add(device);
                            if (deviceSetOfGivenSuffix.contains(device)) continue;
                            String measurement = path.getMeasurement();
                            if (originAggregations != null && !originAggregations.isEmpty()) {
                                pathForDataType = originAggregations.get(i) + "(" + path.getFullPath() + ")";
                                measurementColumn = originAggregations.get(i) + "(" + measurement + ")";
                            } else {
                                pathForDataType = path.getFullPath();
                                measurementColumn = measurement;
                            }
                            TSDataType dataType = TSServiceImpl.getSeriesType(pathForDataType);
                            if (dataTypeConsistencyChecker.containsKey(measurementColumn)) {
                                if (!dataType.equals(dataTypeConsistencyChecker.get(measurementColumn))) {
                                    throw new QueryProcessException("The data types of the same measurement column should be the same across devices in GROUP_BY_DEVICE sql. For more details please refer to the SQL document.");
                                }
                            } else {
                                dataTypeConsistencyChecker.put(measurementColumn, dataType);
                            }
                            measurementSetOfGivenSuffix.add(measurementColumn);
                            if (!measurementColumnsGroupByDevice.containsKey(device)) {
                                measurementColumnsGroupByDevice.put(device, new HashSet());
                            }
                            ((Set)measurementColumnsGroupByDevice.get(device)).add(measurementColumn);
                            allSelectPaths.add(path);
                        }
                        deviceSetOfGivenSuffix.addAll(tmpDeviceSet);
                    }
                    catch (MetadataException e) {
                        throw new LogicalOptimizeException(String.format("Error when getting all paths of a full path: %s", fullPath.getFullPath()) + e.getMessage());
                    }
                }
                measurementColumnList.addAll(measurementSetOfGivenSuffix);
            }
            if (queryOperator.hasSlimit()) {
                int seriesSlimit = queryOperator.getSeriesLimit();
                int seriesOffset = queryOperator.getSeriesOffset();
                measurementColumnList = this.slimitTrimColumn(measurementColumnList, seriesSlimit, seriesOffset);
            }
            queryPlan.setGroupByDevice(true);
            queryPlan.setMeasurementColumnList(measurementColumnList);
            queryPlan.setMeasurementColumnsGroupByDevice(measurementColumnsGroupByDevice);
            queryPlan.setDataTypeConsistencyChecker(dataTypeConsistencyChecker);
            queryPlan.setPaths(new ArrayList<Path>(allSelectPaths));
        }
        queryPlan.checkPaths(this.executor);
        FilterOperator filterOperator = queryOperator.getFilterOperator();
        if (filterOperator != null) {
            IExpression expression = filterOperator.transformToExpression(this.executor);
            queryPlan.setExpression(expression);
        }
        return queryPlan;
    }

    private List<String> slimitTrimColumn(List<String> columnList, int seriesLimit, int seriesOffset) throws QueryProcessException {
        int size = columnList.size();
        if (seriesOffset >= size) {
            throw new QueryProcessException("SOFFSET <SOFFSETValue>: SOFFSETValue exceeds the range.");
        }
        int endPosition = seriesOffset + seriesLimit;
        if (endPosition > size) {
            endPosition = size;
        }
        return new ArrayList<String>(columnList.subList(seriesOffset, endPosition));
    }
}

